/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.tuple.Tuple;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class RecordIndexUniquenessViolation
extends RecordCoreException {
    @Nonnull
    private Index index;
    @Nullable
    private IndexEntry indexEntry;
    @Nullable
    private Tuple primaryKey;
    @Nullable
    private Tuple existingKey;

    public RecordIndexUniquenessViolation(@Nonnull Index index, IndexEntry indexEntry, Tuple primaryKey, Tuple existingKey) {
        super("Duplicate entry for unique index", new Object[]{LogMessageKeys.INDEX_NAME, index.getName(), LogMessageKeys.INDEX_KEY, indexEntry, "existing_primary_key", existingKey, LogMessageKeys.PRIMARY_KEY, primaryKey});
        this.index = index;
        this.indexEntry = indexEntry;
        this.primaryKey = primaryKey;
        this.existingKey = existingKey;
    }

    public RecordIndexUniquenessViolation(String message, RecordIndexUniquenessViolation cause) {
        super(message, cause);
        this.index = cause.index;
        this.indexEntry = cause.indexEntry;
        this.primaryKey = cause.primaryKey;
        this.existingKey = cause.existingKey;
    }

    @Nonnull
    public Index getIndex() {
        return this.index;
    }

    @Nullable
    public IndexEntry getIndexEntry() {
        return this.indexEntry;
    }

    @Nullable
    public Tuple getPrimaryKey() {
        return this.primaryKey;
    }

    @Nullable
    public Tuple getExistingKey() {
        return this.existingKey;
    }
}

