/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordMetaDataBuilder;
import com.apple.foundationdb.record.RecordMetaDataOptionsProto;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.TupleFieldsProto;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.FormerIndex;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.JoinedRecordType;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.SyntheticRecordType;
import com.apple.foundationdb.record.metadata.UnnestedRecordType;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.LiteralKeyExpression;
import com.apple.foundationdb.record.query.plan.cascades.UserDefinedFunction;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.serialization.DefaultPlanSerializationRegistry;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordPlanner;
import com.apple.foundationdb.record.util.MapUtils;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class RecordMetaData
implements RecordMetaDataProvider {
    @Nonnull
    private final Descriptors.FileDescriptor recordsDescriptor;
    @Nonnull
    private final Descriptors.Descriptor unionDescriptor;
    @Nonnull
    private final Map<Descriptors.Descriptor, Descriptors.FieldDescriptor> unionFields;
    @Nonnull
    private final Map<String, RecordType> recordTypes;
    @Nonnull
    private final Map<String, SyntheticRecordType<?>> syntheticRecordTypes;
    @Nonnull
    private final Map<Object, SyntheticRecordType<?>> recordTypeKeyToSyntheticTypeMap;
    @Nonnull
    private final Map<String, UserDefinedFunction> userDefinedFunctionMap;
    @Nonnull
    private final Map<String, Index> indexes;
    @Nonnull
    private final Map<String, Index> universalIndexes;
    @Nonnull
    private final List<FormerIndex> formerIndexes;
    private final boolean splitLongRecords;
    private final boolean storeRecordVersions;
    private final int version;
    private final long subspaceKeyCounter;
    private final boolean usesSubspaceKeyCounter;
    @Nullable
    private final KeyExpression recordCountKey;
    private final boolean usesLocalRecordsDescriptor;
    private final Map<Index, Collection<RecordType>> recordTypesForIndex;
    private static final Descriptors.FileDescriptor[] defaultExcludedDependencies = new Descriptors.FileDescriptor[]{RecordMetaDataProto.getDescriptor(), RecordMetaDataOptionsProto.getDescriptor(), TupleFieldsProto.getDescriptor()};

    protected RecordMetaData(@Nonnull RecordMetaData orig) {
        this(orig.getRecordsDescriptor(), orig.getUnionDescriptor(), Collections.unmodifiableMap(orig.unionFields), Collections.unmodifiableMap(orig.recordTypes), Collections.unmodifiableMap(orig.syntheticRecordTypes), Collections.unmodifiableMap(orig.recordTypeKeyToSyntheticTypeMap), Collections.unmodifiableMap(orig.indexes), Collections.unmodifiableMap(orig.universalIndexes), Collections.unmodifiableList(orig.formerIndexes), Collections.unmodifiableMap(orig.userDefinedFunctionMap), orig.splitLongRecords, orig.storeRecordVersions, orig.version, orig.subspaceKeyCounter, orig.usesSubspaceKeyCounter, orig.recordCountKey, orig.usesLocalRecordsDescriptor);
    }

    protected RecordMetaData(@Nonnull Descriptors.FileDescriptor recordsDescriptor, @Nonnull Descriptors.Descriptor unionDescriptor, @Nonnull Map<Descriptors.Descriptor, Descriptors.FieldDescriptor> unionFields, @Nonnull Map<String, RecordType> recordTypes, @Nonnull Map<String, SyntheticRecordType<?>> syntheticRecordTypes, @Nonnull Map<Object, SyntheticRecordType<?>> recordTypeKeyToSyntheticTypeMap, @Nonnull Map<String, Index> indexes, @Nonnull Map<String, Index> universalIndexes, @Nonnull List<FormerIndex> formerIndexes, @Nonnull Map<String, UserDefinedFunction> userDefinedFunctionMap, boolean splitLongRecords, boolean storeRecordVersions, int version, long subspaceKeyCounter, boolean usesSubspaceKeyCounter, @Nullable KeyExpression recordCountKey, boolean usesLocalRecordsDescriptor) {
        this.recordsDescriptor = recordsDescriptor;
        this.unionDescriptor = unionDescriptor;
        this.unionFields = unionFields;
        this.recordTypes = recordTypes;
        this.syntheticRecordTypes = syntheticRecordTypes;
        this.recordTypeKeyToSyntheticTypeMap = recordTypeKeyToSyntheticTypeMap;
        this.indexes = indexes;
        this.universalIndexes = universalIndexes;
        this.formerIndexes = formerIndexes;
        this.userDefinedFunctionMap = userDefinedFunctionMap;
        this.splitLongRecords = splitLongRecords;
        this.storeRecordVersions = storeRecordVersions;
        this.version = version;
        this.subspaceKeyCounter = subspaceKeyCounter;
        this.usesSubspaceKeyCounter = usesSubspaceKeyCounter;
        this.recordCountKey = recordCountKey;
        this.usesLocalRecordsDescriptor = usesLocalRecordsDescriptor;
        this.recordTypesForIndex = new ConcurrentHashMap<Index, Collection<RecordType>>();
    }

    @Nonnull
    public static RecordMetaDataBuilder newBuilder() {
        return new RecordMetaDataBuilder();
    }

    @Nonnull
    public Descriptors.FileDescriptor getRecordsDescriptor() {
        return this.recordsDescriptor;
    }

    @Nonnull
    public Descriptors.Descriptor getUnionDescriptor() {
        return this.unionDescriptor;
    }

    @Nonnull
    public Descriptors.FieldDescriptor getUnionFieldForRecordType(@Nonnull RecordType recordType) {
        Descriptors.FieldDescriptor unionField = this.unionFields.get(recordType.getDescriptor());
        if (unionField == null) {
            throw new MetaDataException("Record type " + recordType.getName() + " is not in the union", new Object[0]);
        }
        return unionField;
    }

    @Nonnull
    public Map<String, RecordType> getRecordTypes() {
        return this.recordTypes;
    }

    @Nonnull
    public RecordType getRecordType(@Nonnull String name) {
        RecordType recordType = this.recordTypes.get(name);
        if (recordType == null) {
            throw this.unknownTypeException(name);
        }
        return recordType;
    }

    @Nonnull
    public RecordType getRecordTypeForDescriptor(@Nonnull Descriptors.Descriptor descriptor) {
        RecordType recordType = this.getRecordType(descriptor.getName());
        if (recordType.getDescriptor() != descriptor) {
            throw new MetaDataException("descriptor did not match record type", new Object[0]);
        }
        return recordType;
    }

    @Nonnull
    public RecordType getRecordTypeFromRecordTypeKey(@Nonnull Object recordTypeKey) {
        for (RecordType recordType : this.recordTypes.values()) {
            if (!recordType.getRecordTypeKey().equals(recordTypeKey)) continue;
            return recordType;
        }
        throw new MetaDataException("Unknown record type key " + String.valueOf(recordTypeKey), new Object[0]);
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public Map<String, SyntheticRecordType<?>> getSyntheticRecordTypes() {
        return this.syntheticRecordTypes;
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public SyntheticRecordType<?> getSyntheticRecordType(@Nonnull String name) {
        SyntheticRecordType<?> recordType = this.syntheticRecordTypes.get(name);
        if (recordType == null) {
            throw new MetaDataException("Unknown synthetic record type " + name, new Object[0]);
        }
        return recordType;
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public SyntheticRecordType<?> getSyntheticRecordTypeFromRecordTypeKey(@Nonnull Object recordTypeKey) {
        SyntheticRecordType<?> recordType = this.recordTypeKeyToSyntheticTypeMap.get(recordTypeKey);
        if (recordType == null) {
            throw new MetaDataException("Unknown synthetic record type " + String.valueOf(recordTypeKey), new Object[0]);
        }
        return recordType;
    }

    public RecordType getIndexableRecordType(@Nonnull String name) {
        RecordType recordType = this.recordTypes.get(name);
        if (recordType == null) {
            recordType = this.syntheticRecordTypes.get(name);
        }
        if (recordType == null) {
            throw this.unknownTypeException(name);
        }
        return recordType;
    }

    public RecordType getQueryableRecordType(@Nonnull String name) {
        RecordType recordType = this.recordTypes.get(name);
        if (recordType == null) {
            recordType = this.syntheticRecordTypes.get(name);
        }
        if (recordType == null) {
            throw this.unknownTypeException(name);
        }
        return recordType;
    }

    @Nonnull
    public Index getIndex(@Nonnull String indexName) {
        Index index = this.indexes.get(indexName);
        if (null == index) {
            throw new MetaDataException("Index " + indexName + " not defined", new Object[0]);
        }
        return index;
    }

    public boolean hasIndex(@Nonnull String indexName) {
        return this.indexes.get(indexName) != null;
    }

    @Nonnull
    public List<Index> getAllIndexes() {
        return new ArrayList<Index>(this.indexes.values());
    }

    @Nonnull
    public Index getIndexFromSubspaceKey(@Nonnull Object subspaceKey) {
        for (Index index : this.indexes.values()) {
            if (!index.getSubspaceKey().equals(subspaceKey)) continue;
            return index;
        }
        throw new MetaDataException("Unknown index subspace key " + String.valueOf(subspaceKey), new Object[0]);
    }

    @Nonnull
    public Index getUniversalIndex(@Nonnull String indexName) {
        Index index = this.universalIndexes.get(indexName);
        if (null == index) {
            throw new MetaDataException("Index " + indexName + " not defined", new Object[0]);
        }
        return index;
    }

    public boolean hasUniversalIndex(@Nonnull String indexName) {
        return this.universalIndexes.get(indexName) != null;
    }

    @Nonnull
    public List<Index> getUniversalIndexes() {
        return new ArrayList<Index>(this.universalIndexes.values());
    }

    public List<FormerIndex> getFormerIndexes() {
        return this.formerIndexes;
    }

    public boolean isSplitLongRecords() {
        return this.splitLongRecords;
    }

    public boolean isStoreRecordVersions() {
        return this.storeRecordVersions;
    }

    public int getVersion() {
        return this.version;
    }

    public long getSubspaceKeyCounter() {
        return this.subspaceKeyCounter;
    }

    public boolean usesSubspaceKeyCounter() {
        return this.usesSubspaceKeyCounter;
    }

    public List<FormerIndex> getFormerIndexesSince(int version) {
        ArrayList<FormerIndex> result = new ArrayList<FormerIndex>();
        for (FormerIndex formerIndex : this.formerIndexes) {
            if (formerIndex.getRemovedVersion() <= version || formerIndex.getAddedVersion() > version) continue;
            result.add(formerIndex);
        }
        return result;
    }

    @Nonnull
    public Map<Index, List<RecordType>> getIndexesSince(int version) {
        HashMap<Index, List<RecordType>> result = new HashMap<Index, List<RecordType>>();
        for (RecordType recordType : this.recordTypes.values()) {
            for (Index index : recordType.getIndexes()) {
                if (index.getLastModifiedVersion() <= version) continue;
                result.put(index, Collections.singletonList(recordType));
            }
            for (Index index : recordType.getMultiTypeIndexes()) {
                if (index.getLastModifiedVersion() <= version) continue;
                if (!result.containsKey(index)) {
                    result.put(index, new ArrayList());
                }
                ((List)result.get(index)).add(recordType);
            }
        }
        for (Index index : this.universalIndexes.values()) {
            if (index.getLastModifiedVersion() <= version) continue;
            result.put(index, null);
        }
        for (SyntheticRecordType syntheticRecordType : this.syntheticRecordTypes.values()) {
            for (Index index : syntheticRecordType.getIndexes()) {
                if (index.getLastModifiedVersion() <= version) continue;
                List<RecordType> storedTypes = List.copyOf(SyntheticRecordPlanner.storedRecordTypesForIndex(this, index, List.of(syntheticRecordType)));
                result.put(index, storedTypes);
            }
            for (Index index : syntheticRecordType.getMultiTypeIndexes()) {
                if (index.getLastModifiedVersion() <= version) continue;
                if (!result.containsKey(index)) {
                    result.put(index, new ArrayList());
                }
                ((List)result.get(index)).addAll(SyntheticRecordPlanner.storedRecordTypesForIndex(this, index, List.of(syntheticRecordType)));
            }
        }
        return result;
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    public Map<Index, List<RecordType>> getIndexesToBuildSince(int version) {
        Map<Index, List<RecordType>> indexesToBuild = this.getIndexesSince(version);
        indexesToBuild.keySet().removeIf(index -> !index.getReplacedByIndexNames().isEmpty());
        return indexesToBuild;
    }

    @Nonnull
    public Collection<RecordType> recordTypesForIndex(@Nonnull Index index) {
        return MapUtils.computeIfAbsent(this.recordTypesForIndex, index, idx -> {
            if (this.hasUniversalIndex(idx.getName())) {
                return this.getRecordTypes().values();
            }
            ArrayList<RecordType> result = new ArrayList<RecordType>();
            for (RecordType recordType : this.getRecordTypes().values()) {
                if (recordType.getIndexes().contains(idx)) {
                    return Collections.singletonList(recordType);
                }
                if (!recordType.getMultiTypeIndexes().contains(idx)) continue;
                result.add(recordType);
            }
            for (SyntheticRecordType syntheticRecordType : this.getSyntheticRecordTypes().values()) {
                if (syntheticRecordType.getIndexes().contains(idx)) {
                    return Collections.singletonList(syntheticRecordType);
                }
                if (!syntheticRecordType.getMultiTypeIndexes().contains(idx)) continue;
                result.add(syntheticRecordType);
            }
            return result;
        });
    }

    @Nullable
    @API(value=API.Status.DEPRECATED)
    public KeyExpression getRecordCountKey() {
        return this.recordCountKey;
    }

    public boolean primaryKeyHasRecordTypePrefix() {
        return this.recordTypes.values().stream().allMatch(RecordType::primaryKeyHasRecordTypePrefix);
    }

    @Nullable
    public KeyExpression commonPrimaryKey() {
        return RecordMetaData.commonPrimaryKey(this.recordTypes.values());
    }

    @Nullable
    public static KeyExpression commonPrimaryKey(@Nonnull Collection<RecordType> recordTypes) {
        KeyExpression common = null;
        boolean first = true;
        for (RecordType recordType : recordTypes) {
            if (first) {
                common = recordType.getPrimaryKey();
                first = false;
                continue;
            }
            if (common.equals(recordType.getPrimaryKey())) continue;
            return null;
        }
        return common;
    }

    public static int commonPrimaryKeyLength(@Nonnull Collection<RecordType> recordTypes) {
        int common = -1;
        boolean first = true;
        for (RecordType recordType : recordTypes) {
            if (first) {
                common = recordType.getPrimaryKey().getColumnSize();
                first = false;
                continue;
            }
            if (common == recordType.getPrimaryKey().getColumnSize()) continue;
            return -1;
        }
        return common;
    }

    @Override
    @Nonnull
    public RecordMetaData getRecordMetaData() {
        return this;
    }

    @Nonnull
    public static RecordMetaData build(@Nonnull Descriptors.FileDescriptor descriptor) {
        return RecordMetaData.newBuilder().setRecords(descriptor).getRecordMetaData();
    }

    @Nonnull
    public static RecordMetaData build(@Nonnull RecordMetaDataProto.MetaData proto) {
        return RecordMetaData.newBuilder().setRecords(proto).getRecordMetaData();
    }

    private static void getDependencies(@Nonnull Descriptors.FileDescriptor fileDescriptor, @Nonnull Map<String, Descriptors.FileDescriptor> allDependencies, @Nullable Map<String, Descriptors.FileDescriptor> excludedDependencies) {
        for (Descriptors.FileDescriptor dependency : fileDescriptor.getDependencies()) {
            if (excludedDependencies != null && excludedDependencies.containsKey(dependency.getName())) continue;
            if (!allDependencies.containsKey(dependency.getName())) {
                allDependencies.put(dependency.getName(), dependency);
                RecordMetaData.getDependencies(dependency, allDependencies, excludedDependencies);
                continue;
            }
            if (allDependencies.get(dependency.getName()).equals(dependency)) continue;
            throw new MetaDataException("Dependency mismatch found for file", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.VALUE, dependency.getName()});
        }
    }

    @Nonnull
    public RecordMetaDataProto.MetaData toProto() {
        return this.toProto(defaultExcludedDependencies);
    }

    @Nonnull
    public RecordMetaDataProto.MetaData toProto(@Nullable Descriptors.FileDescriptor[] excludedDependencies) throws KeyExpression.SerializationException {
        if (this.usesLocalRecordsDescriptor) {
            throw new MetaDataException("cannot serialize meta-data with a local records descriptor to proto", new Object[0]);
        }
        RecordMetaDataProto.MetaData.Builder builder = RecordMetaDataProto.MetaData.newBuilder();
        builder.setRecords(this.recordsDescriptor.toProto());
        HashMap<String, Descriptors.FileDescriptor> excludeMap = null;
        if (excludedDependencies != null) {
            excludeMap = new HashMap<String, Descriptors.FileDescriptor>(excludedDependencies.length);
            for (Descriptors.FileDescriptor fileDescriptor : excludedDependencies) {
                excludeMap.put(fileDescriptor.getName(), fileDescriptor);
            }
        }
        TreeMap<String, Descriptors.FileDescriptor> allDependencies = new TreeMap<String, Descriptors.FileDescriptor>();
        RecordMetaData.getDependencies(this.recordsDescriptor, allDependencies, excludeMap);
        for (Descriptors.FileDescriptor dependency : allDependencies.values()) {
            builder.addDependencies(dependency.toProto());
        }
        TreeMap<String, RecordMetaDataProto.Index.Builder> indexBuilders = new TreeMap<String, RecordMetaDataProto.Index.Builder>();
        for (Map.Entry<String, Index> entry : this.indexes.entrySet()) {
            indexBuilders.put(entry.getKey(), entry.getValue().toProto().toBuilder());
        }
        for (RecordType recordType : this.getRecordTypes().values()) {
            for (Index index : recordType.getIndexes()) {
                ((RecordMetaDataProto.Index.Builder)indexBuilders.get(index.getName())).addRecordType(recordType.getName());
            }
            for (Index index : recordType.getMultiTypeIndexes()) {
                ((RecordMetaDataProto.Index.Builder)indexBuilders.get(index.getName())).addRecordType(recordType.getName());
            }
            RecordMetaDataProto.RecordType.Builder typeBuilder = builder.addRecordTypesBuilder().setName(recordType.getName()).setPrimaryKey(recordType.getPrimaryKey().toKeyExpression());
            if (recordType.getSinceVersion() != null) {
                typeBuilder.setSinceVersion(recordType.getSinceVersion());
            }
            if (!recordType.hasExplicitRecordTypeKey()) continue;
            typeBuilder.setExplicitKey(LiteralKeyExpression.toProtoValue(recordType.getExplicitRecordTypeKey()));
        }
        for (SyntheticRecordType syntheticRecordType : this.syntheticRecordTypes.values()) {
            if (syntheticRecordType instanceof JoinedRecordType) {
                builder.addJoinedRecordTypes(((JoinedRecordType)syntheticRecordType).toProto());
            } else if (syntheticRecordType instanceof UnnestedRecordType) {
                builder.addUnnestedRecordTypes(((UnnestedRecordType)syntheticRecordType).toProto());
            }
            for (Index syntheticIndex : syntheticRecordType.getIndexes()) {
                ((RecordMetaDataProto.Index.Builder)indexBuilders.get(syntheticIndex.getName())).addRecordType(syntheticRecordType.getName());
            }
        }
        indexBuilders.values().forEach(builder::addIndexes);
        for (FormerIndex formerIndex : this.getFormerIndexes()) {
            builder.addFormerIndexes(formerIndex.toProto());
        }
        PlanSerializationContext serializationContext = new PlanSerializationContext(DefaultPlanSerializationRegistry.INSTANCE, PlanHashable.CURRENT_FOR_CONTINUATION);
        builder.addAllUserDefinedFunctions(this.userDefinedFunctionMap.values().stream().map(func -> func.toProto(serializationContext)).collect(Collectors.toList()));
        builder.setSplitLongRecords(this.splitLongRecords);
        builder.setStoreRecordVersions(this.storeRecordVersions);
        builder.setVersion(this.version);
        if (this.usesSubspaceKeyCounter()) {
            builder.setSubspaceKeyCounter(this.subspaceKeyCounter);
            builder.setUsesSubspaceKeyCounter(true);
        }
        if (this.recordCountKey != null) {
            builder.setRecordCountKey(this.recordCountKey.toKeyExpression());
        }
        return builder.build();
    }

    @Nonnull
    public Map<String, Descriptors.FieldDescriptor> getFieldDescriptorMapFromNames(@Nonnull Collection<String> recordTypeNames) {
        return RecordMetaData.getFieldDescriptorMap(recordTypeNames.stream().map(this::getRecordType));
    }

    @Nonnull
    public Map<String, UserDefinedFunction> getUserDefinedFunctionMap() {
        return this.userDefinedFunctionMap;
    }

    @Nonnull
    public static Map<String, Descriptors.FieldDescriptor> getFieldDescriptorMapFromTypes(@Nonnull Collection<RecordType> recordTypes) {
        if (recordTypes.size() == 1) {
            RecordType recordType = Iterables.getOnlyElement(recordTypes);
            return Type.Record.toFieldDescriptorMap(recordType.getDescriptor().getFields());
        }
        return RecordMetaData.getFieldDescriptorMap(recordTypes.stream());
    }

    @Nonnull
    private static Map<String, Descriptors.FieldDescriptor> getFieldDescriptorMap(@Nonnull Stream<RecordType> recordTypeStream) {
        return recordTypeStream.sorted(Comparator.comparing(RecordType::getName)).flatMap(recordType -> recordType.getDescriptor().getFields().stream()).collect(Collectors.groupingBy(Descriptors.FieldDescriptor::getName, LinkedHashMap::new, Collectors.reducing(null, (fieldDescriptor, fieldDescriptor2) -> {
            Verify.verify(fieldDescriptor != null || fieldDescriptor2 != null);
            if (fieldDescriptor == null) {
                return fieldDescriptor2;
            }
            if (fieldDescriptor2 == null) {
                return fieldDescriptor;
            }
            if (fieldDescriptor.getType().getJavaType() == fieldDescriptor2.getType().getJavaType()) {
                return fieldDescriptor;
            }
            throw new IllegalArgumentException("cannot form union type of complex fields");
        })));
    }

    @Nonnull
    private MetaDataException unknownTypeException(@Nonnull String name) {
        return new MetaDataException("Unknown record type " + name, new Object[0]);
    }
}

