/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataOptionsProto;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.TupleFieldsProto;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.FormerIndex;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.JoinedRecordTypeBuilder;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.MetaDataEvolutionValidator;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.MetaDataValidator;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.RecordTypeBuilder;
import com.apple.foundationdb.record.metadata.RecordTypeIndexesBuilder;
import com.apple.foundationdb.record.metadata.SyntheticRecordType;
import com.apple.foundationdb.record.metadata.SyntheticRecordTypeBuilder;
import com.apple.foundationdb.record.metadata.UnnestedRecordTypeBuilder;
import com.apple.foundationdb.record.metadata.expressions.BaseKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.LiteralKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactoryRegistryImpl;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerRegistry;
import com.apple.foundationdb.record.provider.foundationdb.MetaDataProtoEditor;
import com.apple.foundationdb.record.query.plan.cascades.UserDefinedFunction;
import com.apple.foundationdb.record.query.plan.serialization.DefaultPlanSerializationRegistry;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class RecordMetaDataBuilder
implements RecordMetaDataProvider {
    private static final Descriptors.FileDescriptor[] emptyDependencyList = new Descriptors.FileDescriptor[0];
    public static final String DEFAULT_UNION_NAME = "RecordTypeUnion";
    @Nullable
    private Descriptors.FileDescriptor recordsDescriptor;
    @Nullable
    private Descriptors.Descriptor unionDescriptor;
    @Nullable
    private Descriptors.FileDescriptor localFileDescriptor;
    @Nonnull
    private final Map<Descriptors.Descriptor, Descriptors.FieldDescriptor> unionFields;
    @Nonnull
    private final Map<String, RecordTypeBuilder> recordTypes = new HashMap<String, RecordTypeBuilder>();
    @Nonnull
    private final Map<String, SyntheticRecordTypeBuilder<?>> syntheticRecordTypes;
    @Nonnull
    private final Map<String, UserDefinedFunction> userDefinedFunctionMap;
    @Nonnull
    private final Map<String, Index> indexes = new HashMap<String, Index>();
    @Nonnull
    private final Map<String, Index> universalIndexes = new HashMap<String, Index>();
    private boolean splitLongRecords;
    private boolean storeRecordVersions;
    private int version;
    @Nonnull
    private final List<FormerIndex> formerIndexes = new ArrayList<FormerIndex>();
    @Nonnull
    private IndexMaintainerRegistry indexMaintainerRegistry;
    @Nonnull
    private MetaDataEvolutionValidator evolutionValidator;
    @Nullable
    private KeyExpression recordCountKey;
    @Nullable
    private RecordMetaData recordMetaData;
    @Nonnull
    private final Map<String, Descriptors.FileDescriptor> explicitDependencies;
    private long subspaceKeyCounter = 0L;
    private boolean usesSubspaceKeyCounter = false;

    RecordMetaDataBuilder() {
        this.unionFields = new HashMap<Descriptors.Descriptor, Descriptors.FieldDescriptor>();
        this.explicitDependencies = new TreeMap<String, Descriptors.FileDescriptor>();
        this.indexMaintainerRegistry = IndexMaintainerFactoryRegistryImpl.instance();
        this.evolutionValidator = MetaDataEvolutionValidator.getDefaultInstance();
        this.syntheticRecordTypes = new HashMap();
        this.userDefinedFunctionMap = new HashMap<String, UserDefinedFunction>();
    }

    private void processSchemaOptions(boolean processExtensionOptions) {
        RecordMetaDataOptionsProto.SchemaOptions schemaOptions;
        if (processExtensionOptions && (schemaOptions = this.recordsDescriptor.getOptions().getExtension(RecordMetaDataOptionsProto.schema)) != null) {
            if (schemaOptions.hasSplitLongRecords()) {
                this.splitLongRecords = schemaOptions.getSplitLongRecords();
            }
            if (schemaOptions.hasStoreRecordVersions()) {
                this.storeRecordVersions = schemaOptions.getStoreRecordVersions();
            }
        }
    }

    private void loadProtoExceptRecords(@Nonnull RecordMetaDataProto.MetaData metaDataProto) {
        RecordTypeIndexesBuilder typeBuilder;
        for (RecordMetaDataProto.JoinedRecordType joinedProto : metaDataProto.getJoinedRecordTypesList()) {
            typeBuilder = new JoinedRecordTypeBuilder(joinedProto, this);
            this.syntheticRecordTypes.put(typeBuilder.getName(), (SyntheticRecordTypeBuilder<?>)typeBuilder);
        }
        for (RecordMetaDataProto.UnnestedRecordType unnestedProto : metaDataProto.getUnnestedRecordTypesList()) {
            typeBuilder = new UnnestedRecordTypeBuilder(unnestedProto, this);
            this.syntheticRecordTypes.put(typeBuilder.getName(), (SyntheticRecordTypeBuilder<?>)typeBuilder);
        }
        for (RecordMetaDataProto.Index indexProto : metaDataProto.getIndexesList()) {
            ArrayList<RecordTypeBuilder> recordTypeBuilders = new ArrayList<RecordTypeBuilder>(indexProto.getRecordTypeCount());
            ArrayList syntheticRecordTypeBuilders = new ArrayList(indexProto.getRecordTypeCount());
            for (String recordTypeName : indexProto.getRecordTypeList()) {
                RecordTypeBuilder recordTypeBuilder = this.recordTypes.get(recordTypeName);
                if (recordTypeBuilder != null) {
                    recordTypeBuilders.add(this.getRecordType(recordTypeName));
                    continue;
                }
                SyntheticRecordTypeBuilder<?> syntheticRecordTypeBuilder = this.syntheticRecordTypes.get(recordTypeName);
                if (syntheticRecordTypeBuilder != null) {
                    syntheticRecordTypeBuilders.add(syntheticRecordTypeBuilder);
                    continue;
                }
                this.throwUnknownRecordType(recordTypeName, false);
            }
            if (!syntheticRecordTypeBuilders.isEmpty()) {
                try {
                    Index index = new Index(indexProto);
                    this.addIndexCommon(index);
                    for (SyntheticRecordTypeBuilder syntheticRecordTypeBuilder : syntheticRecordTypeBuilders) {
                        syntheticRecordTypeBuilder.getIndexes().add(index);
                    }
                    continue;
                }
                catch (KeyExpression.DeserializationException e) {
                    throw new MetaDataProtoDeserializationException(e);
                }
            }
            try {
                this.addMultiTypeIndex(recordTypeBuilders, new Index(indexProto));
            }
            catch (KeyExpression.DeserializationException e) {
                throw new MetaDataProtoDeserializationException(e);
            }
        }
        for (RecordMetaDataProto.RecordType typeProto : metaDataProto.getRecordTypesList()) {
            typeBuilder = this.getRecordType(typeProto.getName());
            if (typeProto.hasPrimaryKey()) {
                try {
                    ((RecordTypeBuilder)typeBuilder).setPrimaryKey(KeyExpression.fromProto(typeProto.getPrimaryKey()));
                }
                catch (KeyExpression.DeserializationException e) {
                    throw new MetaDataProtoDeserializationException(e);
                }
            }
            if (typeProto.hasSinceVersion()) {
                ((RecordTypeBuilder)typeBuilder).setSinceVersion(typeProto.getSinceVersion());
            }
            if (!typeProto.hasExplicitKey()) continue;
            ((RecordTypeBuilder)typeBuilder).setRecordTypeKey(LiteralKeyExpression.fromProtoValue(typeProto.getExplicitKey()));
        }
        for (RecordMetaDataProto.PUserDefinedFunction function : metaDataProto.getUserDefinedFunctionsList()) {
            UserDefinedFunction func = (UserDefinedFunction)PlanSerialization.dispatchFromProtoContainer(new PlanSerializationContext(DefaultPlanSerializationRegistry.INSTANCE, PlanHashable.CURRENT_FOR_CONTINUATION), function);
            this.userDefinedFunctionMap.put(func.getFunctionName(), func);
        }
        if (metaDataProto.hasSplitLongRecords()) {
            this.splitLongRecords = metaDataProto.getSplitLongRecords();
        }
        if (metaDataProto.hasStoreRecordVersions()) {
            this.storeRecordVersions = metaDataProto.getStoreRecordVersions();
        }
        for (RecordMetaDataProto.FormerIndex formerIndex : metaDataProto.getFormerIndexesList()) {
            this.formerIndexes.add(new FormerIndex(formerIndex));
        }
        if (metaDataProto.hasRecordCountKey()) {
            try {
                this.recordCountKey = KeyExpression.fromProto(metaDataProto.getRecordCountKey());
            }
            catch (KeyExpression.DeserializationException e) {
                throw new MetaDataProtoDeserializationException(e);
            }
        }
        if (metaDataProto.hasVersion()) {
            this.version = metaDataProto.getVersion();
        }
    }

    private void loadFromProto(@Nonnull RecordMetaDataProto.MetaData metaDataProto, @Nonnull Descriptors.FileDescriptor[] dependencies, boolean processExtensionOptions) {
        this.recordsDescriptor = RecordMetaDataBuilder.buildFileDescriptor(metaDataProto.getRecords(), dependencies);
        this.loadSubspaceKeySettingsFromProto(metaDataProto);
        this.initRecordTypesAndUnion(processExtensionOptions);
        this.loadProtoExceptRecords(metaDataProto);
        this.processSchemaOptions(processExtensionOptions);
        if (this.localFileDescriptor != null) {
            Descriptors.Descriptor localUnionDescriptor = this.fetchLocalUnionDescriptor();
            this.evolutionValidator.validateUnion(this.unionDescriptor, localUnionDescriptor);
            this.updateUnionFieldsAndRecordTypesFromLocal(localUnionDescriptor);
            this.unionDescriptor = localUnionDescriptor;
        }
    }

    private void loadSubspaceKeySettingsFromProto(RecordMetaDataProto.MetaData metaDataProto) {
        if (metaDataProto.hasSubspaceKeyCounter() && !metaDataProto.getUsesSubspaceKeyCounter()) {
            throw new MetaDataProtoDeserializationException(new MetaDataException("subspaceKeyCounter is set but usesSubspaceKeyCounter is not set in the meta-data proto", new Object[0]));
        }
        if (metaDataProto.getUsesSubspaceKeyCounter() && !metaDataProto.hasSubspaceKeyCounter()) {
            throw new MetaDataProtoDeserializationException(new MetaDataException("usesSubspaceKeyCounter is set but subspaceKeyCounter is not set in the meta-data proto", new Object[0]));
        }
        if (!this.usesSubspaceKeyCounter()) {
            this.usesSubspaceKeyCounter = metaDataProto.getUsesSubspaceKeyCounter();
        }
        this.subspaceKeyCounter = Long.max(this.subspaceKeyCounter, metaDataProto.getSubspaceKeyCounter());
    }

    private void loadFromFileDescriptor(@Nonnull Descriptors.FileDescriptor fileDescriptor, boolean processExtensionOptions) {
        this.recordsDescriptor = fileDescriptor;
        this.initRecordTypesAndUnion(processExtensionOptions);
        this.processSchemaOptions(processExtensionOptions);
    }

    private void initRecordTypesAndUnion(boolean processExtensionOptions) {
        if (this.recordsDescriptor == null) {
            throw new RecordCoreException("cannot initiate records from null file descriptor", new Object[0]);
        }
        this.unionDescriptor = RecordMetaDataBuilder.fetchUnionDescriptor(this.recordsDescriptor);
        RecordMetaDataBuilder.validateRecords(this.recordsDescriptor, this.unionDescriptor);
        this.fillUnionFields(processExtensionOptions);
    }

    @Nonnull
    private static Descriptors.Descriptor fetchUnionDescriptor(@Nonnull Descriptors.FileDescriptor fileDescriptor) {
        Descriptors.Descriptor union = null;
        block4: for (Descriptors.Descriptor descriptor : fileDescriptor.getMessageTypes()) {
            RecordMetaDataOptionsProto.RecordTypeOptions recordTypeOptions = descriptor.getOptions().getExtension(RecordMetaDataOptionsProto.record);
            if (recordTypeOptions != null && recordTypeOptions.hasUsage()) {
                switch (recordTypeOptions.getUsage()) {
                    case UNION: {
                        if (union != null) {
                            throw new MetaDataException("Only one union descriptor is allowed", new Object[0]);
                        }
                        union = descriptor;
                        continue block4;
                    }
                    case NESTED: {
                        if (!DEFAULT_UNION_NAME.equals(descriptor.getName())) continue block4;
                        throw new MetaDataException("Message type RecordTypeUnion cannot have NESTED usage", new Object[0]);
                    }
                }
            }
            if (!DEFAULT_UNION_NAME.equals(descriptor.getName())) continue;
            if (union != null) {
                throw new MetaDataException("Only one union descriptor is allowed", new Object[0]);
            }
            union = descriptor;
        }
        if (union == null) {
            throw new MetaDataException("Union descriptor is required", new Object[0]);
        }
        return union;
    }

    @Nonnull
    private static Map<String, Descriptors.FileDescriptor> initGeneratedDependencies(@Nonnull Map<String, DescriptorProtos.FileDescriptorProto> protoDependencies) {
        TreeMap<String, Descriptors.FileDescriptor> generatedDependencies = new TreeMap<String, Descriptors.FileDescriptor>();
        if (!protoDependencies.containsKey(TupleFieldsProto.getDescriptor().getName())) {
            generatedDependencies.put(TupleFieldsProto.getDescriptor().getName(), TupleFieldsProto.getDescriptor());
        }
        if (!protoDependencies.containsKey(RecordMetaDataOptionsProto.getDescriptor().getName())) {
            generatedDependencies.put(RecordMetaDataOptionsProto.getDescriptor().getName(), RecordMetaDataOptionsProto.getDescriptor());
        }
        if (!protoDependencies.containsKey(RecordMetaDataProto.getDescriptor().getName())) {
            generatedDependencies.put(RecordMetaDataProto.getDescriptor().getName(), RecordMetaDataProto.getDescriptor());
        }
        return generatedDependencies;
    }

    @Nonnull
    public RecordMetaDataBuilder setRecords(@Nonnull RecordMetaDataProto.MetaData metaDataProto) {
        return this.setRecords(metaDataProto, false);
    }

    @Nonnull
    public RecordMetaDataBuilder setRecords(@Nonnull RecordMetaDataProto.MetaData metaDataProto, boolean processExtensionOptions) {
        if (this.recordsDescriptor != null) {
            throw new MetaDataException("Records already set.", new Object[0]);
        }
        Descriptors.FileDescriptor[] dependencies = RecordMetaDataBuilder.getDependencies(metaDataProto, this.explicitDependencies);
        this.loadFromProto(metaDataProto, dependencies, processExtensionOptions);
        return this;
    }

    @API(value=API.Status.INTERNAL)
    public static Descriptors.FileDescriptor[] getDependencies(@Nonnull RecordMetaDataProto.MetaData metaDataProto, @Nonnull Map<String, Descriptors.FileDescriptor> explicitDependencies) {
        TreeMap<String, DescriptorProtos.FileDescriptorProto> protoDependencies = new TreeMap<String, DescriptorProtos.FileDescriptorProto>();
        for (DescriptorProtos.FileDescriptorProto dependency : metaDataProto.getDependenciesList()) {
            protoDependencies.put(dependency.getName(), dependency);
        }
        Map<String, Descriptors.FileDescriptor> generatedDependencies = RecordMetaDataBuilder.initGeneratedDependencies(protoDependencies);
        return RecordMetaDataBuilder.getDependencies(metaDataProto.getRecords(), generatedDependencies, protoDependencies, explicitDependencies);
    }

    @Nonnull
    public RecordMetaDataBuilder setRecords(@Nonnull Descriptors.FileDescriptor fileDescriptor) {
        return this.setRecords(fileDescriptor, true);
    }

    @Nonnull
    public RecordMetaDataBuilder setRecords(@Nonnull Descriptors.FileDescriptor fileDescriptor, boolean processExtensionOptions) {
        if (this.recordsDescriptor != null) {
            throw new MetaDataException("Records already set.", new Object[0]);
        }
        if (this.localFileDescriptor != null) {
            throw new MetaDataException("Cannot set records from file descriptor when local descriptor is specified.", new Object[0]);
        }
        if (!this.explicitDependencies.isEmpty()) {
            throw new MetaDataException("Cannot set records from file descriptor when explicit dependencies are specified.", new Object[0]);
        }
        this.loadFromFileDescriptor(fileDescriptor, processExtensionOptions);
        return this;
    }

    public void updateRecords(@Nonnull Descriptors.FileDescriptor recordsDescriptor) {
        this.updateRecords(recordsDescriptor, true);
    }

    public void updateRecords(@Nonnull Descriptors.FileDescriptor newRecordsDescriptor, boolean processExtensionOptions) {
        if (this.recordsDescriptor == null) {
            throw new MetaDataException("Records descriptor is not set yet", new Object[0]);
        }
        if (this.localFileDescriptor != null) {
            throw new MetaDataException("Updating the records descriptor is not allowed when the local file descriptor is set", new Object[0]);
        }
        if (this.unionDescriptor == null) {
            throw new RecordCoreException("cannot update record types as no previous union descriptor has been set", new Object[0]);
        }
        Descriptors.Descriptor newUnionDescriptor = RecordMetaDataBuilder.fetchUnionDescriptor(newRecordsDescriptor);
        RecordMetaDataBuilder.validateRecords(newRecordsDescriptor, newUnionDescriptor);
        this.evolutionValidator.validateUnion(this.unionDescriptor, newUnionDescriptor);
        ++this.version;
        this.updateUnionFieldsAndRecordTypes(newUnionDescriptor, processExtensionOptions);
        this.recordsDescriptor = newRecordsDescriptor;
        this.unionDescriptor = newUnionDescriptor;
    }

    @Nonnull
    public RecordMetaDataBuilder setLocalFileDescriptor(@Nonnull Descriptors.FileDescriptor localFileDescriptor) {
        if (this.recordsDescriptor != null) {
            throw new MetaDataException("Records already set.", new Object[0]);
        }
        this.localFileDescriptor = localFileDescriptor;
        return this;
    }

    @Nonnull
    private Descriptors.Descriptor buildSyntheticUnion(@Nonnull Descriptors.FileDescriptor parentFileDescriptor) {
        if (this.unionDescriptor == null) {
            throw new RecordCoreException("cannot build a synthetic union descriptor as no prior existing union descriptor has been set", new Object[0]);
        }
        DescriptorProtos.FileDescriptorProto.Builder builder = DescriptorProtos.FileDescriptorProto.newBuilder();
        builder.setName("_synthetic_" + parentFileDescriptor.getName());
        builder.addMessageType(MetaDataProtoEditor.createSyntheticUnion(parentFileDescriptor, this.unionDescriptor));
        builder.addDependency(parentFileDescriptor.getName());
        return RecordMetaDataBuilder.fetchUnionDescriptor(RecordMetaDataBuilder.buildFileDescriptor(builder.build(), new Descriptors.FileDescriptor[]{parentFileDescriptor}));
    }

    @Nonnull
    private Descriptors.Descriptor fetchLocalUnionDescriptor() {
        if (this.localFileDescriptor == null) {
            throw new RecordCoreException("cannot fetch local union descriptor as no local file is set", new Object[0]);
        }
        Descriptors.Descriptor localUnionDescriptor = MetaDataProtoEditor.hasUnion(this.localFileDescriptor) ? RecordMetaDataBuilder.fetchUnionDescriptor(this.localFileDescriptor) : this.buildSyntheticUnion(this.localFileDescriptor);
        RecordMetaDataBuilder.validateRecords(this.localFileDescriptor, localUnionDescriptor);
        return localUnionDescriptor;
    }

    @Nonnull
    public RecordMetaDataBuilder addDependency(@Nonnull Descriptors.FileDescriptor fileDescriptor) {
        if (this.recordsDescriptor != null) {
            throw new MetaDataException("Records already set. Adding dependencies not allowed.", new Object[0]);
        }
        this.explicitDependencies.put(fileDescriptor.getName(), fileDescriptor);
        return this;
    }

    @Nonnull
    public RecordMetaDataBuilder addDependencies(@Nonnull Descriptors.FileDescriptor[] fileDescriptors) {
        if (this.recordsDescriptor != null) {
            throw new MetaDataException("Records already set. Adding dependencies not allowed.", new Object[0]);
        }
        for (Descriptors.FileDescriptor fileDescriptor : fileDescriptors) {
            this.explicitDependencies.put(fileDescriptor.getName(), fileDescriptor);
        }
        return this;
    }

    private static Descriptors.FileDescriptor[] getDependencies(@Nonnull DescriptorProtos.FileDescriptorProto proto, @Nonnull Map<String, Descriptors.FileDescriptor> generatedDependencies, @Nonnull Map<String, DescriptorProtos.FileDescriptorProto> protoDependencies, @Nonnull Map<String, Descriptors.FileDescriptor> explicitDependencies) {
        if (proto.getDependencyCount() == 0) {
            return emptyDependencyList;
        }
        Descriptors.FileDescriptor[] dependencies = new Descriptors.FileDescriptor[proto.getDependencyCount()];
        for (int index = 0; index < proto.getDependencyCount(); ++index) {
            String key = proto.getDependency(index);
            if (explicitDependencies.containsKey(key)) {
                dependencies[index] = explicitDependencies.get(key);
                continue;
            }
            if (generatedDependencies.containsKey(key)) {
                dependencies[index] = generatedDependencies.get(key);
                continue;
            }
            if (protoDependencies.containsKey(key)) {
                DescriptorProtos.FileDescriptorProto dependency = protoDependencies.get(key);
                dependencies[index] = RecordMetaDataBuilder.buildFileDescriptor(dependency, RecordMetaDataBuilder.getDependencies(dependency, generatedDependencies, protoDependencies, explicitDependencies));
                generatedDependencies.put(key, dependencies[index]);
                continue;
            }
            throw new MetaDataException("Dependency not found", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.VALUE, key});
        }
        return dependencies;
    }

    private static void validateRecords(@Nonnull Descriptors.FileDescriptor fileDescriptor, @Nonnull Descriptors.Descriptor unionDescriptor) {
        RecordMetaDataBuilder.validateDataTypes(fileDescriptor);
        RecordMetaDataBuilder.validateUnion(fileDescriptor, unionDescriptor);
    }

    private static void validateDataTypes(@Nonnull Descriptors.FileDescriptor fileDescriptor) {
        ArrayDeque<Descriptors.Descriptor> toValidate = new ArrayDeque<Descriptors.Descriptor>(fileDescriptor.getMessageTypes());
        HashSet<Descriptors.Descriptor> seen = new HashSet<Descriptors.Descriptor>();
        while (!toValidate.isEmpty()) {
            Descriptors.Descriptor descriptor = (Descriptors.Descriptor)toValidate.remove();
            if (!seen.add(descriptor)) continue;
            block6: for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
                switch (field.getType()) {
                    case INT32: 
                    case INT64: 
                    case SFIXED32: 
                    case SFIXED64: 
                    case SINT32: 
                    case SINT64: 
                    case BOOL: 
                    case STRING: 
                    case BYTES: 
                    case FLOAT: 
                    case DOUBLE: 
                    case ENUM: {
                        continue block6;
                    }
                    case MESSAGE: 
                    case GROUP: {
                        if (seen.contains(field.getMessageType())) continue block6;
                        toValidate.add(field.getMessageType());
                        continue block6;
                    }
                    case FIXED32: 
                    case FIXED64: 
                    case UINT32: 
                    case UINT64: {
                        throw new MetaDataException("Field " + field.getName() + " in message " + descriptor.getFullName() + " has illegal unsigned type " + field.getType().name(), new Object[0]);
                    }
                }
                throw new MetaDataException("Field " + field.getName() + " in message " + descriptor.getFullName() + " has unknown type " + field.getType().name(), new Object[0]);
            }
        }
    }

    private static void validateUnion(@Nonnull Descriptors.FileDescriptor fileDescriptor, @Nonnull Descriptors.Descriptor unionDescriptor) {
        for (Descriptors.FieldDescriptor unionField : unionDescriptor.getFields()) {
            if (unionField.getType() != Descriptors.FieldDescriptor.Type.MESSAGE) {
                throw new MetaDataException("Union field " + unionField.getName() + " is not a message", new Object[0]);
            }
            if (unionField.isRepeated()) {
                throw new MetaDataException("Union field " + unionField.getName() + " should not be repeated", new Object[0]);
            }
            Descriptors.Descriptor descriptor = unionField.getMessageType();
            if (DEFAULT_UNION_NAME.equals(descriptor.getName())) {
                throw new MetaDataException("Union message type " + descriptor.getName() + " cannot be a union field.", new Object[0]);
            }
            RecordMetaDataOptionsProto.RecordTypeOptions recordTypeOptions = descriptor.getOptions().getExtension(RecordMetaDataOptionsProto.record);
            if (recordTypeOptions == null || !recordTypeOptions.hasUsage() || recordTypeOptions.getUsage() == RecordMetaDataOptionsProto.RecordTypeOptions.Usage.RECORD) continue;
            throw new MetaDataException("Union field " + unionField.getName() + " has type " + descriptor.getName() + " which is not a record", new Object[0]);
        }
        for (Descriptors.Descriptor descriptor : fileDescriptor.getMessageTypes()) {
            RecordMetaDataOptionsProto.RecordTypeOptions recordTypeOptions = descriptor.getOptions().getExtension(RecordMetaDataOptionsProto.record);
            if (recordTypeOptions == null || !recordTypeOptions.hasUsage()) continue;
            switch (recordTypeOptions.getUsage()) {
                case RECORD: {
                    if (DEFAULT_UNION_NAME.equals(descriptor.getName())) {
                        if (!RecordMetaDataBuilder.unionHasMessageType(unionDescriptor, descriptor)) break;
                        throw new MetaDataException("Union message type " + descriptor.getName() + " cannot be a union field.", new Object[0]);
                    }
                    if (RecordMetaDataBuilder.unionHasMessageType(unionDescriptor, descriptor)) break;
                    throw new MetaDataException("Record message type " + descriptor.getName() + " must be a union field.", new Object[0]);
                }
            }
        }
    }

    private static boolean unionHasMessageType(@Nonnull Descriptors.Descriptor unionDescriptor, @Nonnull Descriptors.Descriptor descriptor) {
        return unionDescriptor.getFields().stream().anyMatch(field -> descriptor == field.getMessageType());
    }

    private void updateUnionFieldsAndRecordTypes(@Nonnull Descriptors.Descriptor union, boolean processExtensionOptions) {
        ImmutableMap<String, RecordTypeBuilder> oldRecordTypes = ImmutableMap.copyOf(this.recordTypes);
        this.recordTypes.clear();
        this.unionFields.clear();
        for (Descriptors.FieldDescriptor unionField : union.getFields()) {
            Descriptors.Descriptor newDescriptor = unionField.getMessageType();
            Descriptors.Descriptor oldDescriptor = this.findOldDescriptor(unionField, union);
            if (this.unionFields.containsKey(newDescriptor)) {
                if (!this.recordTypes.containsKey(newDescriptor.getName())) {
                    throw new MetaDataException("Unknown record type for union field " + unionField.getName(), new Object[0]);
                }
                this.remapUnionField(newDescriptor, unionField);
                continue;
            }
            if (oldDescriptor == null) {
                RecordTypeBuilder recordType = this.processRecordType(unionField, processExtensionOptions);
                if (recordType.getSinceVersion() != null && recordType.getSinceVersion() != this.version) {
                    throw new MetaDataException("Record type since version does not match meta-data version", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.META_DATA_VERSION, this.version}).addLogInfo("since_version", (Object)recordType.getSinceVersion()).addLogInfo(new Object[]{LogMessageKeys.RECORD_TYPE, recordType.getName()});
                }
                recordType.setSinceVersion(this.version);
                this.unionFields.put(newDescriptor, unionField);
                continue;
            }
            this.updateRecordType(oldRecordTypes, oldDescriptor, newDescriptor);
            this.unionFields.put(newDescriptor, unionField);
        }
    }

    private void updateUnionFieldsAndRecordTypesFromLocal(@Nonnull Descriptors.Descriptor union) {
        ImmutableMap<String, RecordTypeBuilder> oldRecordTypes = ImmutableMap.copyOf(this.recordTypes);
        ImmutableMap<Descriptors.Descriptor, Descriptors.FieldDescriptor> oldUnionFields = ImmutableMap.copyOf(this.unionFields);
        this.recordTypes.clear();
        this.unionFields.clear();
        for (Descriptors.FieldDescriptor unionField : union.getFields()) {
            Descriptors.Descriptor newDescriptor = unionField.getMessageType();
            Descriptors.Descriptor oldDescriptor = this.findOldDescriptor(unionField, union);
            if (oldDescriptor == null) continue;
            if (this.unionFields.containsKey(newDescriptor)) {
                if (!this.recordTypes.containsKey(newDescriptor.getName())) {
                    throw new MetaDataException("Unknown record type for union field " + unionField.getName(), new Object[0]);
                }
                Descriptors.FieldDescriptor oldUnionField = Verify.verifyNotNull((Descriptors.FieldDescriptor)oldUnionFields.get(oldDescriptor));
                if (unionField.getNumber() != oldUnionField.getNumber()) continue;
                this.unionFields.put(newDescriptor, unionField);
                continue;
            }
            this.updateRecordType(oldRecordTypes, oldDescriptor, newDescriptor);
            this.unionFields.put(newDescriptor, unionField);
        }
    }

    @Nullable
    private static Descriptors.Descriptor getCorrespondingFieldType(@Nonnull Descriptors.Descriptor descriptor, @Nonnull Descriptors.FieldDescriptor field) {
        Descriptors.FieldDescriptor correspondingField = descriptor.findFieldByNumber(field.getNumber());
        if (correspondingField != null) {
            return correspondingField.getMessageType();
        }
        return null;
    }

    @Nullable
    private Descriptors.Descriptor findOldDescriptor(@Nonnull Descriptors.FieldDescriptor newUnionField, @Nonnull Descriptors.Descriptor newUnion) {
        if (this.unionDescriptor == null) {
            throw new RecordCoreException("cannot get field from union as it has not been set", new Object[0]);
        }
        Descriptors.Descriptor correspondingFieldType = RecordMetaDataBuilder.getCorrespondingFieldType(this.unionDescriptor, newUnionField);
        if (correspondingFieldType != null) {
            return correspondingFieldType;
        }
        Descriptors.Descriptor newDescriptor = newUnionField.getMessageType();
        for (Descriptors.FieldDescriptor otherNewUnionField : newUnion.getFields()) {
            Descriptors.Descriptor otherCorrespondingFieldType;
            if (otherNewUnionField.getMessageType() != newDescriptor || (otherCorrespondingFieldType = RecordMetaDataBuilder.getCorrespondingFieldType(this.unionDescriptor, otherNewUnionField)) == null) continue;
            return otherCorrespondingFieldType;
        }
        return null;
    }

    private void updateRecordType(@Nonnull Map<String, RecordTypeBuilder> oldRecordTypes, @Nonnull Descriptors.Descriptor oldDescriptor, @Nonnull Descriptors.Descriptor newDescriptor) {
        RecordTypeBuilder oldRecordType = oldRecordTypes.get(oldDescriptor.getName());
        RecordTypeBuilder newRecordType = new RecordTypeBuilder(newDescriptor, oldRecordType);
        this.recordTypes.put(newRecordType.getName(), newRecordType);
    }

    private void fillUnionFields(boolean processExtensionOptions) {
        if (this.unionDescriptor == null) {
            throw new RecordCoreException("cannot fill union fiends as no union descriptor has been set", new Object[0]);
        }
        if (!this.unionFields.isEmpty()) {
            throw new RecordCoreException("cannot set union fields twice", new Object[0]);
        }
        for (Descriptors.FieldDescriptor unionField : this.unionDescriptor.getFields()) {
            Descriptors.Descriptor descriptor = unionField.getMessageType();
            if (!this.unionFields.containsKey(descriptor)) {
                this.processRecordType(unionField, processExtensionOptions);
                this.unionFields.put(descriptor, unionField);
                continue;
            }
            this.remapUnionField(descriptor, unionField);
        }
    }

    private void remapUnionField(@Nonnull Descriptors.Descriptor descriptor, @Nonnull Descriptors.FieldDescriptor unionField) {
        this.unionFields.compute(descriptor, (d, f) -> {
            String canonicalName = "_" + d.getName();
            if (f == null || unionField.getName().equals(canonicalName) || !f.getName().equals(canonicalName) && unionField.getNumber() > f.getNumber()) {
                return unionField;
            }
            return f;
        });
    }

    @Nonnull
    private RecordTypeBuilder processRecordType(@Nonnull Descriptors.FieldDescriptor unionField, boolean processExtensionOptions) {
        Descriptors.Descriptor descriptor = unionField.getMessageType();
        RecordTypeBuilder recordType = new RecordTypeBuilder(descriptor);
        if (this.recordTypes.putIfAbsent(recordType.getName(), recordType) != null) {
            throw new MetaDataException("There is already a record type named " + recordType.getName(), new Object[0]);
        }
        if (processExtensionOptions) {
            RecordMetaDataOptionsProto.RecordTypeOptions recordTypeOptions = descriptor.getOptions().getExtension(RecordMetaDataOptionsProto.record);
            if (recordTypeOptions != null && recordTypeOptions.hasSinceVersion()) {
                recordType.setSinceVersion(recordTypeOptions.getSinceVersion());
            }
            if (recordTypeOptions != null && recordTypeOptions.hasRecordTypeKey()) {
                recordType.setRecordTypeKey(LiteralKeyExpression.fromProto(recordTypeOptions.getRecordTypeKey()).getValue());
            }
            this.protoFieldOptions(recordType);
        }
        return recordType;
    }

    private void protoFieldOptions(RecordTypeBuilder recordType) {
        for (Descriptors.FieldDescriptor fieldDescriptor : recordType.getDescriptor().getFields()) {
            RecordMetaDataOptionsProto.FieldOptions fieldOptions = fieldDescriptor.getOptions().getExtension(RecordMetaDataOptionsProto.field);
            if (fieldOptions == null) continue;
            this.protoFieldOptions(recordType, fieldDescriptor, fieldOptions);
        }
    }

    private void protoFieldOptions(RecordTypeBuilder recordType, Descriptors.FieldDescriptor fieldDescriptor, RecordMetaDataOptionsProto.FieldOptions fieldOptions) {
        Descriptors.Descriptor descriptor = recordType.getDescriptor();
        if (fieldOptions.hasIndex() || fieldOptions.hasIndexed()) {
            Map<String, String> options;
            String type;
            if (fieldOptions.hasIndex()) {
                RecordMetaDataOptionsProto.FieldOptions.IndexOption indexOption = fieldOptions.getIndex();
                type = indexOption.getType();
                options = Index.buildOptions(indexOption.getOptionsList(), indexOption.getUnique());
            } else {
                type = Index.indexTypeToType(fieldOptions.getIndexed());
                options = Index.indexTypeToOptions(fieldOptions.getIndexed());
            }
            FieldKeyExpression field = Key.Expressions.fromDescriptor(fieldDescriptor);
            BaseKeyExpression expr = "rank".equals(type) ? field.ungrouped() : field;
            Index index = new Index(descriptor.getName() + "$" + fieldDescriptor.getName(), (KeyExpression)expr, Index.EMPTY_VALUE, type, options);
            this.addIndex(recordType, index);
        } else if (fieldOptions.getPrimaryKey()) {
            if (recordType.getPrimaryKey() != null) {
                throw new MetaDataException("Only one primary key per record type is allowed have: " + String.valueOf(recordType.getPrimaryKey()) + "; adding on " + fieldDescriptor.getName(), new Object[0]);
            }
            if (fieldDescriptor.isRepeated()) {
                throw new MetaDataException("Primary key cannot be set on a repeated field", new Object[0]);
            }
            recordType.setPrimaryKey(Key.Expressions.fromDescriptor(fieldDescriptor));
        }
    }

    @API(value=API.Status.INTERNAL)
    public static Descriptors.FileDescriptor buildFileDescriptor(@Nonnull DescriptorProtos.FileDescriptorProto fileDescriptorProto, @Nonnull Descriptors.FileDescriptor[] dependencies) {
        try {
            return Descriptors.FileDescriptor.buildFrom(fileDescriptorProto, dependencies);
        }
        catch (Descriptors.DescriptorValidationException ex) {
            throw new MetaDataException("Error converting from protobuf", ex);
        }
    }

    @Nonnull
    public Descriptors.Descriptor getUnionDescriptor() {
        return this.unionDescriptor;
    }

    @Nonnull
    public Descriptors.FieldDescriptor getUnionFieldForRecordType(@Nonnull RecordType recordType) {
        Descriptors.FieldDescriptor unionField = this.unionFields.get(recordType.getDescriptor());
        if (unionField == null) {
            throw new MetaDataException("Record type " + recordType.getName() + " is not in the union", new Object[0]);
        }
        return unionField;
    }

    @Nonnull
    public RecordTypeBuilder getRecordType(@Nonnull String name) {
        RecordTypeBuilder recordType = this.recordTypes.get(name);
        if (recordType == null) {
            this.throwUnknownRecordType(name, false);
        }
        return recordType;
    }

    private void throwUnknownRecordType(@Nonnull String name, boolean isSynthetic) {
        throw new MetaDataException("Unknown " + (isSynthetic ? "Synthetic " : "") + "record type " + name, new Object[0]);
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public SyntheticRecordTypeBuilder<?> getSyntheticRecordType(@Nonnull String name) {
        SyntheticRecordTypeBuilder<?> recordType = this.syntheticRecordTypes.get(name);
        if (recordType == null) {
            this.throwUnknownRecordType(name, true);
        }
        return recordType;
    }

    @Nonnull
    private Long getNextRecordTypeKey() {
        long minKey = 0L;
        for (SyntheticRecordTypeBuilder<?> syntheticRecordType : this.syntheticRecordTypes.values()) {
            long key;
            if (!(syntheticRecordType.getRecordTypeKey() instanceof Number) || minKey <= (key = ((Number)syntheticRecordType.getRecordTypeKey()).longValue())) continue;
            minKey = key;
        }
        return minKey - 1L;
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public JoinedRecordTypeBuilder addJoinedRecordType(@Nonnull String name) {
        if (this.recordTypes.containsKey(name)) {
            throw new MetaDataException("There is already a record type named " + name, new Object[0]);
        }
        if (this.syntheticRecordTypes.containsKey(name)) {
            throw new MetaDataException("There is already a synthetic record type named " + name, new Object[0]);
        }
        JoinedRecordTypeBuilder recordType = new JoinedRecordTypeBuilder(name, this.getNextRecordTypeKey(), this);
        this.syntheticRecordTypes.put(name, recordType);
        return recordType;
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public UnnestedRecordTypeBuilder addUnnestedRecordType(@Nonnull String name) {
        if (this.recordTypes.containsKey(name)) {
            throw new MetaDataException("There is already a record type named " + name, new Object[0]);
        }
        if (this.syntheticRecordTypes.containsKey(name)) {
            throw new MetaDataException("There is already a synthetic record type named " + name, new Object[0]);
        }
        UnnestedRecordTypeBuilder unnestedRecordTypeBuilder = new UnnestedRecordTypeBuilder(name, this.getNextRecordTypeKey(), this);
        this.syntheticRecordTypes.put(name, unnestedRecordTypeBuilder);
        return unnestedRecordTypeBuilder;
    }

    public RecordTypeIndexesBuilder getIndexableRecordType(@Nonnull String name) {
        RecordTypeIndexesBuilder recordType = this.recordTypes.get(name);
        if (recordType == null) {
            recordType = this.syntheticRecordTypes.get(name);
        }
        if (recordType == null) {
            this.throwUnknownRecordType(name, false);
        }
        return recordType;
    }

    @Nonnull
    public Index getIndex(@Nonnull String indexName) {
        Index index = this.indexes.get(indexName);
        if (null == index) {
            throw new MetaDataException("Index " + indexName + " not defined", new Object[0]);
        }
        return index;
    }

    private void addIndexCommon(@Nonnull Index index) {
        if (this.recordsDescriptor == null) {
            throw new MetaDataException("No records added yet", new Object[0]);
        }
        if (this.indexes.containsKey(index.getName())) {
            throw new MetaDataException("Index " + index.getName() + " already defined", new Object[0]);
        }
        if (index.getLastModifiedVersion() <= 0) {
            index.setLastModifiedVersion(++this.version);
        } else if (index.getLastModifiedVersion() > this.version) {
            this.version = index.getLastModifiedVersion();
        }
        if (index.getAddedVersion() <= 0) {
            index.setAddedVersion(index.getLastModifiedVersion());
        }
        if (this.usesSubspaceKeyCounter && !index.hasExplicitSubspaceKey()) {
            index.setSubspaceKey(++this.subspaceKeyCounter);
        }
        this.indexes.put(index.getName(), index);
    }

    public void addIndex(@Nullable RecordTypeIndexesBuilder recordType, @Nonnull Index index) {
        this.addIndexCommon(index);
        if (recordType != null) {
            recordType.getIndexes().add(index);
        } else {
            this.universalIndexes.put(index.getName(), index);
        }
    }

    public void addIndex(@Nonnull String recordType, @Nonnull Index index) {
        this.addIndex(this.getIndexableRecordType(recordType), index);
    }

    public void addIndex(@Nonnull String recordType, @Nonnull String indexName, @Nonnull KeyExpression indexExpression) {
        this.addIndex(recordType, new Index(indexName, indexExpression));
    }

    public void addIndex(@Nonnull String recordType, @Nonnull String indexName, @Nonnull String fieldName) {
        this.addIndex(recordType, new Index(indexName, fieldName));
    }

    public void addIndex(@Nonnull String recordType, @Nonnull String fieldName) {
        this.addIndex(recordType, recordType + "$" + fieldName, fieldName);
    }

    public void addMultiTypeIndex(@Nullable List<? extends RecordTypeIndexesBuilder> recordTypes, @Nonnull Index index) {
        this.addIndexCommon(index);
        if (recordTypes == null || recordTypes.isEmpty()) {
            this.universalIndexes.put(index.getName(), index);
        } else if (recordTypes.size() == 1) {
            recordTypes.get(0).getIndexes().add(index);
        } else {
            for (RecordTypeIndexesBuilder recordTypeIndexesBuilder : recordTypes) {
                recordTypeIndexesBuilder.getMultiTypeIndexes().add(index);
            }
        }
    }

    public void addUniversalIndex(@Nonnull Index index) {
        this.addIndexCommon(index);
        this.universalIndexes.put(index.getName(), index);
    }

    public void removeIndex(@Nonnull String name) {
        Index index = this.indexes.remove(name);
        if (index == null) {
            throw new MetaDataException("No index named " + name + " defined", new Object[0]);
        }
        for (RecordTypeBuilder recordType : this.recordTypes.values()) {
            recordType.getIndexes().remove(index);
            recordType.getMultiTypeIndexes().remove(index);
        }
        this.universalIndexes.remove(name);
        this.formerIndexes.add(new FormerIndex(index.getSubspaceKey(), index.getAddedVersion(), ++this.version, name));
    }

    public void addFormerIndex(@Nonnull FormerIndex formerIndex) {
        this.formerIndexes.add(formerIndex);
    }

    public void addUserDefinedFunction(@Nonnull UserDefinedFunction userDefinedFunction) {
        this.userDefinedFunctionMap.put(userDefinedFunction.getFunctionName(), userDefinedFunction);
    }

    public void addUserDefinedFunctions(@Nonnull Iterable<? extends UserDefinedFunction> functions) {
        functions.forEach(this::addUserDefinedFunction);
    }

    public boolean isSplitLongRecords() {
        return this.splitLongRecords;
    }

    public void setSplitLongRecords(boolean splitLongRecords) {
        if (this.recordsDescriptor == null) {
            throw new MetaDataException("No records added yet", new Object[0]);
        }
        if (this.splitLongRecords != splitLongRecords) {
            ++this.version;
            this.splitLongRecords = splitLongRecords;
        }
    }

    public boolean isStoreRecordVersions() {
        return this.storeRecordVersions;
    }

    public void setStoreRecordVersions(boolean storeRecordVersions) {
        if (this.recordsDescriptor == null) {
            throw new MetaDataException("No records added yet", new Object[0]);
        }
        if (this.storeRecordVersions != storeRecordVersions) {
            ++this.version;
            this.storeRecordVersions = storeRecordVersions;
        }
    }

    @Nullable
    @Deprecated
    @API(value=API.Status.DEPRECATED)
    public KeyExpression getRecordCountKey() {
        return this.recordCountKey;
    }

    @Deprecated
    @API(value=API.Status.DEPRECATED)
    public void setRecordCountKey(KeyExpression recordCountKey) {
        if (this.recordsDescriptor == null) {
            throw new MetaDataException("No records added yet", new Object[0]);
        }
        if (!Objects.equals(this.recordCountKey, recordCountKey)) {
            ++this.version;
            this.recordCountKey = recordCountKey;
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        if (this.recordsDescriptor == null) {
            throw new MetaDataException("No records added yet", new Object[0]);
        }
        this.version = version;
    }

    @Nonnull
    public RecordMetaDataBuilder enableCounterBasedSubspaceKeys() {
        if (this.recordsDescriptor != null) {
            throw new MetaDataException("Records descriptor has already been set.", new Object[0]);
        }
        this.usesSubspaceKeyCounter = true;
        return this;
    }

    public boolean usesSubspaceKeyCounter() {
        return this.usesSubspaceKeyCounter;
    }

    public long getSubspaceKeyCounter() {
        return this.subspaceKeyCounter;
    }

    @Nonnull
    public RecordMetaDataBuilder setSubspaceKeyCounter(long subspaceKeyCounter) {
        if (!this.usesSubspaceKeyCounter()) {
            throw new MetaDataException("Counter-based subspace keys not enabled", new Object[0]);
        }
        if (subspaceKeyCounter <= this.subspaceKeyCounter) {
            throw new MetaDataException("Subspace key counter must be set to a value greater than its current value", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.EXPECTED, "greater than " + this.subspaceKeyCounter}).addLogInfo(new Object[]{LogMessageKeys.ACTUAL, subspaceKeyCounter});
        }
        this.subspaceKeyCounter = subspaceKeyCounter;
        return this;
    }

    @Nonnull
    public RecordTypeBuilder getOnlyRecordType() {
        if (this.recordTypes.size() != 1) {
            throw new MetaDataException("Must have exactly one record type defined.", new Object[0]);
        }
        return this.recordTypes.values().iterator().next();
    }

    @Nonnull
    public IndexMaintainerRegistry getIndexMaintainerRegistry() {
        return this.indexMaintainerRegistry;
    }

    public void setIndexMaintainerRegistry(@Nonnull IndexMaintainerRegistry indexMaintainerRegistry) {
        this.indexMaintainerRegistry = indexMaintainerRegistry;
    }

    @Nonnull
    public MetaDataEvolutionValidator getEvolutionValidator() {
        return this.evolutionValidator;
    }

    @Nonnull
    public RecordMetaDataBuilder setEvolutionValidator(@Nonnull MetaDataEvolutionValidator evolutionValidator) {
        if (this.recordsDescriptor != null) {
            throw new MetaDataException("Records already set.", new Object[0]);
        }
        this.evolutionValidator = evolutionValidator;
        return this;
    }

    @Override
    @Nonnull
    public RecordMetaData getRecordMetaData() {
        if (this.recordMetaData == null || this.recordMetaData.getVersion() != this.version) {
            this.recordMetaData = this.build();
        }
        return this.recordMetaData;
    }

    @Nonnull
    public RecordMetaData build() {
        return this.build(true);
    }

    @Nonnull
    public RecordMetaData build(boolean validate) {
        HashMap<String, RecordType> builtRecordTypes = Maps.newHashMapWithExpectedSize(this.recordTypes.size());
        HashMap<String, SyntheticRecordType<?>> builtSyntheticRecordTypes = Maps.newHashMapWithExpectedSize(this.syntheticRecordTypes.size());
        HashMap<Object, SyntheticRecordType<?>> recordTypeKeyToSyntheticRecordTypeMap = Maps.newHashMapWithExpectedSize(this.syntheticRecordTypes.size());
        RecordMetaData metaData = new RecordMetaData(this.recordsDescriptor, this.getUnionDescriptor(), this.unionFields, builtRecordTypes, builtSyntheticRecordTypes, recordTypeKeyToSyntheticRecordTypeMap, this.indexes, this.universalIndexes, this.formerIndexes, this.userDefinedFunctionMap, this.splitLongRecords, this.storeRecordVersions, this.version, this.subspaceKeyCounter, this.usesSubspaceKeyCounter, this.recordCountKey, this.localFileDescriptor != null);
        for (RecordTypeBuilder recordTypeBuilder2 : this.recordTypes.values()) {
            KeyExpression primaryKey = recordTypeBuilder2.getPrimaryKey();
            if (primaryKey != null) {
                builtRecordTypes.put(recordTypeBuilder2.getName(), recordTypeBuilder2.build(metaData));
                for (Index index : recordTypeBuilder2.getIndexes()) {
                    index.setPrimaryKeyComponentPositions(RecordMetaDataBuilder.buildPrimaryKeyComponentPositions(index.getRootExpression(), primaryKey));
                }
                continue;
            }
            throw new MetaDataException("Record type " + recordTypeBuilder2.getName() + " must have a primary key", new Object[0]);
        }
        if (!this.syntheticRecordTypes.isEmpty()) {
            Descriptors.FileDescriptor fileDescriptor;
            DescriptorProtos.FileDescriptorProto.Builder fileBuilder = DescriptorProtos.FileDescriptorProto.newBuilder();
            fileBuilder.setName("_synthetic");
            LinkedHashSet typeDescriptorSources = new LinkedHashSet();
            this.syntheticRecordTypes.values().forEach(recordTypeBuilder -> recordTypeBuilder.buildDescriptor(fileBuilder, typeDescriptorSources));
            typeDescriptorSources.forEach(source -> fileBuilder.addDependency(source.getName()));
            try {
                Descriptors.FileDescriptor[] dependencies = new Descriptors.FileDescriptor[typeDescriptorSources.size()];
                typeDescriptorSources.toArray(dependencies);
                fileDescriptor = Descriptors.FileDescriptor.buildFrom(fileBuilder.build(), dependencies);
            }
            catch (Descriptors.DescriptorValidationException ex) {
                throw new MetaDataException("Could not build synthesized file descriptor", ex);
            }
            for (SyntheticRecordTypeBuilder syntheticRecordTypeBuilder : this.syntheticRecordTypes.values()) {
                SyntheticRecordType<?> syntheticType = syntheticRecordTypeBuilder.build(metaData, fileDescriptor);
                builtSyntheticRecordTypes.put(syntheticRecordTypeBuilder.getName(), syntheticType);
                recordTypeKeyToSyntheticRecordTypeMap.put(syntheticType.getRecordTypeKey(), syntheticType);
            }
        }
        if (validate) {
            MetaDataValidator validator = new MetaDataValidator(metaData, this.indexMaintainerRegistry);
            validator.validate();
        }
        return metaData;
    }

    @Nullable
    public static int[] buildPrimaryKeyComponentPositions(@Nonnull KeyExpression indexKey, @Nonnull KeyExpression primaryKey) {
        List<KeyExpression> indexKeys = indexKey.normalizeKeyForPositions();
        List<KeyExpression> primaryKeys = primaryKey.normalizeKeyForPositions();
        int[] positions = new int[primaryKeys.size()];
        for (int i = 0; i < positions.length; ++i) {
            positions[i] = indexKeys.indexOf(primaryKeys.get(i));
        }
        if (Arrays.stream(positions).anyMatch(p -> p >= 0)) {
            return positions;
        }
        return null;
    }

    public static class MetaDataProtoDeserializationException
    extends MetaDataException {
        public MetaDataProtoDeserializationException(@Nullable Throwable cause) {
            super("Error converting from protobuf", cause);
        }
    }
}

