/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordScanLimiter;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
public class RecordScanLimiterFactory {
    private static final RecordScanLimiter UNTRACKED = new Untracked();

    public static RecordScanLimiter enforce(int limit) {
        return new Enforcing(limit);
    }

    public static RecordScanLimiter tracking() {
        return new Tracking();
    }

    public static RecordScanLimiter untracked() {
        return UNTRACKED;
    }

    private static class Enforcing
    implements RecordScanLimiter {
        private final int originalLimit;
        private final AtomicInteger allowedRecordScansRemaining;

        public Enforcing(int limit) {
            this.originalLimit = limit;
            this.allowedRecordScansRemaining = new AtomicInteger(limit);
        }

        @Override
        @Nonnull
        public RecordScanLimiter reset() {
            return new Enforcing(this.originalLimit);
        }

        @Override
        public boolean isEnforcing() {
            return true;
        }

        @Override
        public boolean tryRecordScan() {
            return this.allowedRecordScansRemaining.getAndDecrement() > 0;
        }

        @Override
        public int getLimit() {
            return this.originalLimit;
        }

        @Override
        public int getRecordsScanned() {
            return this.originalLimit - this.allowedRecordScansRemaining.get();
        }

        public String toString() {
            return "RecordScanLimiter(" + this.originalLimit + " limit, " + this.allowedRecordScansRemaining.get() + " left)";
        }
    }

    private static class Tracking
    implements RecordScanLimiter {
        private final AtomicInteger recordsScanned = new AtomicInteger();

        private Tracking() {
        }

        @Override
        @Nonnull
        public RecordScanLimiter reset() {
            return new Tracking();
        }

        @Override
        public boolean isEnforcing() {
            return false;
        }

        @Override
        public boolean tryRecordScan() {
            this.recordsScanned.incrementAndGet();
            return true;
        }

        @Override
        public int getLimit() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int getRecordsScanned() {
            return this.recordsScanned.get();
        }

        public String toString() {
            return "RecordScanLimiter(UNLIMITED, " + this.recordsScanned.get() + " scanned)";
        }
    }

    private static class Untracked
    implements RecordScanLimiter {
        private Untracked() {
        }

        @Override
        @Nonnull
        public RecordScanLimiter reset() {
            return this;
        }

        @Override
        public boolean isEnforcing() {
            return false;
        }

        @Override
        public boolean tryRecordScan() {
            return true;
        }

        @Override
        public int getLimit() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int getRecordsScanned() {
            return 0;
        }

        public String toString() {
            return "RecordScanLimiter(NO_LIMIT)";
        }
    }
}

