/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.IndexState;
import com.apple.foundationdb.record.MutableRecordStoreState;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.metadata.Index;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class RecordStoreState {
    @Nonnull
    protected final AtomicReference<RecordMetaDataProto.DataStoreInfo> storeHeader;
    @Nonnull
    protected final AtomicReference<Map<String, IndexState>> indexStateMap;

    @API(value=API.Status.INTERNAL)
    public RecordStoreState(@Nullable RecordMetaDataProto.DataStoreInfo storeHeader, @Nullable Map<String, IndexState> indexStateMap) {
        Map<Object, Object> copy = indexStateMap == null || indexStateMap.isEmpty() ? Collections.emptyMap() : ImmutableMap.copyOf(indexStateMap);
        this.storeHeader = new AtomicReference<RecordMetaDataProto.DataStoreInfo>(storeHeader == null ? RecordMetaDataProto.DataStoreInfo.getDefaultInstance() : storeHeader);
        this.indexStateMap = new AtomicReference(copy);
    }

    public void beginRead() {
    }

    public void endRead() {
    }

    @Nonnull
    public Map<String, IndexState> getIndexStates() {
        return Collections.unmodifiableMap(this.indexStateMap.get());
    }

    public boolean isWriteOnly(@Nonnull Index index) {
        return this.isWriteOnly(index.getName());
    }

    public boolean isWriteOnly(@Nonnull String indexName) {
        return this.getState(indexName).equals((Object)IndexState.WRITE_ONLY);
    }

    public boolean isDisabled(@Nonnull Index index) {
        return this.isDisabled(index.getName());
    }

    public boolean isDisabled(@Nonnull String indexName) {
        return this.getState(indexName).equals((Object)IndexState.DISABLED);
    }

    public boolean isReadable(@Nonnull Index index) {
        return this.isReadable(index.getName());
    }

    public boolean isReadable(@Nonnull String indexName) {
        return this.getState(indexName).equals((Object)IndexState.READABLE);
    }

    public boolean isReadableUniquePending(@Nonnull String indexName) {
        return this.getState(indexName).equals((Object)IndexState.READABLE_UNIQUE_PENDING);
    }

    public boolean isScannable(@Nonnull String indexName) {
        return this.getState(indexName).isScannable();
    }

    @Nonnull
    public IndexState getState(@Nonnull Index index) {
        return this.getState(index.getName());
    }

    @Nonnull
    public IndexState getState(@Nonnull String indexName) {
        return this.indexStateMap.get().getOrDefault(indexName, IndexState.READABLE);
    }

    public boolean allIndexesReadable() {
        return this.indexStateMap.get().isEmpty() || this.indexStateMap.get().values().stream().allMatch(state -> state.equals((Object)IndexState.READABLE));
    }

    public boolean compatibleWith(@Nonnull RecordStoreState other) {
        return this.indexStateMap.get().entrySet().stream().allMatch(entry -> {
            boolean readableInOther = other.getState((String)entry.getKey()).equals((Object)IndexState.READABLE);
            return ((IndexState)((Object)((Object)entry.getValue()))).equals((Object)IndexState.READABLE) == readableInOther;
        });
    }

    public Set<String> getWriteOnlyIndexNames() {
        return this.indexStateMap.get().entrySet().stream().filter(entry -> entry.getValue() == IndexState.WRITE_ONLY).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<String> getDisabledIndexNames() {
        return this.indexStateMap.get().entrySet().stream().filter(entry -> entry.getValue() == IndexState.DISABLED).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Nonnull
    public RecordStoreState withIndexesInState(@Nonnull List<String> indexNames, @Nonnull IndexState state) {
        HashMap<String, IndexState> indexStateMapBuilder = new HashMap<String, IndexState>(this.getIndexStates());
        if (state == IndexState.READABLE) {
            indexNames.forEach(indexStateMapBuilder::remove);
        } else {
            indexNames.forEach(indexName -> indexStateMapBuilder.put((String)indexName, state));
        }
        return new RecordStoreState(this.storeHeader.get(), ImmutableMap.copyOf(indexStateMapBuilder));
    }

    @Nonnull
    public RecordStoreState withWriteOnlyIndexes(@Nonnull List<String> writeOnlyIndexNames) {
        return new RecordStoreState(this.storeHeader.get(), this.writeOnlyMap(writeOnlyIndexNames));
    }

    @Nonnull
    protected Map<String, IndexState> writeOnlyMap(@Nonnull List<String> writeOnlyIndexNames) {
        HashMap<String, IndexState> map = new HashMap<String, IndexState>(this.getIndexStates());
        writeOnlyIndexNames.forEach(indexName -> map.compute((String)indexName, (name, state) -> {
            if (state == IndexState.DISABLED) {
                return state;
            }
            return IndexState.WRITE_ONLY;
        }));
        return map;
    }

    @Nonnull
    public RecordMetaDataProto.DataStoreInfo getStoreHeader() {
        return this.storeHeader.get();
    }

    public boolean isRecordUpdateAllowed() {
        RecordMetaDataProto.DataStoreInfo localStoreHeader = this.getStoreHeader();
        return !localStoreHeader.hasStoreLockState() || !localStoreHeader.getStoreLockState().getLockState().equals(RecordMetaDataProto.DataStoreInfo.StoreLockState.State.FORBID_RECORD_UPDATE);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecordStoreState)) {
            return false;
        }
        RecordStoreState other = (RecordStoreState)o;
        return this.storeHeader.get().equals(other.storeHeader.get()) && this.indexStateMap.get().equals(other.indexStateMap.get());
    }

    public int hashCode() {
        return Objects.hash(this.indexStateMap.get(), this.storeHeader.get());
    }

    public String toString() {
        return "RecordStoreState(" + this.indexStateMap.toString() + ")";
    }

    @Nonnull
    public RecordStoreState toImmutable() {
        return this;
    }

    @Nonnull
    public MutableRecordStoreState toMutable() {
        return new MutableRecordStoreState(this);
    }
}

