/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.CursorStreamingMode;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IsolationLevel;
import java.util.function.Function;
import javax.annotation.Nonnull;

@API(value=API.Status.UNSTABLE)
public class ScanProperties {
    public static final ScanProperties FORWARD_SCAN = new ScanProperties(ExecuteProperties.newBuilder().setReturnedRowLimit(Integer.MAX_VALUE).setIsolationLevel(IsolationLevel.SERIALIZABLE).build());
    public static final ScanProperties REVERSE_SCAN = new ScanProperties(ExecuteProperties.newBuilder().setReturnedRowLimit(Integer.MAX_VALUE).setIsolationLevel(IsolationLevel.SERIALIZABLE).build(), true);
    @Nonnull
    private final ExecuteProperties executeProperties;
    private final boolean reverse;
    @Nonnull
    private final CursorStreamingMode cursorStreamingMode;

    public ScanProperties(@Nonnull ExecuteProperties executeProperties) {
        this(executeProperties, false);
    }

    public ScanProperties(@Nonnull ExecuteProperties executeProperties, boolean reverse) {
        this(executeProperties, reverse, executeProperties.getDefaultCursorStreamingMode());
    }

    public ScanProperties(@Nonnull ExecuteProperties executeProperties, boolean reverse, @Nonnull CursorStreamingMode cursorStreamingMode) {
        this.executeProperties = executeProperties;
        this.reverse = reverse;
        this.cursorStreamingMode = cursorStreamingMode;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    @Nonnull
    public ExecuteProperties getExecuteProperties() {
        return this.executeProperties;
    }

    @Nonnull
    public ScanProperties with(@Nonnull Function<ExecuteProperties, ExecuteProperties> modifier) {
        return new ScanProperties(modifier.apply(this.executeProperties), this.reverse, this.cursorStreamingMode);
    }

    @Nonnull
    public ScanProperties setReverse(boolean reverse) {
        if (reverse == this.isReverse()) {
            return this;
        }
        return new ScanProperties(this.executeProperties, reverse, this.cursorStreamingMode);
    }

    @Nonnull
    public CursorStreamingMode getCursorStreamingMode() {
        return this.cursorStreamingMode;
    }

    @Nonnull
    public ScanProperties setStreamingMode(@Nonnull CursorStreamingMode cursorStreamingMode) {
        if (cursorStreamingMode == this.getCursorStreamingMode()) {
            return this;
        }
        return new ScanProperties(this.executeProperties, this.reverse, cursorStreamingMode);
    }

    public String toString() {
        return "ScanProperties(" + String.valueOf(this.executeProperties) + ", direction: " + (this.reverse ? "reverse" : "forward") + ", streaming mode: " + String.valueOf((Object)this.cursorStreamingMode) + ")";
    }
}

