/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.UNSTABLE)
public class TimeScanLimiter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeScanLimiter.class);
    private final long startTime;
    private final long timeLimitMillis;
    protected boolean isTimedOut;

    public TimeScanLimiter(long startTime, long timeLimitMillis) {
        this.startTime = startTime;
        this.timeLimitMillis = timeLimitMillis <= 0L ? 0L : timeLimitMillis;
        this.isTimedOut = timeLimitMillis != 0L && System.currentTimeMillis() - startTime >= timeLimitMillis;
    }

    public boolean tryRecordScan() {
        long now;
        if (!this.isTimedOut && this.timeLimitMillis != 0L && (now = System.currentTimeMillis()) - this.startTime >= this.timeLimitMillis) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(KeyValueLogMessage.of("Cursor time limit exceeded", new Object[]{LogMessageKeys.CURSOR_ELAPSED_MILLIS, now - this.startTime, LogMessageKeys.CURSOR_TIME_LIMIT_MILLIS, this.timeLimitMillis}));
            }
            this.isTimedOut = true;
        }
        return !this.isTimedOut;
    }
}

