/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.Range;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EndpointType;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.common.base.Verify;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class TupleRange {
    public static final TupleRange ALL = new TupleRange(null, null, EndpointType.TREE_START, EndpointType.TREE_END);
    @Nullable
    private final Tuple low;
    @Nullable
    private final Tuple high;
    @Nonnull
    private final EndpointType lowEndpoint;
    @Nonnull
    private final EndpointType highEndpoint;

    public TupleRange(@Nullable Tuple low, @Nullable Tuple high, @Nonnull EndpointType lowEndpoint, @Nonnull EndpointType highEndpoint) {
        this.low = low;
        this.high = high;
        this.lowEndpoint = lowEndpoint;
        this.highEndpoint = highEndpoint;
    }

    @Nullable
    public Tuple getLow() {
        return this.low;
    }

    @Nullable
    public Tuple getHigh() {
        return this.high;
    }

    @Nonnull
    public EndpointType getLowEndpoint() {
        return this.lowEndpoint;
    }

    @Nonnull
    public EndpointType getHighEndpoint() {
        return this.highEndpoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TupleRange that = (TupleRange)o;
        if (this.low != null ? !this.low.equals(that.low) : that.low != null) {
            return false;
        }
        if (this.high != null ? !this.high.equals(that.high) : that.high != null) {
            return false;
        }
        if (this.lowEndpoint != that.lowEndpoint) {
            return false;
        }
        return this.highEndpoint == that.highEndpoint;
    }

    public int hashCode() {
        int result = this.low != null ? this.low.hashCode() : 0;
        result = 31 * result + (this.high != null ? this.high.hashCode() : 0);
        result = 31 * result + this.lowEndpoint.hashCode();
        result = 31 * result + this.highEndpoint.hashCode();
        return result;
    }

    public String toString() {
        return this.lowEndpoint.toString(false) + TupleRange.tupleToString(this.low) + "," + TupleRange.tupleToString(this.high) + this.highEndpoint.toString(true);
    }

    @Nonnull
    protected static String tupleToString(@Nullable Tuple t2) {
        if (t2 == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Object o : t2) {
            if (o instanceof byte[]) {
                sb.append(Arrays.toString((byte[])o));
            } else {
                sb.append(o);
            }
            sb.append(", ");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    public boolean isEquals() {
        return this.low != null && TupleHelpers.equals(this.low, this.high) && this.lowEndpoint == EndpointType.RANGE_INCLUSIVE && this.highEndpoint == EndpointType.RANGE_INCLUSIVE;
    }

    @Nonnull
    public TupleRange prepend(@Nonnull Tuple beginning) {
        EndpointType newHighEndpoint;
        Tuple newHigh;
        EndpointType newLowEndpoint;
        Tuple newLow;
        if (this.low == null) {
            newLow = beginning;
            newLowEndpoint = EndpointType.RANGE_INCLUSIVE;
        } else {
            newLow = beginning.addAll(this.low);
            newLowEndpoint = this.lowEndpoint;
        }
        if (this.high == null) {
            newHigh = beginning;
            newHighEndpoint = EndpointType.RANGE_INCLUSIVE;
        } else {
            newHigh = TupleHelpers.equals(this.low, this.high) ? newLow : beginning.addAll(this.high);
            newHighEndpoint = this.highEndpoint;
        }
        return new TupleRange(newLow, newHigh, newLowEndpoint, newHighEndpoint);
    }

    @Nonnull
    public TupleRange prefix(int prefixCount) {
        EndpointType newHighEndpoint;
        Tuple newHigh;
        EndpointType newLowEndpoint;
        Tuple newLow;
        if (this.low == null) {
            newLow = null;
            newLowEndpoint = this.lowEndpoint;
        } else {
            newLow = this.low.size() > prefixCount ? Tuple.fromList(this.low.getItems().subList(0, prefixCount)) : this.low;
            newLowEndpoint = EndpointType.RANGE_INCLUSIVE;
        }
        if (this.high == null) {
            newHigh = null;
            newHighEndpoint = this.highEndpoint;
        } else {
            newHigh = TupleHelpers.equals(this.low, this.high) ? newLow : (this.high.size() > prefixCount ? Tuple.fromList(this.high.getItems().subList(0, prefixCount)) : this.high);
            newHighEndpoint = EndpointType.RANGE_INCLUSIVE;
        }
        return new TupleRange(newLow, newHigh, newLowEndpoint, newHighEndpoint);
    }

    public boolean overlaps(@Nonnull Tuple lowTuple, @Nonnull Tuple highTuple) {
        switch (this.getLowEndpoint()) {
            case TREE_START: {
                break;
            }
            case RANGE_INCLUSIVE: 
            case RANGE_EXCLUSIVE: {
                Tuple checkedLow = Objects.requireNonNull(this.getLow());
                if (this.getLowEndpoint() == EndpointType.RANGE_INCLUSIVE && TupleHelpers.compare(highTuple, checkedLow) < 0) {
                    return false;
                }
                if (this.getLowEndpoint() != EndpointType.RANGE_EXCLUSIVE || TupleHelpers.compare(highTuple, checkedLow) > 0) break;
                return false;
            }
            default: {
                throw new RecordCoreException("do not support endpoint " + String.valueOf((Object)this.getLowEndpoint()), new Object[0]);
            }
        }
        switch (this.getHighEndpoint()) {
            case TREE_END: {
                break;
            }
            case RANGE_INCLUSIVE: 
            case RANGE_EXCLUSIVE: {
                Tuple checkedHigh = Objects.requireNonNull(this.getHigh());
                if (this.getHighEndpoint() == EndpointType.RANGE_INCLUSIVE && TupleHelpers.compare(this.trimTupleForHighComparison(lowTuple), checkedHigh) > 0) {
                    return false;
                }
                if (this.getHighEndpoint() != EndpointType.RANGE_EXCLUSIVE || TupleHelpers.compare(lowTuple, checkedHigh) < 0) break;
                return false;
            }
            default: {
                throw new RecordCoreException("do not support endpoint " + String.valueOf((Object)this.getHighEndpoint()), new Object[0]);
            }
        }
        return true;
    }

    public boolean contains(@Nonnull Tuple tuple) {
        switch (this.getLowEndpoint()) {
            case TREE_START: {
                break;
            }
            case RANGE_INCLUSIVE: 
            case RANGE_EXCLUSIVE: {
                Tuple checkedLow = Objects.requireNonNull(this.getLow());
                if (this.getLowEndpoint() == EndpointType.RANGE_INCLUSIVE && TupleHelpers.compare(tuple, checkedLow) < 0) {
                    return false;
                }
                if (this.getLowEndpoint() != EndpointType.RANGE_EXCLUSIVE || TupleHelpers.compare(tuple, checkedLow) > 0) break;
                return false;
            }
            default: {
                throw new RecordCoreException("do not support endpoint " + String.valueOf((Object)this.getLowEndpoint()), new Object[0]);
            }
        }
        switch (this.getHighEndpoint()) {
            case TREE_END: {
                break;
            }
            case RANGE_INCLUSIVE: 
            case RANGE_EXCLUSIVE: {
                Tuple checkedHigh = Objects.requireNonNull(this.getHigh());
                if (this.getHighEndpoint() == EndpointType.RANGE_INCLUSIVE && TupleHelpers.compare(this.trimTupleForHighComparison(tuple), checkedHigh) > 0) {
                    return false;
                }
                if (this.getHighEndpoint() != EndpointType.RANGE_EXCLUSIVE || TupleHelpers.compare(tuple, checkedHigh) < 0) break;
                return false;
            }
            default: {
                throw new RecordCoreException("do not support endpoint " + String.valueOf((Object)this.getHighEndpoint()), new Object[0]);
            }
        }
        return true;
    }

    @Nonnull
    private Tuple trimTupleForHighComparison(@Nonnull Tuple tuple) {
        Verify.verify(this.high != null);
        Verify.verify(this.highEndpoint == EndpointType.RANGE_INCLUSIVE);
        if (tuple.size() > this.high.size()) {
            return TupleHelpers.subTuple(tuple, 0, this.high.size());
        }
        return tuple;
    }

    @Nonnull
    public static TupleRange allOf(@Nullable Tuple prefix) {
        if (prefix == null) {
            return ALL;
        }
        return new TupleRange(prefix, prefix, EndpointType.RANGE_INCLUSIVE, EndpointType.RANGE_INCLUSIVE);
    }

    public static TupleRange between(@Nullable Tuple low, @Nullable Tuple high) {
        EndpointType lowEndpoint = low == null ? EndpointType.TREE_START : EndpointType.RANGE_INCLUSIVE;
        EndpointType highEndpoint = high == null ? EndpointType.TREE_END : EndpointType.RANGE_EXCLUSIVE;
        return new TupleRange(low, high, lowEndpoint, highEndpoint);
    }

    public static TupleRange betweenInclusive(@Nullable Tuple low, @Nullable Tuple high) {
        EndpointType lowEndpoint = low == null ? EndpointType.TREE_START : EndpointType.RANGE_INCLUSIVE;
        EndpointType highEndpoint = high == null ? EndpointType.TREE_END : EndpointType.RANGE_INCLUSIVE;
        return new TupleRange(low, high, lowEndpoint, highEndpoint);
    }

    @Nonnull
    public static TupleRange prefixedBy(@Nonnull String prefixString) {
        return new TupleRange(Tuple.from(prefixString), Tuple.from(prefixString), EndpointType.PREFIX_STRING, EndpointType.PREFIX_STRING);
    }

    @Nonnull
    public Range toRange() {
        return TupleRange.toRange(this.low == null ? null : this.low.pack(), this.high == null ? null : this.high.pack(), this.lowEndpoint, this.highEndpoint);
    }

    @Nonnull
    public Range toRange(@Nonnull Subspace subspace) {
        return TupleRange.toRange(this.low == null ? subspace.pack() : subspace.pack(this.low), this.high == null ? subspace.pack() : subspace.pack(this.high), this.lowEndpoint, this.highEndpoint);
    }

    @Nonnull
    public static Range toRange(@Nullable byte[] lowBytes, @Nullable byte[] highBytes, @Nonnull EndpointType lowEndpoint, @Nonnull EndpointType highEndpoint) {
        byte[] byArray;
        if (lowEndpoint == EndpointType.PREFIX_STRING || highEndpoint == EndpointType.PREFIX_STRING) {
            TupleRange.verifyPrefixStringSemantics(lowBytes, highBytes, lowEndpoint, highEndpoint);
        }
        switch (lowEndpoint) {
            case TREE_START: 
            case RANGE_INCLUSIVE: {
                break;
            }
            case RANGE_EXCLUSIVE: {
                if (lowBytes == null) {
                    throw new RecordCoreException("Exclusive low endpoint with null low bytes", new Object[0]);
                }
                lowBytes = ByteArrayUtil.strinc(lowBytes);
                break;
            }
            case CONTINUATION: {
                lowBytes = ByteArrayUtil.join(lowBytes, {0});
                break;
            }
            case PREFIX_STRING: {
                lowBytes = Arrays.copyOfRange(lowBytes, 0, lowBytes.length - 1);
                break;
            }
            default: {
                throw new RecordCoreException("Incorrect low endpoint: " + String.valueOf((Object)lowEndpoint), new Object[0]);
            }
        }
        switch (highEndpoint) {
            case RANGE_EXCLUSIVE: 
            case CONTINUATION: {
                break;
            }
            case RANGE_INCLUSIVE: 
            case TREE_END: {
                if (highBytes != null) {
                    highBytes = ByteArrayUtil.join(highBytes, {-1});
                    break;
                }
                if (highEndpoint == EndpointType.TREE_END) break;
                throw new RecordCoreException("Inclusive high endpoint with null high bytes", new Object[0]);
            }
            case PREFIX_STRING: {
                int newLength;
                for (newLength = highBytes.length - 1; newLength >= 1 && highBytes[newLength - 1] == -1; --newLength) {
                }
                if (newLength == 0) {
                    highBytes = new byte[]{-1};
                    break;
                }
                byte[] dest = Arrays.copyOfRange(highBytes, 0, newLength);
                int n = newLength - 1;
                dest[n] = (byte)(dest[n] + 1);
                highBytes = dest;
                break;
            }
            default: {
                throw new RecordCoreException("Incorrect high endpoint: " + String.valueOf((Object)highEndpoint), new Object[0]);
            }
        }
        byte[] byArray2 = lowBytes == null ? new byte[]{} : lowBytes;
        if (highBytes == null) {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = -1;
        } else {
            byArray = highBytes;
        }
        return new Range(byArray2, byArray);
    }

    private static void verifyPrefixStringSemantics(@Nullable byte[] lowBytes, @Nullable byte[] highBytes, @Nonnull EndpointType lowEndpoint, @Nonnull EndpointType highEndpoint) {
        if (lowBytes == null || highBytes == null) {
            throw new RecordCoreException("PREFIX_STRING must specify non-null endpoints", new Object[]{LogMessageKeys.LOW_BYTES, ByteArrayUtil2.loggable(lowBytes), LogMessageKeys.HIGH_BYTES, ByteArrayUtil2.loggable(highBytes)});
        }
        if (lowEndpoint != EndpointType.PREFIX_STRING && lowEndpoint != EndpointType.CONTINUATION || highEndpoint != EndpointType.PREFIX_STRING && highEndpoint != EndpointType.CONTINUATION) {
            throw new RecordCoreException("PREFIX_STRING must be specified for both low and high endpoints", new Object[]{"lowEndpoint", lowEndpoint, "highEndpoint", highEndpoint});
        }
        if (lowEndpoint == EndpointType.CONTINUATION) {
            if (!ByteArrayUtil2.hasCommonPrefix(lowBytes, highBytes, highBytes.length - 1)) {
                throw new RecordCoreException("PREFIX_STRING continuation is not consistent with low endpoint", new Object[]{LogMessageKeys.LOW_BYTES, ByteArrayUtil2.loggable(lowBytes), LogMessageKeys.HIGH_BYTES, ByteArrayUtil2.loggable(highBytes)});
            }
            if (highBytes[highBytes.length - 1] != 0) {
                throw new ByteStringBoundException(lowBytes);
            }
        } else if (highEndpoint == EndpointType.CONTINUATION) {
            if (!ByteArrayUtil2.hasCommonPrefix(highBytes, lowBytes, lowBytes.length - 1)) {
                throw new RecordCoreException("PREFIX_STRING continuation is not consistent with high endpoint", new Object[]{LogMessageKeys.LOW_BYTES, ByteArrayUtil2.loggable(lowBytes), LogMessageKeys.HIGH_BYTES, ByteArrayUtil2.loggable(highBytes)});
            }
            if (lowBytes[lowBytes.length - 1] != 0) {
                throw new ByteStringBoundException(lowBytes);
            }
        } else {
            if (!Arrays.equals(lowBytes, highBytes)) {
                throw new RecordCoreException("PREFIX_STRING must be provide identical string prefixes", new Object[]{LogMessageKeys.LOW_BYTES, ByteArrayUtil2.loggable(lowBytes), LogMessageKeys.HIGH_BYTES, ByteArrayUtil2.loggable(highBytes)});
            }
            if (lowBytes[lowBytes.length - 1] != 0) {
                throw new ByteStringBoundException(lowBytes);
            }
        }
    }

    public static class ByteStringBoundException
    extends RecordCoreException {
        public ByteStringBoundException(@Nullable byte[] rangeBytes) {
            super("Expected a [byte] string bound", new Object[]{LogMessageKeys.RANGE_BYTES, ByteArrayUtil2.loggable(rangeBytes)});
        }
    }
}

