/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.record.EndpointType;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ValueRange<T> {
    public static final ValueRange<?> ALL = new ValueRange<Object>(null, null, EndpointType.TREE_START, EndpointType.TREE_END);
    @Nullable
    private final T low;
    @Nullable
    private final T high;
    @Nonnull
    private final EndpointType lowEndpoint;
    @Nonnull
    private final EndpointType highEndpoint;

    public ValueRange(@Nullable T low, @Nullable T high, @Nonnull EndpointType lowEndpoint, @Nonnull EndpointType highEndpoint) {
        this.low = low;
        this.high = high;
        this.lowEndpoint = lowEndpoint;
        this.highEndpoint = highEndpoint;
    }

    @Nullable
    public T getLow() {
        return this.low;
    }

    @Nullable
    public T getHigh() {
        return this.high;
    }

    @Nonnull
    public EndpointType getLowEndpoint() {
        return this.lowEndpoint;
    }

    @Nonnull
    public EndpointType getHighEndpoint() {
        return this.highEndpoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueRange that = (ValueRange)o;
        return Objects.equals(this.low, that.low) && Objects.equals(this.high, that.high) && this.lowEndpoint == that.lowEndpoint && this.highEndpoint == that.highEndpoint;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.low, this.high, this.lowEndpoint, this.highEndpoint});
    }

    public String toString() {
        return this.lowEndpoint.toString(false) + String.valueOf(this.low) + "," + String.valueOf(this.high) + this.highEndpoint.toString(true);
    }
}

