/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.record.locking.AsyncLock;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

@API(value=API.Status.UNSTABLE)
public class AsyncLockCursor<T>
implements RecordCursor<T> {
    @Nonnull
    private final AsyncLock lock;
    @Nonnull
    private final RecordCursor<T> inner;
    private volatile boolean innerExhausted = false;

    public AsyncLockCursor(@Nonnull AsyncLock lock, @Nonnull RecordCursor<T> inner) {
        this.inner = inner;
        this.lock = lock;
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<T>> onNext() {
        if (this.lock.isLockReleased() && !this.innerExhausted && !this.isClosed()) {
            throw new RecordCoreException("AsyncLockCursor: lock released before the downstream cursor is exhausted or closed.", new Object[0]);
        }
        return this.inner.onNext().whenComplete((result, err) -> {
            if (err != null) {
                this.close();
            } else if (!result.hasNext()) {
                this.innerExhausted = true;
                this.close();
            }
        });
    }

    @Override
    public void close() {
        this.inner.close();
        this.lock.release();
    }

    @Override
    public boolean isClosed() {
        return this.inner.isClosed();
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.inner.getExecutor();
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        if (visitor.visitEnter(this)) {
            this.inner.accept(visitor);
        }
        return visitor.visitLeave(this);
    }
}

