/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.MoreAsyncUtil;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunner;
import com.apple.foundationdb.record.provider.foundationdb.FDBExceptions;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public class AutoContinuingCursor<T>
implements RecordCursor<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoContinuingCursor.class);
    @Nonnull
    private final FDBDatabaseRunner runner;
    @Nonnull
    private final BiFunction<FDBRecordContext, byte[], RecordCursor<T>> nextCursorGenerator;
    @Nullable
    private RecordCursor<T> currentCursor;
    @Nullable
    private FDBRecordContext currentContext;
    @Nullable
    private RecordCursorResult<T> lastResult;
    private final int maxRetriesOnRetriableException;

    public AutoContinuingCursor(@Nonnull FDBDatabaseRunner runner, @Nonnull BiFunction<FDBRecordContext, byte[], RecordCursor<T>> nextCursorGenerator) {
        this(runner, nextCursorGenerator, 0);
    }

    public AutoContinuingCursor(@Nonnull FDBDatabaseRunner runner, @Nonnull BiFunction<FDBRecordContext, byte[], RecordCursor<T>> nextCursorGenerator, int maxRetriesOnRetriableException) {
        this.runner = runner;
        this.nextCursorGenerator = nextCursorGenerator;
        this.maxRetriesOnRetriableException = maxRetriesOnRetriableException;
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<T>> onNext() {
        return AsyncUtil.whileTrue(() -> this.onNextWithRetry(0).thenApply(result -> {
            if (result.hasStoppedBeforeEnd()) {
                this.openContextAndGenerateCursor(result.getContinuation().toBytes());
                return true;
            }
            this.lastResult = result;
            return false;
        }), this.getExecutor()).thenApply(ignore -> this.lastResult);
    }

    private CompletableFuture<RecordCursorResult<T>> onNextWithRetry(int attempt) {
        if (this.currentCursor == null) {
            this.openContextAndGenerateCursor(null);
        }
        return MoreAsyncUtil.handleOnException(() -> this.currentCursor.onNext(), exception -> {
            if (!FDBExceptions.isRetriable(exception) || attempt >= this.maxRetriesOnRetriableException) {
                throw FDBExceptions.wrapException(exception);
            }
            this.openContextAndGenerateCursor(this.lastResult == null ? null : this.lastResult.getContinuation().toBytes());
            return this.onNextWithRetry(attempt + 1);
        });
    }

    @Override
    @Nonnull
    public RecordCursorResult<T> getNext() {
        return this.runner.asyncToSync(FDBStoreTimer.Waits.WAIT_ADVANCE_CURSOR, this.onNext());
    }

    private void openContextAndGenerateCursor(@Nullable byte[] continuation) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Open context and generate a cursor");
        }
        if (this.currentContext != null) {
            this.currentContext.close();
        }
        this.currentContext = this.runner.openContext();
        this.currentCursor = this.nextCursorGenerator.apply(this.currentContext, continuation);
    }

    @Override
    public void close() {
        if (this.currentContext != null) {
            this.currentContext.close();
        }
    }

    @Override
    public boolean isClosed() {
        return this.currentContext == null || this.currentContext.isClosed();
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.runner.getExecutor();
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        if (visitor.visitEnter(this) && this.currentCursor != null) {
            this.currentCursor.accept(visitor);
        }
        return visitor.visitLeave(this);
    }
}

