/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.cursors.BaseCursor;
import com.apple.foundationdb.record.cursors.CursorLimitManager;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.google.protobuf.ByteString;
import com.google.protobuf.ZeroCopyByteString;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class ChainedCursor<T>
implements BaseCursor<T> {
    @Nonnull
    private final Function<Optional<T>, CompletableFuture<Optional<T>>> nextGenerator;
    @Nonnull
    private final Function<T, byte[]> continuationEncoder;
    @Nonnull
    private final Executor executor;
    @Nonnull
    private Optional<T> lastValue;
    @Nullable
    private RecordCursorResult<T> lastResult;
    @Nonnull
    private final CursorLimitManager limitManager;
    private final long maxReturnedRows;
    private long returnedRowCount;
    private boolean closed = false;

    public ChainedCursor(@Nonnull Function<Optional<T>, CompletableFuture<Optional<T>>> nextGenerator, @Nonnull Function<T, byte[]> continuationEncoder, @Nonnull Function<byte[], T> continuationDecoder, @Nullable byte[] continuation, @Nonnull Executor executor) {
        this(null, nextGenerator, continuationEncoder, continuationDecoder, continuation, null, executor);
    }

    public ChainedCursor(@Nonnull FDBRecordContext context, @Nonnull Function<Optional<T>, CompletableFuture<Optional<T>>> nextGenerator, @Nonnull Function<T, byte[]> continuationEncoder, @Nonnull Function<byte[], T> continuationDecoder, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        this(context, nextGenerator, continuationEncoder, continuationDecoder, continuation, scanProperties, context.getExecutor());
    }

    private ChainedCursor(@Nullable FDBRecordContext context, @Nonnull Function<Optional<T>, CompletableFuture<Optional<T>>> nextGenerator, @Nonnull Function<T, byte[]> continuationEncoder, @Nonnull Function<byte[], T> continuationDecoder, @Nullable byte[] continuation, @Nullable ScanProperties scanProperties, @Nonnull Executor executor) {
        this.nextGenerator = nextGenerator;
        this.continuationEncoder = continuationEncoder;
        this.executor = executor;
        this.lastValue = continuation != null ? Optional.of(continuationDecoder.apply(continuation)) : Optional.empty();
        if (context == null) {
            this.limitManager = new CursorLimitManager(ScanProperties.FORWARD_SCAN);
        } else {
            if (scanProperties == null) {
                throw new IllegalStateException("scanProperties cannot be null if context is not null");
            }
            if (scanProperties.isReverse()) {
                throw new RecordCoreArgumentException("ChainedCursor does not support reverse scans", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.SCAN_PROPERTIES, scanProperties});
            }
            this.limitManager = new CursorLimitManager(context, scanProperties);
        }
        this.maxReturnedRows = scanProperties == null ? Integer.MAX_VALUE : (long)scanProperties.getExecuteProperties().getReturnedRowLimitOrMax();
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<T>> onNext() {
        if (this.lastResult != null && !this.lastResult.hasNext()) {
            return CompletableFuture.completedFuture(this.lastResult);
        }
        if (this.returnedRowCount == this.maxReturnedRows) {
            this.lastResult = RecordCursorResult.withoutNextValue(new Continuation<T>(this.lastValue, this.continuationEncoder), RecordCursor.NoNextReason.RETURN_LIMIT_REACHED);
            return CompletableFuture.completedFuture(this.lastResult);
        }
        if (!this.limitManager.tryRecordScan()) {
            this.lastResult = RecordCursorResult.withoutNextValue(new Continuation<T>(this.lastValue, this.continuationEncoder), this.limitManager.getStoppedReason().get());
            return CompletableFuture.completedFuture(this.lastResult);
        }
        return this.nextGenerator.apply(this.lastValue).thenApply(nextValue -> {
            if (nextValue.isPresent()) {
                ++this.returnedRowCount;
                this.lastValue = nextValue;
                this.lastResult = RecordCursorResult.withNextValue(nextValue.get(), new Continuation<T>(nextValue, this.continuationEncoder));
            } else {
                this.lastValue = nextValue;
                this.lastResult = RecordCursorResult.exhausted();
            }
            return this.lastResult;
        });
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        visitor.visitEnter(this);
        return visitor.visitLeave(this);
    }

    private static class Continuation<T>
    implements RecordCursorContinuation {
        @Nonnull
        private final Optional<T> lastValue;
        @Nonnull
        private final Function<T, byte[]> continuationEncoder;
        @Nullable
        private byte[] cachedBytes;

        public Continuation(@Nonnull Optional<T> lastValue, @Nonnull Function<T, byte[]> continuationEncoder) {
            this.lastValue = lastValue;
            this.continuationEncoder = continuationEncoder;
        }

        @Override
        @Nonnull
        public ByteString toByteString() {
            byte[] bytes = this.toBytes();
            return bytes == null ? ByteString.EMPTY : ZeroCopyByteString.wrap(bytes);
        }

        @Override
        @Nullable
        public byte[] toBytes() {
            if (this.cachedBytes == null) {
                this.cachedBytes = this.lastValue.map(this.continuationEncoder).orElse(null);
            }
            return this.cachedBytes;
        }

        @Override
        public boolean isEnd() {
            return this.toBytes() == null;
        }
    }
}

