/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.util.TriFunction;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ConcatCursor<T>
implements RecordCursor<T> {
    @Nonnull
    private final FDBRecordContext context;
    @Nonnull
    private final ScanProperties scanProperties;
    @Nonnull
    private final TriFunction<FDBRecordContext, ScanProperties, byte[], RecordCursor<T>> firstFunction;
    @Nonnull
    private final TriFunction<FDBRecordContext, ScanProperties, byte[], RecordCursor<T>> secondFunction;
    @Nullable
    private RecordCursor<T> firstCursor;
    @Nullable
    private RecordCursor<T> secondCursor;
    @Nullable
    private RecordCursorResult<T> nextResult;
    @Nullable
    private byte[] currentCursorContinuation;
    private int rowLimit;

    @API(value=API.Status.EXPERIMENTAL)
    public ConcatCursor(@Nonnull FDBRecordContext context, @Nonnull ScanProperties scanProperties, @Nonnull TriFunction<FDBRecordContext, ScanProperties, byte[], RecordCursor<T>> func1, @Nonnull TriFunction<FDBRecordContext, ScanProperties, byte[], RecordCursor<T>> func2, @Nullable byte[] continuation) {
        this.context = context;
        this.scanProperties = scanProperties;
        this.rowLimit = scanProperties.getExecuteProperties().getReturnedRowLimit();
        if (!scanProperties.isReverse()) {
            this.firstFunction = func1;
            this.secondFunction = func2;
        } else {
            this.firstFunction = func2;
            this.secondFunction = func1;
        }
        this.currentCursorContinuation = null;
        if (continuation != null) {
            try {
                RecordCursorProto.ConcatContinuation concatContinuation = RecordCursorProto.ConcatContinuation.parseFrom(continuation);
                this.currentCursorContinuation = concatContinuation.getContinuation().toByteArray();
                if (concatContinuation.hasSecond() && concatContinuation.getSecond()) {
                    this.secondCursor = this.secondFunction.apply(context, scanProperties, this.currentCursorContinuation);
                    this.firstCursor = null;
                }
                this.firstCursor = this.firstFunction.apply(context, scanProperties, this.currentCursorContinuation);
                this.secondCursor = null;
            }
            catch (InvalidProtocolBufferException ex) {
                throw new RecordCoreException("Error parsing ConcatCursor continuation", ex).addLogInfo("raw_bytes", (Object)ByteArrayUtil2.loggable(continuation));
            }
        } else {
            this.firstCursor = this.firstFunction.apply(context, scanProperties, this.currentCursorContinuation);
            this.secondCursor = null;
            this.currentCursorContinuation = null;
        }
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<T>> onNext() {
        if (this.secondCursor == null) {
            return ((CompletableFuture)this.firstCursor.onNext().thenCompose(result -> {
                if (result.hasNext() || !result.getNoNextReason().isSourceExhausted()) {
                    return CompletableFuture.completedFuture(result);
                }
                Function<ExecuteProperties, ExecuteProperties> f = e -> e.toBuilder().setReturnedRowLimit(this.rowLimit).build();
                this.secondCursor = this.secondFunction.apply(this.context, this.scanProperties.with(f), null);
                return this.secondCursor.onNext();
            })).thenApply(this::postProcess);
        }
        return this.secondCursor.onNext().thenApply(this::postProcess);
    }

    @Nonnull
    private RecordCursorResult<T> postProcess(RecordCursorResult<T> result) {
        this.nextResult = this.getConcatResult(result);
        return this.nextResult;
    }

    @Nonnull
    private RecordCursorResult<T> getConcatResult(RecordCursorResult<T> nextResult) {
        RecordCursorResult concatResult;
        if (!nextResult.hasNext()) {
            concatResult = this.secondCursor != null && nextResult.getNoNextReason().isSourceExhausted() ? RecordCursorResult.exhausted() : RecordCursorResult.withoutNextValue(new ConcatCursorContinuation(this.secondCursor != null, nextResult), nextResult.getNoNextReason());
        } else {
            concatResult = RecordCursorResult.withNextValue(nextResult.get(), new ConcatCursorContinuation(this.secondCursor != null, nextResult));
            this.rowLimit = Integer.max(0, this.rowLimit - 1);
        }
        return concatResult;
    }

    @Override
    public void close() {
        if (this.secondCursor != null) {
            this.secondCursor.close();
        }
        if (this.firstCursor != null) {
            this.firstCursor.close();
        }
    }

    @Override
    public boolean isClosed() {
        return !(this.secondCursor != null && !this.secondCursor.isClosed() || this.firstCursor != null && !this.firstCursor.isClosed());
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.context.getExecutor();
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        if (visitor.visitEnter(this)) {
            if (this.secondCursor == null) {
                this.firstCursor.accept(visitor);
            } else {
                this.secondCursor.accept(visitor);
            }
        }
        return visitor.visitLeave(this);
    }

    private class ConcatCursorContinuation
    implements RecordCursorContinuation {
        @Nonnull
        private final RecordCursorResult<T> nextResult;
        @Nonnull
        private final Function<ByteString, RecordCursorProto.ConcatContinuation> continuationFunction;
        private final boolean isEnd;
        @Nullable
        private byte[] cachedBytes;
        @Nullable
        private ByteString cachedByteString;

        private ConcatCursorContinuation(@Nonnull boolean secondCursor, RecordCursorResult<T> nextResult) {
            this.nextResult = nextResult;
            this.cachedBytes = null;
            this.isEnd = secondCursor && nextResult.getContinuation().isEnd();
            this.continuationFunction = b -> RecordCursorProto.ConcatContinuation.newBuilder().setSecond(secondCursor).setContinuation((ByteString)b).build();
        }

        @Override
        @Nullable
        public byte[] toBytes() {
            if (this.isEnd()) {
                return null;
            }
            if (this.cachedBytes == null) {
                this.cachedBytes = this.toByteString().toByteArray();
            }
            return this.cachedBytes;
        }

        @Override
        @Nonnull
        public ByteString toByteString() {
            if (this.isEnd()) {
                return ByteString.EMPTY;
            }
            if (this.cachedByteString == null) {
                this.cachedByteString = this.continuationFunction.apply(this.nextResult.getContinuation().toByteString()).toByteString();
            }
            return this.cachedByteString;
        }

        @Override
        public boolean isEnd() {
            return this.isEnd;
        }
    }
}

