/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ByteScanLimiter;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordScanLimiter;
import com.apple.foundationdb.record.ScanLimitReachedException;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TimeScanLimiter;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class CursorLimitManager {
    @Nullable
    private final RecordScanLimiter recordScanLimiter;
    private final boolean failOnScanLimitReached;
    private boolean haltedDueToRecordScanLimit = false;
    @Nullable
    private final ByteScanLimiter byteScanLimiter;
    private boolean haltedDueToByteScanLimit = false;
    @Nullable
    private final TimeScanLimiter timeScanLimiter;
    private boolean haltedDueToTimeLimit = false;
    private boolean usedInitialPass = false;
    private static final Optional<RecordCursor.NoNextReason> SCAN_LIMIT_REACHED = Optional.of(RecordCursor.NoNextReason.SCAN_LIMIT_REACHED);
    private static final Optional<RecordCursor.NoNextReason> BYTE_LIMIT_REACHED = Optional.of(RecordCursor.NoNextReason.BYTE_LIMIT_REACHED);
    private static final Optional<RecordCursor.NoNextReason> TIME_LIMIT_REACHED = Optional.of(RecordCursor.NoNextReason.TIME_LIMIT_REACHED);
    public static final CursorLimitManager UNTRACKED = new CursorLimitManager(null, false, null, null);

    @VisibleForTesting
    public CursorLimitManager(@Nullable RecordScanLimiter recordScanLimiter, boolean failOnScanLimitReached, @Nullable ByteScanLimiter byteScanLimiter, @Nullable TimeScanLimiter timeScanLimiter) {
        this.recordScanLimiter = recordScanLimiter;
        this.failOnScanLimitReached = failOnScanLimitReached;
        this.byteScanLimiter = byteScanLimiter;
        this.timeScanLimiter = timeScanLimiter;
    }

    public CursorLimitManager(@Nonnull ScanProperties scanProperties) {
        this(null, scanProperties);
    }

    public CursorLimitManager(@Nullable FDBRecordContext context, @Nonnull ScanProperties scanProperties) {
        this.recordScanLimiter = scanProperties.getExecuteProperties().getState().getRecordScanLimiter();
        this.byteScanLimiter = scanProperties.getExecuteProperties().getState().getByteScanLimiter();
        this.failOnScanLimitReached = scanProperties.getExecuteProperties().isFailOnScanLimitReached();
        this.timeScanLimiter = scanProperties.getExecuteProperties().getTimeLimit() != 0L ? new TimeScanLimiter(context != null ? context.getTransactionCreateTime() : System.currentTimeMillis(), scanProperties.getExecuteProperties().getTimeLimit()) : null;
    }

    public boolean isStopped() {
        return this.getStoppedReason().isPresent();
    }

    public Optional<RecordCursor.NoNextReason> getStoppedReason() {
        if (this.haltedDueToRecordScanLimit) {
            return SCAN_LIMIT_REACHED;
        }
        if (this.haltedDueToByteScanLimit) {
            return BYTE_LIMIT_REACHED;
        }
        if (this.haltedDueToTimeLimit) {
            return TIME_LIMIT_REACHED;
        }
        return Optional.empty();
    }

    public boolean tryRecordScan() {
        boolean halted;
        this.haltedDueToRecordScanLimit = this.recordScanLimiter != null && !this.recordScanLimiter.tryRecordScan() && (this.usedInitialPass || this.failOnScanLimitReached);
        this.haltedDueToByteScanLimit = this.byteScanLimiter != null && !this.byteScanLimiter.hasBytesRemaining() && this.usedInitialPass;
        this.haltedDueToTimeLimit = this.timeScanLimiter != null && !this.timeScanLimiter.tryRecordScan() && this.usedInitialPass;
        boolean bl = halted = this.haltedDueToRecordScanLimit || this.haltedDueToByteScanLimit || this.haltedDueToTimeLimit;
        if (!halted) {
            this.usedInitialPass = true;
        } else if (this.failOnScanLimitReached) {
            throw new ScanLimitReachedException("limit on number of key-values scanned per transaction reached").addLogInfo("no_next_reason", (Object)this.getStoppedReason().map(Enum::toString).orElse("Unknown."));
        }
        return !halted;
    }

    public void reportScannedBytes(long byteSize) {
        if (this.byteScanLimiter != null) {
            this.byteScanLimiter.registerScannedBytes(byteSize);
        }
    }
}

