/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class DedupCursor<T>
implements RecordCursor<T> {
    @Nonnull
    private final RecordCursor<T> inner;
    @Nullable
    private RecordCursorResult<T> nextResult;
    @Nullable
    private T lastValue;
    @Nonnull
    private final Function<T, byte[]> packValue;

    @API(value=API.Status.EXPERIMENTAL)
    public DedupCursor(@Nonnull Function<byte[], RecordCursor<T>> innerCursorFactory, @Nonnull Function<byte[], T> unpackValue, @Nonnull Function<T, byte[]> packValue, @Nullable byte[] continuation) {
        this.packValue = packValue;
        byte[] innerContinuation = null;
        if (continuation != null) {
            try {
                RecordCursorProto.DedupContinuation dedupContinuation = RecordCursorProto.DedupContinuation.parseFrom(continuation);
                innerContinuation = dedupContinuation.getInnerContinuation().toByteArray();
                if (dedupContinuation.hasLastValue()) {
                    this.lastValue = unpackValue.apply(dedupContinuation.getLastValue().toByteArray());
                }
            }
            catch (InvalidProtocolBufferException ex) {
                throw new RecordCoreException("Error parsing continuation", ex).addLogInfo("raw_bytes", (Object)ByteArrayUtil2.loggable(continuation));
            }
        }
        this.inner = innerCursorFactory.apply(innerContinuation);
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<T>> onNext() {
        if (this.nextResult != null && !this.nextResult.hasNext()) {
            return CompletableFuture.completedFuture(this.nextResult);
        }
        AtomicReference currentResult = new AtomicReference();
        return AsyncUtil.whileTrue(() -> this.inner.onNext().thenApply(innerResult -> {
            currentResult.set(innerResult);
            boolean hasNext = innerResult.hasNext();
            return hasNext && Objects.equals(innerResult.get(), this.lastValue);
        }), this.getExecutor()).thenApply(vignore -> this.applyResult((RecordCursorResult)currentResult.get()));
    }

    @Nullable
    private RecordCursorResult<T> applyResult(RecordCursorResult<T> currentResult) {
        if (currentResult.hasNext()) {
            this.lastValue = currentResult.get();
            this.nextResult = RecordCursorResult.withNextValue(this.lastValue, new DedupCursorContinuation(currentResult.getContinuation(), this.lastValue));
        } else {
            this.nextResult = currentResult.getNoNextReason().isSourceExhausted() ? RecordCursorResult.exhausted() : RecordCursorResult.withoutNextValue(new DedupCursorContinuation(currentResult.getContinuation(), this.lastValue), currentResult.getNoNextReason());
        }
        return this.nextResult;
    }

    @Override
    public void close() {
        this.inner.close();
    }

    @Override
    public boolean isClosed() {
        return this.inner.isClosed();
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.inner.getExecutor();
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        if (visitor.visitEnter(this)) {
            this.inner.accept(visitor);
        }
        return visitor.visitLeave(this);
    }

    private class DedupCursorContinuation
    implements RecordCursorContinuation {
        @Nonnull
        private final RecordCursorContinuation innerContinuation;
        @Nullable
        private final T lastValue;
        private byte[] cachedBytes;

        private DedupCursorContinuation(@Nullable RecordCursorContinuation innerContinuation, T lastValue) {
            this.innerContinuation = innerContinuation;
            this.lastValue = lastValue;
        }

        @Override
        @Nullable
        public byte[] toBytes() {
            if (this.isEnd()) {
                return null;
            }
            if (this.cachedBytes == null) {
                byte[] lastValuePacked = this.pack(this.lastValue);
                RecordCursorProto.DedupContinuation.Builder builder = RecordCursorProto.DedupContinuation.newBuilder().setInnerContinuation(this.innerContinuation.toByteString());
                if (lastValuePacked != null) {
                    builder.setLastValue(ByteString.copyFrom(lastValuePacked));
                }
                this.cachedBytes = builder.build().toByteArray();
            }
            return this.cachedBytes;
        }

        @Override
        public boolean isEnd() {
            return this.innerContinuation.isEnd();
        }

        private byte[] pack(T value) {
            return value == null ? null : DedupCursor.this.packValue.apply(value);
        }
    }
}

