/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.util.LoggableException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public class FallbackCursor<T>
implements RecordCursor<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FallbackCursor.class);
    @Nonnull
    private final Function<RecordCursorResult<T>, RecordCursor<T>> fallbackCursorSupplier;
    @Nonnull
    private final Executor executor;
    @Nonnull
    private RecordCursor<T> inner;
    @Nullable
    private CompletableFuture<RecordCursorResult<T>> nextResultFuture;
    @Nullable
    private RecordCursorResult<T> lastSuccessfulResult;
    private boolean alreadyFailed = false;

    public FallbackCursor(@Nonnull RecordCursor<T> inner, @Nonnull Function<RecordCursorResult<T>, RecordCursor<T>> fallbackCursorSupplier) {
        this.inner = inner;
        this.fallbackCursorSupplier = fallbackCursorSupplier;
        this.executor = inner.getExecutor();
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<T>> onNext() {
        try {
            if (this.nextResultFuture != null && this.nextResultFuture.isDone() && !this.nextResultFuture.join().hasNext()) {
                return this.nextResultFuture;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ((CompletableFuture)this.inner.onNext().handle((result, throwable) -> {
            if (throwable == null) {
                this.nextResultFuture = CompletableFuture.completedFuture(result);
                this.lastSuccessfulResult = result;
            } else {
                if (this.alreadyFailed) {
                    this.nextResultFuture = CompletableFuture.failedFuture(this.wrapException("Fallback cursor failed, cannot fallback again", (Throwable)throwable));
                } else {
                    this.inner.close();
                    this.inner = this.fallbackCursorSupplier.apply(this.lastSuccessfulResult);
                    this.nextResultFuture = this.inner.onNext();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info(KeyValueLogMessage.of("fallback triggered", new Object[]{LogMessageKeys.MESSAGE, throwable.getMessage()}));
                    }
                }
                this.alreadyFailed = true;
            }
            return null;
        })).thenCompose(vignore -> this.nextResultFuture);
    }

    @Override
    public void close() {
        this.inner.close();
    }

    @Override
    public boolean isClosed() {
        return this.inner.isClosed();
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.executor;
    }

    private RecordCursor<T> getInner() {
        return this.inner;
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        if (visitor.visitEnter(this)) {
            this.getInner().accept(visitor);
        }
        return visitor.visitLeave(this);
    }

    private Throwable wrapException(String msg, Throwable ex) {
        if (ex instanceof LoggableException) {
            LoggableException loggableException = (LoggableException)ex;
            loggableException.addLogInfo("fallback_failed", (Object)msg);
            return ex;
        }
        if (ex.getCause() != null && ex.getCause() instanceof LoggableException) {
            LoggableException loggableException = (LoggableException)ex.getCause();
            loggableException.addLogInfo("fallback_failed", (Object)msg);
            return ex;
        }
        return new FallbackExecutionFailedException(msg, ex);
    }

    public static class FallbackExecutionFailedException
    extends RecordCoreException {
        public static final long serialVersionUID = 1L;

        public FallbackExecutionFailedException(@Nonnull String msg, @Nullable Throwable cause) {
            super(msg, cause);
        }
    }
}

