/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class FilterCursor<T>
implements RecordCursor<T> {
    @Nonnull
    private final RecordCursor<T> inner;
    @Nonnull
    private final Function<T, Boolean> pred;
    private boolean hasNext;
    @Nullable
    private RecordCursorResult<T> nextResult;

    public FilterCursor(@Nonnull RecordCursor<T> inner, @Nonnull Function<T, Boolean> pred) {
        this.inner = inner;
        this.pred = pred;
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<T>> onNext() {
        if (this.nextResult != null && !this.nextResult.hasNext()) {
            return CompletableFuture.completedFuture(this.nextResult);
        }
        return AsyncUtil.whileTrue(() -> this.inner.onNext().thenApply(innerResult -> {
            this.nextResult = innerResult;
            this.hasNext = innerResult.hasNext() && Boolean.TRUE.equals(this.pred.apply(innerResult.get()));
            return innerResult.hasNext() && !this.hasNext;
        }), this.getExecutor()).thenApply(vignore -> this.nextResult);
    }

    @Override
    public void close() {
        this.inner.close();
    }

    @Override
    public boolean isClosed() {
        return this.inner.isClosed();
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.inner.getExecutor();
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        if (visitor.visitEnter(this)) {
            this.inner.accept(visitor);
        }
        return visitor.visitLeave(this);
    }
}

