/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.MoreAsyncUtil;
import com.apple.foundationdb.record.ByteArrayContinuation;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorStartContinuation;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.google.protobuf.ByteString;
import com.google.protobuf.ZeroCopyByteString;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class FlatMapPipelinedCursor<T, V>
implements RecordCursor<V> {
    private static final CompletableFuture<Boolean> ALREADY_CANCELLED = MoreAsyncUtil.alreadyCancelled();
    @Nonnull
    private final RecordCursor<T> outerCursor;
    @Nonnull
    private final BiFunction<T, byte[], ? extends RecordCursor<V>> innerCursorFunction;
    @Nullable
    private final Function<T, byte[]> checkValueFunction;
    @Nonnull
    private RecordCursorContinuation outerContinuation;
    @Nullable
    private final byte[] initialCheckValue;
    @Nullable
    private byte[] initialInnerContinuation;
    private final int pipelineSize;
    @Nonnull
    private final Queue<PipelineQueueEntry> pipeline;
    @Nullable
    private volatile CompletableFuture<RecordCursorResult<T>> outerNextFuture;
    private volatile boolean outerExhausted = false;
    private volatile boolean closed = false;
    @Nullable
    private RecordCursorResult<V> lastResult;

    @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP2"})
    public FlatMapPipelinedCursor(@Nonnull RecordCursor<T> outerCursor, @Nonnull BiFunction<T, byte[], ? extends RecordCursor<V>> innerCursorFunction, @Nullable Function<T, byte[]> checkValueFunction, @Nullable byte[] outerContinuation, @Nullable byte[] initialCheckValue, @Nullable byte[] initialInnerContinuation, int pipelineSize) {
        this.outerCursor = outerCursor;
        this.innerCursorFunction = innerCursorFunction;
        this.checkValueFunction = checkValueFunction;
        this.outerContinuation = outerContinuation == null ? RecordCursorStartContinuation.START : ByteArrayContinuation.fromNullable(outerContinuation);
        this.initialInnerContinuation = initialInnerContinuation;
        this.initialCheckValue = initialCheckValue;
        this.pipelineSize = pipelineSize;
        this.pipeline = new ArrayDeque<PipelineQueueEntry>(pipelineSize);
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<V>> onNext() {
        if (this.lastResult != null && !this.lastResult.hasNext()) {
            return CompletableFuture.completedFuture(this.lastResult);
        }
        return AsyncUtil.whileTrue(this::tryToFillPipeline, this.getExecutor()).thenApply(vignore -> {
            PipelineQueueEntry peeked = this.peekPipeline();
            if (peeked == null) {
                throw new CancellationException("cursor closed while iterating");
            }
            this.lastResult = peeked.nextResult();
            return this.lastResult;
        });
    }

    private synchronized void markClosed() {
        this.closed = true;
        while (!this.pipeline.isEmpty()) {
            this.pipeline.remove().close();
        }
        if (this.outerNextFuture != null) {
            this.outerNextFuture.cancel(false);
            this.outerNextFuture = null;
        }
        this.outerCursor.close();
    }

    @Override
    public void close() {
        this.markClosed();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        if (visitor.visitEnter(this)) {
            this.outerCursor.accept(visitor);
        }
        return visitor.visitLeave(this);
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.outerCursor.getExecutor();
    }

    @Nonnull
    protected CompletableFuture<Boolean> tryToFillPipeline() {
        PipelineQueueEntry peeked;
        if (this.closed) {
            return ALREADY_CANCELLED;
        }
        this.clearUnusedPipelineEntries();
        while (this.continueFillingPipeline()) {
            CompletableFuture<RecordCursorResult<T>> outerNext = this.ensureOuterCursorAdvanced();
            if (outerNext == null) {
                return ALREADY_CANCELLED;
            }
            if (!outerNext.isDone()) {
                PipelineQueueEntry nextEntry = this.peekPipeline();
                if (nextEntry == null) {
                    return outerNext.thenApply(vignore -> true);
                }
                CompletableFuture<PipelineQueueEntry> innerPipelineFuture = nextEntry.getNextInnerPipelineFuture();
                return CompletableFuture.anyOf(outerNext, innerPipelineFuture).thenApply(vignore -> !innerPipelineFuture.isDone() || ((PipelineQueueEntry)innerPipelineFuture.join()).doesNotHaveReturnableResult());
            }
            RecordCursorResult<T> outerResult = outerNext.join();
            if (outerResult.hasNext()) {
                RecordCursorContinuation priorOuterContinuation = this.outerContinuation;
                T outerValue = outerResult.get();
                byte[] outerCheckValue = this.checkValueFunction == null ? null : this.checkValueFunction.apply(outerValue);
                byte[] innerContinuation = null;
                if (this.initialInnerContinuation != null && (this.initialCheckValue == null || outerCheckValue == null || Arrays.equals(this.initialCheckValue, outerCheckValue))) {
                    innerContinuation = this.initialInnerContinuation;
                    this.initialInnerContinuation = null;
                }
                RecordCursor<V> innerCursor = this.innerCursorFunction.apply(outerValue, innerContinuation);
                this.outerContinuation = outerResult.getContinuation();
                this.addEntryToPipeline(new PipelineQueueEntry(innerCursor, priorOuterContinuation, outerResult, outerCheckValue));
                this.outerNextFuture = null;
                continue;
            }
            this.addEntryToPipeline(new PipelineQueueEntry(null, this.outerContinuation, outerResult, null));
            this.outerExhausted = true;
            break;
        }
        if ((peeked = this.peekPipeline()) == null) {
            return ALREADY_CANCELLED;
        }
        return peeked.getNextInnerPipelineFuture().thenApply(PipelineQueueEntry::doesNotHaveReturnableResult);
    }

    private synchronized void clearUnusedPipelineEntries() {
        while (!this.pipeline.isEmpty() && this.pipeline.peek().doesNotHaveReturnableResult()) {
            this.pipeline.remove().close();
        }
    }

    @Nullable
    private synchronized CompletableFuture<RecordCursorResult<T>> ensureOuterCursorAdvanced() {
        if (this.closed) {
            return null;
        }
        if (this.outerNextFuture == null) {
            this.outerNextFuture = this.outerCursor.onNext();
        }
        return this.outerNextFuture;
    }

    private synchronized void addEntryToPipeline(PipelineQueueEntry pipelineQueueEntry) {
        if (this.closed) {
            pipelineQueueEntry.close();
        }
        this.pipeline.add(pipelineQueueEntry);
    }

    private synchronized boolean continueFillingPipeline() {
        return !this.closed && !this.outerExhausted && this.pipeline.size() < this.pipelineSize;
    }

    private synchronized PipelineQueueEntry peekPipeline() {
        return this.pipeline.peek();
    }

    private class PipelineQueueEntry {
        final RecordCursor<V> innerCursor;
        final RecordCursorContinuation priorOuterContinuation;
        final RecordCursorResult<T> outerResult;
        final byte[] outerCheckValue;
        private CompletableFuture<RecordCursorResult<V>> innerFuture;

        public PipelineQueueEntry(RecordCursor<V> innerCursor, RecordCursorContinuation priorOuterContinuation, RecordCursorResult<T> outerResult, byte[] outerCheckValue) {
            this.innerCursor = innerCursor;
            this.priorOuterContinuation = priorOuterContinuation;
            this.outerResult = outerResult;
            this.outerCheckValue = outerCheckValue;
        }

        @Nonnull
        public CompletableFuture<PipelineQueueEntry> getNextInnerPipelineFuture() {
            if (this.innerFuture == null) {
                this.innerFuture = this.innerCursor == null ? CompletableFuture.completedFuture(RecordCursorResult.exhausted()) : this.innerCursor.onNext();
            }
            return this.innerFuture.thenApply(vignore -> this);
        }

        public boolean doesNotHaveReturnableResult() {
            if (this.innerCursor == null || this.innerFuture == null || !this.innerFuture.isDone()) {
                return false;
            }
            RecordCursorResult innerResult = this.innerFuture.join();
            if (innerResult.hasNext()) {
                return false;
            }
            return innerResult.getNoNextReason().isSourceExhausted();
        }

        public void close() {
            if (this.innerFuture != null && this.innerFuture.cancel(false)) {
                this.innerCursor.close();
            }
        }

        @Nonnull
        public RecordCursorResult<V> nextResult() {
            RecordCursorResult<Object> result;
            RecordCursorResult innerResult = this.innerFuture.join();
            if (innerResult.hasNext()) {
                result = RecordCursorResult.withNextValue(innerResult.get(), this.toContinuation());
            } else {
                RecordCursor.NoNextReason reason = innerResult.getNoNextReason().isSourceExhausted() ? this.outerResult.getNoNextReason() : innerResult.getNoNextReason();
                result = RecordCursorResult.withoutNextValue(this.toContinuation(), reason);
            }
            this.innerFuture = null;
            return result;
        }

        @Nonnull
        private Continuation<T, V> toContinuation() {
            return new Continuation(this.priorOuterContinuation, this.outerResult, this.outerCheckValue, this.innerFuture.join());
        }
    }

    private static class Continuation<T, V>
    implements RecordCursorContinuation {
        @Nonnull
        private final RecordCursorContinuation priorOuterContinuation;
        @Nonnull
        private final RecordCursorResult<T> outerResult;
        @Nullable
        private final byte[] outerCheckValue;
        @Nonnull
        private final RecordCursorResult<V> innerResult;
        @Nullable
        private ByteString cachedByteString;
        @Nullable
        private byte[] cachedBytes;

        public Continuation(@Nonnull RecordCursorContinuation priorOuterContinuation, @Nonnull RecordCursorResult<T> outerResult, @Nullable byte[] outerCheckValue, @Nonnull RecordCursorResult<V> innerResult) {
            this.priorOuterContinuation = priorOuterContinuation;
            this.outerResult = outerResult;
            this.outerCheckValue = outerCheckValue;
            this.innerResult = innerResult;
        }

        @Override
        public boolean isEnd() {
            return this.outerResult.getContinuation().isEnd() && this.innerResult.getContinuation().isEnd();
        }

        @Override
        @Nonnull
        public ByteString toByteString() {
            if (this.isEnd()) {
                return ByteString.EMPTY;
            }
            if (this.cachedByteString == null) {
                RecordCursorProto.FlatMapContinuation.Builder builder = RecordCursorProto.FlatMapContinuation.newBuilder();
                RecordCursorContinuation innerContinuation = this.innerResult.getContinuation();
                if (innerContinuation.isEnd()) {
                    builder.setOuterContinuation(this.outerResult.getContinuation().toByteString());
                } else {
                    ByteString priorOuterContinuationBytes = this.priorOuterContinuation.toByteString();
                    if (!priorOuterContinuationBytes.isEmpty()) {
                        builder.setOuterContinuation(priorOuterContinuationBytes);
                    }
                    if (this.outerCheckValue != null) {
                        builder.setCheckValue(ZeroCopyByteString.wrap(this.outerCheckValue));
                    }
                    builder.setInnerContinuation(innerContinuation.toByteString());
                }
                this.cachedByteString = builder.build().toByteString();
            }
            return this.cachedByteString;
        }

        @Override
        @Nullable
        public byte[] toBytes() {
            if (this.isEnd()) {
                return null;
            }
            if (this.cachedBytes == null) {
                this.cachedBytes = this.toByteString().toByteArray();
            }
            return this.cachedBytes;
        }
    }
}

