/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ByteArrayContinuation;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class FutureCursor<T>
implements RecordCursor<T> {
    @Nonnull
    private final Executor executor;
    @Nonnull
    private final CompletableFuture<T> future;
    private boolean done;
    @Nullable
    private RecordCursorResult<T> nextResult;
    @Nonnull
    private static final RecordCursorContinuation notDoneContinuation = ByteArrayContinuation.fromNullable(new byte[]{0});

    @API(value=API.Status.INTERNAL)
    public FutureCursor(@Nonnull Executor executor, @Nonnull CompletableFuture<T> future) {
        this.executor = executor;
        this.future = future;
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<T>> onNext() {
        if (this.done) {
            this.nextResult = RecordCursorResult.exhausted();
            return CompletableFuture.completedFuture(this.nextResult);
        }
        return this.future.thenApply(t2 -> {
            this.done = true;
            this.nextResult = RecordCursorResult.withNextValue(t2, notDoneContinuation);
            return this.nextResult;
        });
    }

    @Override
    public void close() {
        this.done = true;
    }

    @Override
    public boolean isClosed() {
        return this.done;
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        visitor.visitEnter(this);
        return visitor.visitLeave(this);
    }
}

