/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.async.MoreAsyncUtil;
import com.apple.foundationdb.record.ByteArrayContinuation;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import java.util.Iterator;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class IteratorCursorBase<T, C extends Iterator<T>>
implements RecordCursor<T> {
    @Nonnull
    protected final Executor executor;
    @Nonnull
    protected final C iterator;
    protected int valuesSeen;
    private boolean closed;
    @Nullable
    protected RecordCursorResult<T> nextResult;

    protected IteratorCursorBase(@Nonnull Executor executor, @Nonnull C iterator) {
        this.executor = executor;
        this.iterator = iterator;
        this.valuesSeen = 0;
        this.closed = false;
    }

    protected RecordCursorResult<T> computeNextResult(boolean hasNext) {
        if (hasNext) {
            ++this.valuesSeen;
            this.nextResult = RecordCursorResult.withNextValue(this.iterator.next(), ByteArrayContinuation.fromInt(this.valuesSeen));
        } else {
            this.nextResult = RecordCursorResult.exhausted();
        }
        return this.nextResult;
    }

    @Override
    public void close() {
        MoreAsyncUtil.closeIterator(this.iterator);
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        visitor.visitEnter(this);
        return visitor.visitLeave(this);
    }
}

