/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class LazyCursor<T>
implements RecordCursor<T> {
    @Nonnull
    private final CompletableFuture<RecordCursor<T>> futureCursor;
    private final Executor executor;
    @Nullable
    private RecordCursor<T> inner;
    @Nullable
    private RecordCursorResult<T> nextResult;

    public LazyCursor(@Nonnull CompletableFuture<RecordCursor<T>> futureCursor) {
        this(futureCursor, null);
    }

    public LazyCursor(@Nonnull CompletableFuture<RecordCursor<T>> futureCursor, @Nullable Executor executor) {
        this.futureCursor = futureCursor;
        this.executor = executor;
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<T>> onNext() {
        if (this.nextResult != null && !this.nextResult.hasNext()) {
            return CompletableFuture.completedFuture(this.nextResult);
        }
        if (this.inner == null) {
            return ((CompletableFuture)this.futureCursor.thenAccept(cursor -> {
                this.inner = cursor;
            })).thenCompose(vignore -> this.onNext());
        }
        return this.inner.onNext().thenApply(result -> {
            this.nextResult = result;
            return result;
        });
    }

    @Override
    public void close() {
        if (this.inner != null) {
            this.inner.close();
        }
    }

    @Override
    public boolean isClosed() {
        return this.inner == null || this.inner.isClosed();
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        if (this.executor == null) {
            return this.getInner().getExecutor();
        }
        return this.executor;
    }

    private RecordCursor<T> getInner() {
        if (this.inner == null) {
            throw new RecordCoreException("Inner cursor is not available until onNext() is called", new Object[0]);
        }
        return this.inner;
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        if (visitor.visitEnter(this)) {
            this.getInner().accept(visitor);
        }
        return visitor.visitLeave(this);
    }
}

