/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.google.protobuf.ByteString;
import com.google.protobuf.ZeroCopyByteString;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class ListCursor<T>
implements RecordCursor<T> {
    @Nonnull
    private final Executor executor;
    @Nonnull
    private final List<T> list;
    private int nextPosition;
    private boolean closed = false;

    public ListCursor(@Nonnull List<T> list, byte[] continuation) {
        this(ForkJoinPool.commonPool(), list, continuation != null ? ByteBuffer.wrap(continuation).getInt() : 0);
    }

    public ListCursor(@Nonnull Executor executor, @Nonnull List<T> list, int nextPosition) {
        this.executor = executor;
        this.list = list;
        this.nextPosition = nextPosition;
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<T>> onNext() {
        return CompletableFuture.completedFuture(this.getNext());
    }

    @Override
    @Nonnull
    public RecordCursorResult<T> getNext() {
        RecordCursorResult nextResult;
        if (this.nextPosition < this.list.size()) {
            nextResult = RecordCursorResult.withNextValue(this.list.get(this.nextPosition), new Continuation(this.nextPosition + 1, this.list.size()));
            ++this.nextPosition;
        } else {
            nextResult = RecordCursorResult.exhausted();
        }
        return nextResult;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        visitor.visitEnter(this);
        return visitor.visitLeave(this);
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.executor;
    }

    private static class Continuation
    implements RecordCursorContinuation {
        private final int listSize;
        private final int nextPosition;

        public Continuation(int nextPosition, int listSize) {
            this.nextPosition = nextPosition;
            this.listSize = listSize;
        }

        @Override
        public boolean isEnd() {
            return this.nextPosition > this.listSize;
        }

        @Override
        @Nonnull
        public ByteString toByteString() {
            if (this.isEnd()) {
                return ByteString.EMPTY;
            }
            return ZeroCopyByteString.wrap(Objects.requireNonNull(this.toBytes()));
        }

        @Override
        @Nullable
        public byte[] toBytes() {
            if (this.isEnd()) {
                return null;
            }
            return ByteBuffer.allocate(4).putInt(this.nextPosition).array();
        }
    }
}

