/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorStartContinuation;
import com.apple.foundationdb.record.RecordCursorVisitor;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class MapWhileCursor<T, V>
implements RecordCursor<V> {
    @Nonnull
    private final RecordCursor<T> inner;
    @Nonnull
    private final Function<T, Optional<V>> func;
    @Nonnull
    private final StopContinuation stopContinuation;
    @Nonnull
    private RecordCursorResult<V> nextResult = RecordCursorResult.withNextValue(null, RecordCursorStartContinuation.START);

    @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP2"})
    public MapWhileCursor(@Nonnull RecordCursor<T> inner, @Nonnull Function<T, Optional<V>> func, @Nonnull StopContinuation stopContinuation, @Nullable byte[] initialContinuation, @Nonnull RecordCursor.NoNextReason noNextReason) {
        this.inner = inner;
        this.func = func;
        this.stopContinuation = stopContinuation;
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<V>> onNext() {
        if (!this.nextResult.hasNext()) {
            return CompletableFuture.completedFuture(this.nextResult);
        }
        return this.inner.onNext().thenApply(innerResult -> {
            if (!innerResult.hasNext()) {
                this.nextResult = RecordCursorResult.withoutNextValue(innerResult);
                return this.nextResult;
            }
            Optional<V> maybeRecord = this.func.apply(innerResult.get());
            if (maybeRecord.isPresent()) {
                this.nextResult = RecordCursorResult.withNextValue(maybeRecord.get(), innerResult.getContinuation());
                return this.nextResult;
            }
            switch (this.stopContinuation) {
                case NONE: {
                    this.nextResult = RecordCursorResult.exhausted();
                    break;
                }
                case BEFORE: {
                    RecordCursorContinuation continuation = this.nextResult.getContinuation();
                    this.nextResult = RecordCursorResult.withoutNextValue(continuation, RecordCursor.NoNextReason.SCAN_LIMIT_REACHED);
                    break;
                }
                default: {
                    this.nextResult = RecordCursorResult.withoutNextValue(innerResult.getContinuation(), RecordCursor.NoNextReason.SCAN_LIMIT_REACHED);
                }
            }
            return this.nextResult;
        });
    }

    @Override
    public void close() {
        this.inner.close();
    }

    @Override
    public boolean isClosed() {
        return this.inner.isClosed();
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.inner.getExecutor();
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        if (visitor.visitEnter(this)) {
            this.inner.accept(visitor);
        }
        return visitor.visitLeave(this);
    }

    public static enum StopContinuation {
        NONE,
        AFTER,
        BEFORE;

    }
}

