/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class OrElseCursor<T>
implements RecordCursor<T> {
    @Nonnull
    private final RecordCursor<T> inner;
    @Nonnull
    private final Function<Executor, RecordCursor<T>> func;
    @Nonnull
    private RecordCursorProto.OrElseContinuation.State state;
    @Nullable
    private RecordCursor<T> other;
    @Nullable
    private RecordCursorResult<T> nextResult;

    @API(value=API.Status.INTERNAL)
    public OrElseCursor(@Nonnull Function<byte[], ? extends RecordCursor<T>> innerFunc, @Nonnull BiFunction<Executor, byte[], ? extends RecordCursor<T>> elseFunc, @Nullable byte[] continuation) {
        Function<Executor, RecordCursor> newElseFunc = executor -> (RecordCursor)elseFunc.apply((Executor)executor, (byte[])null);
        if (continuation == null) {
            this.state = RecordCursorProto.OrElseContinuation.State.UNDECIDED;
            this.inner = innerFunc.apply(null);
            this.func = newElseFunc;
        } else {
            RecordCursorProto.OrElseContinuation parsed;
            try {
                parsed = RecordCursorProto.OrElseContinuation.parseFrom(continuation);
            }
            catch (InvalidProtocolBufferException ex) {
                throw new RecordCoreException("error parsing continuation", ex).addLogInfo("raw_bytes", (Object)ByteArrayUtil2.loggable(continuation));
            }
            this.state = parsed.getState();
            switch (this.state) {
                case UNDECIDED: 
                case USE_INNER: {
                    this.inner = innerFunc.apply(parsed.getContinuation().toByteArray());
                    this.func = newElseFunc;
                    break;
                }
                case USE_OTHER: {
                    this.inner = RecordCursor.empty();
                    byte[] otherContinuation = parsed.getContinuation().toByteArray();
                    this.func = executor -> (RecordCursor)elseFunc.apply((Executor)executor, otherContinuation);
                    this.other = this.func.apply(this.getExecutor());
                    break;
                }
                default: {
                    throw new UnknownOrElseCursorStateException();
                }
            }
        }
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<T>> onNext() {
        CompletionStage<RecordCursorResult<T>> innerFuture;
        if (this.nextResult != null && !this.nextResult.hasNext()) {
            return CompletableFuture.completedFuture(this.nextResult);
        }
        switch (this.state) {
            case USE_INNER: {
                innerFuture = this.inner.onNext();
                break;
            }
            case USE_OTHER: {
                innerFuture = this.other.onNext();
                break;
            }
            case UNDECIDED: {
                innerFuture = this.inner.onNext().thenCompose(result -> {
                    if (result.hasNext()) {
                        this.state = RecordCursorProto.OrElseContinuation.State.USE_INNER;
                        return CompletableFuture.completedFuture(result);
                    }
                    if (result.getNoNextReason().isOutOfBand()) {
                        return CompletableFuture.completedFuture(result);
                    }
                    this.state = RecordCursorProto.OrElseContinuation.State.USE_OTHER;
                    this.other = this.func.apply(this.getExecutor());
                    return this.other.onNext();
                });
                break;
            }
            default: {
                throw new UnknownOrElseCursorStateException();
            }
        }
        return ((CompletableFuture)innerFuture.thenApply(result -> result.withContinuation(new Continuation(this.state, result.getContinuation())))).thenApply(this::postProcess);
    }

    @Nonnull
    private RecordCursorResult<T> postProcess(RecordCursorResult<T> result) {
        this.nextResult = result;
        return result;
    }

    @Override
    public void close() {
        if (this.other != null) {
            this.other.close();
        }
        this.inner.close();
    }

    @Override
    public boolean isClosed() {
        return (this.other == null || this.other.isClosed()) && this.inner.isClosed();
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.inner.getExecutor();
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        if (visitor.visitEnter(this)) {
            this.inner.accept(visitor);
        }
        return visitor.visitLeave(this);
    }

    private static class UnknownOrElseCursorStateException
    extends RecordCoreException {
        public static final long serialVersionUID = 1L;

        public UnknownOrElseCursorStateException() {
            super("unknown state for OrElseCursor", new Object[0]);
        }
    }

    private static class Continuation
    implements RecordCursorContinuation {
        private final RecordCursorProto.OrElseContinuation.State state;
        @Nonnull
        private final RecordCursorContinuation innerOrOtherContinuation;

        public Continuation(@Nonnull RecordCursorProto.OrElseContinuation.State state, @Nonnull RecordCursorContinuation innerOrOtherContinuation) {
            this.state = state;
            this.innerOrOtherContinuation = innerOrOtherContinuation;
        }

        @Override
        public boolean isEnd() {
            return this.innerOrOtherContinuation.isEnd();
        }

        @Override
        @Nonnull
        public ByteString toByteString() {
            ByteString bytes = this.innerOrOtherContinuation.toByteString();
            if (this.isEnd() || bytes.isEmpty()) {
                return ByteString.EMPTY;
            }
            return RecordCursorProto.OrElseContinuation.newBuilder().setState(this.state).setContinuation(bytes).build().toByteString();
        }

        @Override
        @Nullable
        public byte[] toBytes() {
            ByteString byteString = this.toByteString();
            return byteString.isEmpty() ? null : byteString.toByteArray();
        }
    }
}

