/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.google.protobuf.ByteString;
import com.google.protobuf.ZeroCopyByteString;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class RangeCursor
implements RecordCursor<Integer> {
    @Nonnull
    private final Executor executor;
    private final int exclusiveLimit;
    private int nextPosition;
    private boolean closed = false;

    public RangeCursor(@Nonnull Executor executor, int exclusiveLimit, byte[] continuation) {
        this(executor, exclusiveLimit, continuation != null ? ByteBuffer.wrap(continuation).getInt() : 0);
    }

    public RangeCursor(@Nonnull Executor executor, int exclusiveLimit, int nextPosition) {
        this.executor = executor;
        this.exclusiveLimit = exclusiveLimit;
        this.nextPosition = nextPosition;
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<Integer>> onNext() {
        return CompletableFuture.completedFuture(this.getNext());
    }

    @Override
    @Nonnull
    public RecordCursorResult<Integer> getNext() {
        RecordCursorResult<Integer> nextResult;
        if (this.nextPosition < this.exclusiveLimit) {
            nextResult = RecordCursorResult.withNextValue(this.nextPosition, new Continuation(this.nextPosition + 1, this.exclusiveLimit));
            ++this.nextPosition;
        } else {
            nextResult = RecordCursorResult.exhausted();
        }
        return nextResult;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        visitor.visitEnter(this);
        return visitor.visitLeave(this);
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.executor;
    }

    private static class Continuation
    implements RecordCursorContinuation {
        private final int size;
        private final int nextPosition;

        public Continuation(int nextPosition, int size) {
            this.nextPosition = nextPosition;
            this.size = size;
        }

        @Override
        public boolean isEnd() {
            return this.nextPosition > this.size;
        }

        @Override
        @Nonnull
        public ByteString toByteString() {
            if (this.isEnd()) {
                return ByteString.EMPTY;
            }
            return ZeroCopyByteString.wrap(Objects.requireNonNull(this.toBytes()));
        }

        @Override
        @Nullable
        public byte[] toBytes() {
            if (this.isEnd()) {
                return null;
            }
            return ByteBuffer.allocate(4).putInt(this.nextPosition).array();
        }
    }
}

