/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.ByteArrayContinuation;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorStartContinuation;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ZeroCopyByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public final class RecursiveCursor<T>
implements RecordCursor<RecursiveValue<T>> {
    @Nonnull
    private final ChildCursorFunction<T> childCursorFunction;
    @Nullable
    private final Function<T, byte[]> checkValueFunction;
    @Nonnull
    private final List<RecursiveNode<T>> nodes;
    private int currentDepth;
    @Nullable
    private RecordCursorResult<RecursiveValue<T>> lastResult;

    private RecursiveCursor(@Nonnull ChildCursorFunction<T> childCursorFunction, @Nullable Function<T, byte[]> checkValueFunction, @Nonnull List<RecursiveNode<T>> nodes) {
        this.childCursorFunction = childCursorFunction;
        this.checkValueFunction = checkValueFunction;
        this.nodes = nodes;
    }

    @Nonnull
    public static <T> RecursiveCursor<T> create(@Nonnull Function<byte[], ? extends RecordCursor<T>> rootCursorFunction, @Nonnull ChildCursorFunction<T> childCursorFunction, @Nullable Function<T, byte[]> checkValueFunction, @Nullable byte[] continuation) {
        ArrayList<RecursiveNode<T>> nodes = new ArrayList<RecursiveNode<T>>();
        if (continuation == null) {
            nodes.add(RecursiveNode.forRoot(RecordCursorStartContinuation.START, rootCursorFunction.apply(null)));
        } else {
            RecordCursorProto.RecursiveContinuation parsed;
            try {
                parsed = RecordCursorProto.RecursiveContinuation.parseFrom(continuation);
            }
            catch (InvalidProtocolBufferException ex) {
                throw new RecordCoreException("error parsing continuation", ex).addLogInfo("raw_bytes", (Object)ByteArrayUtil2.loggable(continuation));
            }
            int totalDepth = parsed.getLevelsCount();
            for (int depth = 0; depth < totalDepth; ++depth) {
                RecordCursorProto.RecursiveContinuation.LevelCursor childLevel;
                RecordCursorProto.RecursiveContinuation.LevelCursor parentLevel = parsed.getLevels(depth);
                RecordCursorContinuation priorContinuation = parentLevel.hasContinuation() ? ByteArrayContinuation.fromNullable(parentLevel.getContinuation().toByteArray()) : RecordCursorStartContinuation.START;
                if (depth == 0) {
                    nodes.add(RecursiveNode.forRoot(priorContinuation, rootCursorFunction.apply(priorContinuation.toBytes())));
                    continue;
                }
                byte[] checkValue = null;
                if (checkValueFunction != null && depth < totalDepth - 1 && (childLevel = parsed.getLevels(depth + 1)).hasCheckValue()) {
                    checkValue = childLevel.getCheckValue().toByteArray();
                }
                nodes.add(RecursiveNode.forContinuation(priorContinuation, checkValue));
            }
        }
        return new RecursiveCursor<T>(childCursorFunction, checkValueFunction, nodes);
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<RecursiveValue<T>>> onNext() {
        if (this.lastResult != null && !this.lastResult.hasNext()) {
            return CompletableFuture.completedFuture(this.lastResult);
        }
        return AsyncUtil.whileTrue(this::recursionLoop, this.getExecutor()).thenApply(vignore -> this.lastResult);
    }

    @Override
    public void close() {
        for (RecursiveNode<T> node : this.nodes) {
            RecordCursor childCursor;
            CompletableFuture childFuture = node.childFuture;
            if (childFuture != null) {
                if (!childFuture.cancel(false)) continue;
                node.childFuture = null;
            }
            if ((childCursor = node.childCursor) == null) continue;
            childCursor.close();
        }
    }

    @Override
    public boolean isClosed() {
        for (RecursiveNode<T> node : this.nodes) {
            if (node.childFuture != null) {
                return false;
            }
            RecordCursor childCursor = node.childCursor;
            if (childCursor == null || childCursor.isClosed()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.nodes.get((int)0).childCursor.getExecutor();
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        if (visitor.visitEnter(this)) {
            for (RecursiveNode<T> node : this.nodes) {
                RecordCursor childCursor = node.childCursor;
                if (childCursor == null) continue;
                childCursor.accept(visitor);
            }
        }
        return visitor.visitLeave(this);
    }

    @Nonnull
    CompletableFuture<Boolean> recursionLoop() {
        int depth = this.currentDepth;
        RecursiveNode<T> node = this.nodes.get(depth);
        if (node.childFuture == null) {
            if (node.childCursor == null) {
                node.childCursor = this.childCursorFunction.apply(node.value, depth, node.childContinuationBefore.toBytes());
            }
            node.childFuture = node.childCursor.onNext();
        }
        if (!node.childFuture.isDone()) {
            return node.childFuture.thenApply(rignore -> true);
        }
        RecordCursorResult childResult = node.childFuture.join();
        node.childFuture = null;
        if (childResult.hasNext()) {
            node.childContinuationAfter = childResult.getContinuation();
            this.addChildNode(childResult.get());
            if (node.emitPending) {
                this.lastResult = RecordCursorResult.withNextValue(new RecursiveValue(node.value, depth, false), this.buildContinuation(depth + 1));
                node.emitPending = false;
                return AsyncUtil.READY_FALSE;
            }
        } else {
            RecordCursor.NoNextReason noNextReason = childResult.getNoNextReason();
            if (noNextReason.isOutOfBand()) {
                RecordCursorContinuation continuation = node.emitPending ? this.buildContinuation(depth - 1) : this.buildContinuation(depth);
                this.lastResult = RecordCursorResult.withoutNextValue(continuation, noNextReason);
                return AsyncUtil.READY_FALSE;
            }
            while (this.nodes.size() > depth) {
                this.nodes.remove(depth);
            }
            this.currentDepth = depth - 1;
            if (depth == 0) {
                this.lastResult = RecordCursorResult.exhausted();
                return AsyncUtil.READY_FALSE;
            }
            RecursiveNode<T> parentNode = this.nodes.get(depth - 1);
            parentNode.childContinuationBefore = parentNode.childContinuationAfter;
            if (node.emitPending) {
                this.lastResult = RecordCursorResult.withNextValue(new RecursiveValue(node.value, depth, true), this.buildContinuation(depth));
                node.emitPending = false;
                return AsyncUtil.READY_FALSE;
            }
        }
        return AsyncUtil.READY_TRUE;
    }

    private void addChildNode(@Nullable T value) {
        ++this.currentDepth;
        if (this.currentDepth < this.nodes.size()) {
            byte[] actualCheckValue;
            RecursiveNode<T> continuationChildNode = this.nodes.get(this.currentDepth);
            boolean addNode = false;
            if (this.checkValueFunction != null && continuationChildNode.checkValue != null && (actualCheckValue = this.checkValueFunction.apply(value)) != null && !Arrays.equals(continuationChildNode.checkValue, actualCheckValue)) {
                while (this.nodes.size() > this.currentDepth) {
                    this.nodes.remove(this.currentDepth);
                }
                addNode = true;
            }
            if (!addNode) {
                this.nodes.set(this.currentDepth, continuationChildNode.withCheckedValue(value));
                return;
            }
        }
        RecursiveNode<T> childNode = RecursiveNode.forValue(value);
        this.nodes.add(childNode);
    }

    private RecordCursorContinuation buildContinuation(int depth) {
        ArrayList<RecordCursorContinuation> continuations = new ArrayList<RecordCursorContinuation>(depth);
        ArrayList<byte[]> checkValues = this.checkValueFunction == null ? null : new ArrayList<byte[]>(depth - 1);
        for (int i = 0; i < depth; ++i) {
            continuations.add(this.nodes.get((int)i).childContinuationBefore);
            if (checkValues == null || i >= depth - 1) continue;
            checkValues.add(this.checkValueFunction.apply(this.nodes.get((int)(i + 1)).value));
        }
        return new Continuation(continuations, checkValues);
    }

    @FunctionalInterface
    public static interface ChildCursorFunction<T> {
        public RecordCursor<T> apply(@Nullable T var1, int var2, @Nullable byte[] var3);
    }

    static final class RecursiveNode<T> {
        @Nullable
        final T value;
        @Nullable
        final byte[] checkValue;
        boolean emitPending;
        @Nonnull
        RecordCursorContinuation childContinuationBefore;
        @Nonnull
        RecordCursorContinuation childContinuationAfter;
        @Nullable
        RecordCursor<T> childCursor;
        @Nullable
        CompletableFuture<RecordCursorResult<T>> childFuture;

        private RecursiveNode(@Nullable T value, @Nullable byte[] checkValue, boolean emitPending, @Nonnull RecordCursorContinuation childContinuationBefore, @Nullable RecordCursor<T> childCursor) {
            this.value = value;
            this.checkValue = checkValue;
            this.emitPending = emitPending;
            this.childContinuationAfter = this.childContinuationBefore = childContinuationBefore;
            this.childCursor = childCursor;
        }

        static <T> RecursiveNode<T> forRoot(@Nonnull RecordCursorContinuation childContinuationBefore, @Nonnull RecordCursor<T> childCursor) {
            return new RecursiveNode<Object>(null, null, false, childContinuationBefore, childCursor);
        }

        static <T> RecursiveNode<T> forValue(@Nullable T value) {
            return new RecursiveNode<T>(value, null, true, RecordCursorStartContinuation.START, null);
        }

        public static <T> RecursiveNode<T> forContinuation(@Nonnull RecordCursorContinuation childContinuationBefore, @Nullable byte[] checkValue) {
            return new RecursiveNode<Object>(null, checkValue, false, childContinuationBefore, null);
        }

        public RecursiveNode<T> withCheckedValue(@Nullable T value) {
            return new RecursiveNode<T>(value, null, false, this.childContinuationBefore, null);
        }
    }

    public static class RecursiveValue<T> {
        @Nullable
        private final T value;
        private final int depth;
        private final boolean isLeaf;

        public RecursiveValue(@Nullable T value, int depth, boolean isLeaf) {
            this.value = value;
            this.depth = depth;
            this.isLeaf = isLeaf;
        }

        @Nullable
        public T getValue() {
            return this.value;
        }

        public int getDepth() {
            return this.depth;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }
    }

    private static final class Continuation
    implements RecordCursorContinuation {
        @Nonnull
        private final List<RecordCursorContinuation> continuations;
        @Nullable
        private final List<byte[]> checkValues;
        @Nullable
        private ByteString cachedByteString;
        @Nullable
        private byte[] cachedBytes;

        private Continuation(@Nonnull List<RecordCursorContinuation> continuations, @Nullable List<byte[]> checkValues) {
            this.continuations = continuations;
            this.checkValues = checkValues;
        }

        @Override
        public boolean isEnd() {
            for (RecordCursorContinuation continuation : this.continuations) {
                if (continuation.isEnd()) continue;
                return false;
            }
            return true;
        }

        @Override
        @Nonnull
        public ByteString toByteString() {
            if (this.cachedByteString == null) {
                RecordCursorProto.RecursiveContinuation.Builder builder = RecordCursorProto.RecursiveContinuation.newBuilder();
                for (int i = 0; i < this.continuations.size(); ++i) {
                    byte[] checkValue;
                    RecordCursorProto.RecursiveContinuation.LevelCursor.Builder levelBuilder = builder.addLevelsBuilder();
                    RecordCursorContinuation continuation = this.continuations.get(i);
                    if (continuation.toBytes() != null) {
                        levelBuilder.setContinuation(continuation.toByteString());
                    }
                    if (this.checkValues == null || i >= this.checkValues.size() || (checkValue = this.checkValues.get(i)) == null) continue;
                    levelBuilder.setCheckValue(ZeroCopyByteString.wrap(checkValue));
                }
                this.cachedByteString = builder.build().toByteString();
            }
            return this.cachedByteString;
        }

        @Override
        @Nullable
        public byte[] toBytes() {
            if (this.cachedBytes == null) {
                this.cachedBytes = this.toByteString().toByteArray();
            }
            return this.cachedBytes;
        }
    }
}

