/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.record.ByteArrayContinuation;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorStartContinuation;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.planprotos.PTempTable;
import com.apple.foundationdb.record.query.plan.cascades.TempTable;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RecursiveUnionCursor<T>
implements RecordCursor<T> {
    @Nonnull
    private RecordCursor<T> activeStateCursor;
    @Nonnull
    private final Executor executor;
    @Nonnull
    private final RecursiveStateManager<T> recursiveStateManager;

    public RecursiveUnionCursor(@Nonnull RecursiveStateManager<T> recursiveStateManager, @Nonnull Executor executor) {
        this.recursiveStateManager = recursiveStateManager;
        this.executor = executor;
        this.activeStateCursor = recursiveStateManager.getActiveStateCursor();
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<T>> onNext() {
        return this.activeStateCursor.onNext().thenCompose(cursorResult -> {
            if (!cursorResult.hasNext()) {
                if (cursorResult.getNoNextReason().isSourceExhausted()) {
                    this.recursiveStateManager.notifyCursorIsExhausted();
                    if (this.recursiveStateManager.canTransitionToNewStep()) {
                        this.activeStateCursor = this.recursiveStateManager.getActiveStateCursor();
                        return this.onNext();
                    }
                    return CompletableFuture.completedFuture(RecordCursorResult.exhausted());
                }
                return this.wrapLastResult((RecordCursorResult<T>)cursorResult);
            }
            return this.wrapNextResult((RecordCursorResult<T>)cursorResult);
        });
    }

    @Nonnull
    private CompletableFuture<RecordCursorResult<T>> wrapLastResult(@Nonnull RecordCursorResult<T> innerCursorResult) {
        return CompletableFuture.completedFuture(RecordCursorResult.withoutNextValue(new Continuation(this.recursiveStateManager.isInitialState(), innerCursorResult.getContinuation(), this.recursiveStateManager.getRecursiveUnionTempTable()), innerCursorResult.getNoNextReason()));
    }

    @Nonnull
    private CompletableFuture<RecordCursorResult<T>> wrapNextResult(@Nonnull RecordCursorResult<T> innerCursorResult) {
        Continuation continuation = new Continuation(this.recursiveStateManager.isInitialState(), innerCursorResult.getContinuation(), this.recursiveStateManager.getRecursiveUnionTempTable());
        return CompletableFuture.completedFuture(RecordCursorResult.withNextValue(innerCursorResult.get(), continuation));
    }

    @Override
    public void close() {
        this.activeStateCursor.close();
    }

    @Override
    public boolean isClosed() {
        return this.activeStateCursor.isClosed();
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        if (visitor.visitEnter(this)) {
            this.activeStateCursor.accept(visitor);
        }
        return visitor.visitLeave(this);
    }

    public static interface RecursiveStateManager<T> {
        public void notifyCursorIsExhausted();

        public boolean canTransitionToNewStep();

        @Nonnull
        public RecordCursor<T> getActiveStateCursor();

        @Nonnull
        public TempTable getRecursiveUnionTempTable();

        public boolean isInitialState();
    }

    public static final class Continuation
    implements RecordCursorContinuation {
        private final boolean isInitialState;
        @Nonnull
        private final RecordCursorContinuation activeStateContinuation;
        @Nonnull
        private final TempTable tempTable;

        Continuation(boolean isInitialState, @Nonnull RecordCursorContinuation activeStateContinuation, @Nonnull TempTable tempTable) {
            this.isInitialState = isInitialState;
            this.activeStateContinuation = activeStateContinuation;
            this.tempTable = tempTable;
        }

        @Override
        @Nullable
        public byte[] toBytes() {
            return this.toByteString().toByteArray();
        }

        @Override
        @Nonnull
        public ByteString toByteString() {
            return RecordCursorProto.RecursiveCursorContinuation.newBuilder().setIsInitialState(this.isInitialState()).setTempTable(this.getTempTable().toProto()).setActiveStateContinuation(this.getActiveStateContinuation().toByteString()).build().toByteString();
        }

        @Override
        public boolean isEnd() {
            return false;
        }

        @Nonnull
        public static Continuation from(@Nonnull RecordCursorProto.RecursiveCursorContinuation message, @Nonnull Function<PTempTable, TempTable> tempTableDeserializer) {
            PTempTable parsedTempTable;
            RecordCursorContinuation childContinuation = message.hasActiveStateContinuation() ? ByteArrayContinuation.fromNullable(message.getActiveStateContinuation().toByteArray()) : RecordCursorStartContinuation.START;
            try {
                parsedTempTable = PTempTable.parseFrom(message.getTempTable().toByteString());
            }
            catch (InvalidProtocolBufferException ex) {
                throw new RecordCoreException("invalid continuation", ex).addLogInfo(new Object[]{LogMessageKeys.RAW_BYTES, ByteArrayUtil2.loggable(message.toByteArray())});
            }
            return new Continuation(message.getIsInitialState(), childContinuation, tempTableDeserializer.apply(parsedTempTable));
        }

        @Nonnull
        public static Continuation from(@Nonnull byte[] unparsedContinuationBytes, @Nonnull Function<PTempTable, TempTable> tempTableDeserializer) {
            try {
                RecordCursorProto.RecursiveCursorContinuation parsed = RecordCursorProto.RecursiveCursorContinuation.parseFrom(unparsedContinuationBytes);
                return Continuation.from(parsed, tempTableDeserializer);
            }
            catch (InvalidProtocolBufferException ex) {
                throw new RecordCoreException("invalid continuation", ex).addLogInfo(new Object[]{LogMessageKeys.RAW_BYTES, ByteArrayUtil2.loggable(unparsedContinuationBytes)});
            }
        }

        public boolean isInitialState() {
            return this.isInitialState;
        }

        @Nonnull
        public RecordCursorContinuation getActiveStateContinuation() {
            return this.activeStateContinuation;
        }

        @Nonnull
        public TempTable getTempTable() {
            return this.tempTable;
        }
    }
}

