/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class RowLimitedCursor<T>
implements RecordCursor<T> {
    @Nonnull
    private final RecordCursor<T> inner;
    private final int limit;
    private int soFar;
    @Nullable
    protected RecordCursorResult<T> nextResult;

    public RowLimitedCursor(@Nonnull RecordCursor<T> inner, int limit) {
        this.inner = inner;
        this.limit = limit;
        this.soFar = 0;
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<T>> onNext() {
        if (this.nextResult != null && !this.nextResult.hasNext()) {
            return CompletableFuture.completedFuture(this.nextResult);
        }
        if (this.limitReached()) {
            this.inner.close();
            RecordCursor.NoNextReason reason = !this.nextResult.hasNext() && this.nextResult.getContinuation().isEnd() ? this.nextResult.getNoNextReason() : RecordCursor.NoNextReason.RETURN_LIMIT_REACHED;
            this.nextResult = RecordCursorResult.withoutNextValue(this.nextResult.getContinuation(), reason);
            return CompletableFuture.completedFuture(this.nextResult);
        }
        return this.inner.onNext().thenApply(result -> {
            ++this.soFar;
            this.nextResult = result;
            return result;
        });
    }

    protected boolean limitReached() {
        return this.soFar >= this.limit;
    }

    @Override
    public void close() {
        this.inner.close();
    }

    @Override
    public boolean isClosed() {
        return this.inner.isClosed();
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.inner.getExecutor();
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        if (visitor.visitEnter(this)) {
            this.inner.accept(visitor);
        }
        return visitor.visitLeave(this);
    }
}

