/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class SkipCursor<T>
implements RecordCursor<T> {
    @Nonnull
    private final RecordCursor<T> inner;
    private int skipRemaining;
    @Nullable
    private RecordCursorResult<T> nextResult;

    public SkipCursor(@Nonnull RecordCursor<T> inner, int skip) {
        this.inner = inner;
        this.skipRemaining = skip;
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<T>> onNext() {
        if (this.nextResult != null && !this.nextResult.hasNext()) {
            return CompletableFuture.completedFuture(this.nextResult);
        }
        if (this.skipRemaining <= 0) {
            return this.inner.onNext().thenApply(result -> {
                this.nextResult = result;
                return result;
            });
        }
        return AsyncUtil.whileTrue(() -> this.inner.onNext().thenApply(innerResult -> {
            this.nextResult = innerResult;
            if (innerResult.hasNext() && this.skipRemaining > 0) {
                --this.skipRemaining;
                return true;
            }
            return false;
        }), this.getExecutor()).thenApply(vignore -> this.nextResult);
    }

    @Override
    public void close() {
        this.inner.close();
    }

    @Override
    public boolean isClosed() {
        return this.inner.isClosed();
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.inner.getExecutor();
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        if (visitor.visitEnter(this)) {
            this.inner.accept(visitor);
        }
        return visitor.visitLeave(this);
    }
}

