/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ByteArrayContinuation;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorStartContinuation;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.planprotos.PTempTable;
import com.apple.foundationdb.record.query.plan.cascades.TempTable;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class TempTableInsertCursor
implements RecordCursor<QueryResult> {
    @Nonnull
    private final RecordCursor<QueryResult> childCursor;
    @Nonnull
    private final TempTable tempTable;

    private TempTableInsertCursor(@Nonnull RecordCursor<QueryResult> childCursor, @Nonnull TempTable tempTable) {
        this.childCursor = childCursor;
        this.tempTable = tempTable;
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<QueryResult>> onNext() {
        return this.childCursor.onNext().thenApply(childCursorResult -> {
            if (!childCursorResult.hasNext()) {
                if (childCursorResult.getNoNextReason().isSourceExhausted()) {
                    return RecordCursorResult.exhausted();
                }
                return RecordCursorResult.withoutNextValue(new Continuation(this.tempTable, childCursorResult.getContinuation()), childCursorResult.getNoNextReason());
            }
            this.tempTable.add(Objects.requireNonNull((QueryResult)childCursorResult.get()));
            return RecordCursorResult.withNextValue((QueryResult)childCursorResult.get(), new Continuation(this.tempTable, childCursorResult.getContinuation()));
        });
    }

    @Override
    public void close() {
        this.childCursor.close();
    }

    @Override
    public boolean isClosed() {
        return this.childCursor.isClosed();
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.childCursor.getExecutor();
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        if (visitor.visitEnter(this)) {
            this.childCursor.accept(visitor);
        }
        return visitor.visitLeave(this);
    }

    @Nonnull
    public static TempTableInsertCursor from(@Nullable byte[] unparsed, @Nonnull Function<PTempTable, TempTable> tempTableDeserializer, @Nonnull Function<byte[], RecordCursor<QueryResult>> childCursorCreator) {
        Continuation continuation = Continuation.from(unparsed, tempTableDeserializer);
        RecordCursor<QueryResult> childCursor = childCursorCreator.apply(continuation.getChildContinuation().toBytes());
        return new TempTableInsertCursor(childCursor, continuation.getTempTable());
    }

    private static class Continuation
    implements RecordCursorContinuation {
        @Nonnull
        private final TempTable tempTable;
        @Nonnull
        private final RecordCursorContinuation childContinuation;

        private Continuation(@Nonnull TempTable tempTable, @Nonnull RecordCursorContinuation childContinuation) {
            this.tempTable = tempTable;
            this.childContinuation = childContinuation;
        }

        @Nonnull
        public RecordCursorContinuation getChildContinuation() {
            return this.childContinuation;
        }

        @Nonnull
        public TempTable getTempTable() {
            return this.tempTable;
        }

        @Nonnull
        private RecordCursorProto.TempTableInsertContinuation toProto() {
            RecordCursorProto.TempTableInsertContinuation.Builder builder = RecordCursorProto.TempTableInsertContinuation.newBuilder();
            builder.setTempTable(this.tempTable.toProto());
            ByteString childBytes = this.childContinuation.toByteString();
            if (!childBytes.isEmpty()) {
                builder.setChildContinuation(childBytes);
            }
            return builder.build();
        }

        @Override
        @Nonnull
        public ByteString toByteString() {
            return this.toProto().toByteString();
        }

        @Override
        @Nullable
        public byte[] toBytes() {
            if (this.isEnd()) {
                return null;
            }
            return this.toByteString().toByteArray();
        }

        @Override
        public boolean isEnd() {
            return this.childContinuation.isEnd();
        }

        @Nonnull
        private static Continuation from(@Nonnull RecordCursorProto.TempTableInsertContinuation parsed, @Nullable PTempTable parsedTempTable, @Nonnull Function<PTempTable, TempTable> tempTableDeserializer) {
            TempTable tempTable = tempTableDeserializer.apply(parsedTempTable);
            RecordCursorContinuation childContinuation = parsed.hasChildContinuation() ? ByteArrayContinuation.fromNullable(parsed.getChildContinuation().toByteArray()) : RecordCursorStartContinuation.START;
            return new Continuation(tempTable, childContinuation);
        }

        @Nonnull
        private static Continuation from(@Nullable byte[] unparsed, @Nonnull Function<PTempTable, TempTable> tempTableDeserializer) {
            if (unparsed == null) {
                return new Continuation(tempTableDeserializer.apply(null), RecordCursorStartContinuation.START);
            }
            try {
                RecordCursorProto.TempTableInsertContinuation parsed = RecordCursorProto.TempTableInsertContinuation.parseFrom(unparsed);
                PTempTable parsedTempTable = parsed.hasTempTable() ? PTempTable.parseFrom(parsed.getTempTable().toByteString()) : null;
                return Continuation.from(parsed, parsedTempTable, tempTableDeserializer);
            }
            catch (InvalidProtocolBufferException ex) {
                throw new RecordCoreException("invalid continuation", ex).addLogInfo(new Object[]{LogMessageKeys.RAW_BYTES, ByteArrayUtil2.loggable(unparsed)});
            }
        }
    }
}

