/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors.aggregate;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.ByteArrayContinuation;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.record.cursors.aggregate.StreamGrouping;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryStreamingAggregationPlan;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.common.base.Verify;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class AggregateCursor<M extends Message>
implements RecordCursor<QueryResult> {
    @Nonnull
    private final RecordCursor<QueryResult> inner;
    @Nonnull
    private final StreamGrouping<M> streamGrouping;
    @Nullable
    private RecordCursorResult<QueryResult> previousResult;
    @Nullable
    private RecordCursorResult<QueryResult> previousValidResult;
    @Nonnull
    private RecordCursorContinuation previousContinuationInGroup;
    @Nullable
    private RecordCursorProto.PartialAggregationResult partialAggregationResult;
    @Nonnull
    private final RecordQueryStreamingAggregationPlan.SerializationMode serializationMode;

    public AggregateCursor(@Nonnull RecordCursor<QueryResult> inner, @Nonnull StreamGrouping<M> streamGrouping, @Nonnull RecordCursorContinuation continuation, @Nonnull RecordQueryStreamingAggregationPlan.SerializationMode serializationMode) {
        this.inner = inner;
        this.streamGrouping = streamGrouping;
        this.serializationMode = serializationMode;
        this.previousContinuationInGroup = continuation;
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<QueryResult>> onNext() {
        if (this.previousResult != null && !this.previousResult.hasNext()) {
            return CompletableFuture.completedFuture(RecordCursorResult.withoutNextValue(new AggregateCursorContinuation(this.previousResult.getContinuation(), this.streamGrouping.getPartialAggregationResult(), this.serializationMode), this.previousResult.getNoNextReason()));
        }
        return AsyncUtil.whileTrue(() -> this.inner.onNext().thenApply(innerResult -> {
            this.previousResult = innerResult;
            if (!innerResult.hasNext()) {
                if (!this.isNoRecords()) {
                    this.partialAggregationResult = this.streamGrouping.finalizeGroup();
                }
                return false;
            }
            QueryResult queryResult = Objects.requireNonNull((QueryResult)innerResult.get());
            boolean groupBreak = this.streamGrouping.apply(queryResult);
            if (!groupBreak) {
                this.previousValidResult = innerResult;
                this.previousContinuationInGroup = this.previousValidResult.getContinuation();
            }
            return !groupBreak;
        }), this.getExecutor()).thenApply(vignore -> {
            if (Verify.verifyNotNull(this.previousResult).hasNext()) {
                AggregateCursorContinuation c = new AggregateCursorContinuation(this.previousContinuationInGroup, this.serializationMode);
                this.previousValidResult = this.previousResult;
                this.previousContinuationInGroup = Verify.verifyNotNull(this.previousValidResult).getContinuation();
                return RecordCursorResult.withNextValue(QueryResult.ofComputed(this.streamGrouping.getCompletedGroupResult()), c);
            }
            if (Verify.verifyNotNull(this.previousResult).getNoNextReason() == RecordCursor.NoNextReason.SOURCE_EXHAUSTED) {
                if (this.previousValidResult == null && this.partialAggregationResult == null) {
                    return RecordCursorResult.exhausted();
                }
                AggregateCursorContinuation c = new AggregateCursorContinuation(this.previousContinuationInGroup, this.serializationMode);
                this.previousValidResult = this.previousResult;
                this.previousContinuationInGroup = Verify.verifyNotNull(this.previousValidResult).getContinuation();
                return RecordCursorResult.withNextValue(QueryResult.ofComputed(this.streamGrouping.getCompletedGroupResult()), c);
            }
            AggregateCursorContinuation currentContinuation = new AggregateCursorContinuation(Verify.verifyNotNull(this.previousResult).getContinuation(), this.partialAggregationResult, this.serializationMode);
            this.previousValidResult = this.previousResult;
            this.previousContinuationInGroup = Verify.verifyNotNull(this.previousValidResult).getContinuation();
            if (this.serializationMode == RecordQueryStreamingAggregationPlan.SerializationMode.TO_NEW) {
                return RecordCursorResult.withoutNextValue(currentContinuation, Verify.verifyNotNull(this.previousResult).getNoNextReason());
            }
            return RecordCursorResult.withNextValue(QueryResult.ofComputed(this.streamGrouping.getCompletedGroupResult()), currentContinuation);
        });
    }

    private boolean isNoRecords() {
        return this.previousValidResult == null && !Verify.verifyNotNull(this.previousResult).hasNext() && this.streamGrouping.getPartialAggregationResult() == null;
    }

    @Override
    public void close() {
        this.inner.close();
    }

    @Override
    public boolean isClosed() {
        return this.inner.isClosed();
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.inner.getExecutor();
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        if (visitor.visitEnter(this)) {
            this.inner.accept(visitor);
        }
        return visitor.visitLeave(this);
    }

    public static class AggregateCursorContinuation
    implements RecordCursorContinuation {
        @Nonnull
        private final RecordCursorContinuation innerContinuation;
        @Nullable
        private final RecordCursorProto.PartialAggregationResult partialAggregationResult;
        @Nullable
        private RecordCursorProto.AggregateCursorContinuation cachedProto;
        private final RecordQueryStreamingAggregationPlan.SerializationMode serializationMode;

        public AggregateCursorContinuation(@Nonnull RecordCursorContinuation innerContinuation, @Nullable RecordCursorProto.PartialAggregationResult partialAggregationResult, RecordQueryStreamingAggregationPlan.SerializationMode serializationMode) {
            this.innerContinuation = innerContinuation;
            this.partialAggregationResult = partialAggregationResult;
            this.serializationMode = serializationMode;
        }

        public AggregateCursorContinuation(@Nonnull RecordCursorContinuation other, RecordQueryStreamingAggregationPlan.SerializationMode serializationMode) {
            this(other, null, serializationMode);
        }

        @Override
        @Nonnull
        public ByteString toByteString() {
            if (this.serializationMode == RecordQueryStreamingAggregationPlan.SerializationMode.TO_OLD) {
                return this.innerContinuation.toByteString();
            }
            return this.isEnd() ? ByteString.EMPTY : this.toProto().toByteString();
        }

        @Override
        @Nullable
        public byte[] toBytes() {
            ByteString byteString = this.toByteString();
            return byteString.isEmpty() ? null : byteString.toByteArray();
        }

        @Override
        public boolean isEnd() {
            return this.innerContinuation.isEnd();
        }

        @Nullable
        public byte[] getInnerContinuation() {
            return this.innerContinuation.toBytes();
        }

        @Nullable
        public RecordCursorProto.PartialAggregationResult getPartialAggregationResult() {
            return this.partialAggregationResult;
        }

        @Nonnull
        private RecordCursorProto.AggregateCursorContinuation toProto() {
            if (this.cachedProto == null) {
                RecordCursorProto.AggregateCursorContinuation.Builder cachedProtoBuilder = RecordCursorProto.AggregateCursorContinuation.newBuilder().setContinuation(this.innerContinuation.toByteString());
                if (this.partialAggregationResult != null) {
                    cachedProtoBuilder.setPartialAggregationResults(this.partialAggregationResult);
                }
                this.cachedProto = cachedProtoBuilder.build();
            }
            return this.cachedProto;
        }

        public static AggregateCursorContinuation fromRawBytes(@Nonnull byte[] rawBytes, RecordQueryStreamingAggregationPlan.SerializationMode serializationMode) {
            if (serializationMode == RecordQueryStreamingAggregationPlan.SerializationMode.TO_OLD) {
                return new AggregateCursorContinuation(ByteArrayContinuation.fromNullable(rawBytes), serializationMode);
            }
            try {
                RecordCursorProto.AggregateCursorContinuation continuationProto = RecordCursorProto.AggregateCursorContinuation.parseFrom(rawBytes);
                return new AggregateCursorContinuation(ByteArrayContinuation.fromNullable(continuationProto.getContinuation().toByteArray()), continuationProto.hasPartialAggregationResults() ? continuationProto.getPartialAggregationResults() : null, serializationMode);
            }
            catch (InvalidProtocolBufferException ipbe) {
                throw new RecordCoreException("error parsing continuation", ipbe).addLogInfo("raw_bytes", (Object)ByteArrayUtil2.loggable(rawBytes));
            }
        }
    }
}

