/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors.aggregate;

import com.apple.foundationdb.record.cursors.aggregate.AccumulatorState;
import com.apple.foundationdb.record.cursors.aggregate.DoubleState;
import com.apple.foundationdb.record.cursors.aggregate.FloatState;
import com.apple.foundationdb.record.cursors.aggregate.IntegerState;
import com.apple.foundationdb.record.cursors.aggregate.LongState;
import com.apple.foundationdb.record.cursors.aggregate.PrimitiveAccumulatorOperation;
import javax.annotation.Nullable;

public class AverageAccumulatorState<T extends Number>
implements AccumulatorState<T, Double> {
    private AccumulatorState<T, T> total;
    private long count;

    public static AverageAccumulatorState<Integer> intAverageState() {
        return new AverageAccumulatorState<Integer>(new IntegerState(PrimitiveAccumulatorOperation.SUM));
    }

    public static AverageAccumulatorState<Long> longAverageState() {
        return new AverageAccumulatorState<Long>(new LongState(PrimitiveAccumulatorOperation.SUM));
    }

    public static AverageAccumulatorState<Float> floatAverageState() {
        return new AverageAccumulatorState<Float>(new FloatState(PrimitiveAccumulatorOperation.SUM));
    }

    public static AverageAccumulatorState<Double> doubleAverageState() {
        return new AverageAccumulatorState<Double>(new DoubleState(PrimitiveAccumulatorOperation.SUM));
    }

    private AverageAccumulatorState(AccumulatorState<T, T> total) {
        this.total = total;
    }

    @Override
    public void accumulate(@Nullable T value) {
        if (value != null) {
            this.total.accumulate(value);
            ++this.count;
        }
    }

    @Override
    @Nullable
    public Double finish() {
        if (this.count == 0L) {
            return null;
        }
        return ((Number)this.total.finish()).doubleValue() / (double)this.count;
    }
}

