/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors.aggregate;

import com.apple.foundationdb.record.cursors.aggregate.AccumulatorState;
import com.apple.foundationdb.record.cursors.aggregate.PrimitiveAccumulatorOperation;
import javax.annotation.Nullable;

public class DoubleState
implements AccumulatorState<Double, Double> {
    private double currentState;
    private boolean hasValue = false;
    private final PrimitiveAccumulatorOperation operation;

    public DoubleState(PrimitiveAccumulatorOperation operation) {
        this.operation = operation;
        this.resetState(operation);
    }

    @Override
    public void accumulate(@Nullable Double value) {
        if (value != null) {
            switch (this.operation) {
                case SUM: {
                    this.currentState += value.doubleValue();
                    break;
                }
                case MIN: {
                    this.currentState = Math.min(this.currentState, value);
                    break;
                }
                case MAX: {
                    this.currentState = Math.max(this.currentState, value);
                    break;
                }
            }
            this.hasValue = true;
        }
    }

    @Override
    @Nullable
    public Double finish() {
        if (this.hasValue) {
            return this.currentState;
        }
        return null;
    }

    private void resetState(PrimitiveAccumulatorOperation operation) {
        switch (operation) {
            case SUM: {
                this.currentState = 0.0;
                break;
            }
            case MIN: {
                this.currentState = Double.MAX_VALUE;
                break;
            }
            case MAX: {
                this.currentState = Double.MIN_VALUE;
                break;
            }
        }
    }
}

