/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors.aggregate;

import com.apple.foundationdb.record.cursors.aggregate.AccumulatorState;
import com.apple.foundationdb.record.cursors.aggregate.PrimitiveAccumulatorOperation;
import javax.annotation.Nullable;

public class FloatState
implements AccumulatorState<Float, Float> {
    private float currentState;
    private boolean hasValue = false;
    private final PrimitiveAccumulatorOperation operation;

    public FloatState(PrimitiveAccumulatorOperation operation) {
        this.operation = operation;
        this.resetState(operation);
    }

    @Override
    public void accumulate(@Nullable Float value) {
        if (value != null) {
            switch (this.operation) {
                case SUM: {
                    this.currentState += value.floatValue();
                    break;
                }
                case MIN: {
                    this.currentState = Math.min(this.currentState, value.floatValue());
                    break;
                }
                case MAX: {
                    this.currentState = Math.max(this.currentState, value.floatValue());
                    break;
                }
            }
            this.hasValue = true;
        }
    }

    @Override
    @Nullable
    public Float finish() {
        if (this.hasValue) {
            return Float.valueOf(this.currentState);
        }
        return null;
    }

    private void resetState(PrimitiveAccumulatorOperation operation) {
        switch (operation) {
            case SUM: {
                this.currentState = 0.0f;
                break;
            }
            case MIN: {
                this.currentState = Float.MAX_VALUE;
                break;
            }
            case MAX: {
                this.currentState = Float.MIN_VALUE;
                break;
            }
        }
    }
}

