/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors.aggregate;

import com.apple.foundationdb.record.cursors.aggregate.AccumulatorState;
import com.apple.foundationdb.record.cursors.aggregate.PrimitiveAccumulatorOperation;
import javax.annotation.Nullable;

public class LongState
implements AccumulatorState<Long, Long> {
    private long currentState;
    private boolean hasValue = false;
    private final PrimitiveAccumulatorOperation operation;

    public LongState(PrimitiveAccumulatorOperation operation) {
        this.operation = operation;
        this.resetState(operation);
    }

    @Override
    public void accumulate(@Nullable Long value) {
        if (value != null) {
            switch (this.operation) {
                case SUM: {
                    this.currentState = Math.addExact(this.currentState, value);
                    break;
                }
                case MIN: {
                    this.currentState = Math.min(this.currentState, value);
                    break;
                }
                case MAX: {
                    this.currentState = Math.max(this.currentState, value);
                    break;
                }
            }
            this.hasValue = true;
        }
    }

    @Override
    @Nullable
    public Long finish() {
        if (this.hasValue) {
            return this.currentState;
        }
        return null;
    }

    private void resetState(PrimitiveAccumulatorOperation operation) {
        switch (operation) {
            case SUM: {
                this.currentState = 0L;
                break;
            }
            case MIN: {
                this.currentState = Long.MAX_VALUE;
                break;
            }
            case MAX: {
                this.currentState = Long.MIN_VALUE;
                break;
            }
        }
    }
}

