/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.cursors.aggregate;

import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.values.Accumulator;
import com.apple.foundationdb.record.query.plan.cascades.values.AggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StreamGrouping<M extends Message> {
    @Nullable
    private final Value groupingKeyValue;
    @Nonnull
    private final AggregateValue aggregateValue;
    @Nonnull
    private final FDBRecordStoreBase<M> store;
    @Nonnull
    private final EvaluationContext context;
    @Nonnull
    private final CorrelationIdentifier alias;
    @Nonnull
    private Accumulator accumulator;
    @Nullable
    private Object currentGroup;
    @Nullable
    private Object previousCompleteResult;
    @Nonnull
    private final CorrelationIdentifier groupingKeyAlias;
    @Nonnull
    private final CorrelationIdentifier aggregateAlias;
    @Nonnull
    private final Value completeResultValue;

    public StreamGrouping(@Nullable Value groupingKeyValue, @Nonnull AggregateValue aggregateValue, @Nonnull Value completeResultValue, @Nonnull CorrelationIdentifier groupingKeyAlias, @Nonnull CorrelationIdentifier aggregateAlias, @Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nonnull CorrelationIdentifier alias, @Nullable RecordCursorProto.PartialAggregationResult partialAggregationResult) {
        this.groupingKeyValue = groupingKeyValue;
        this.aggregateValue = aggregateValue;
        if (partialAggregationResult == null) {
            this.accumulator = aggregateValue.createAccumulatorWithInitialState(context.getTypeRepository(), null);
        } else {
            this.accumulator = aggregateValue.createAccumulatorWithInitialState(context.getTypeRepository(), partialAggregationResult.getAccumulatorStatesList());
            try {
                this.currentGroup = DynamicMessage.parseFrom(context.getTypeRepository().newMessageBuilder(groupingKeyValue.getResultType()).getDescriptorForType(), partialAggregationResult.getGroupKey().toByteArray());
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }
        this.store = store;
        this.context = context;
        this.alias = alias;
        this.groupingKeyAlias = groupingKeyAlias;
        this.aggregateAlias = aggregateAlias;
        this.completeResultValue = completeResultValue;
    }

    public boolean apply(@Nullable Object currentObject) {
        boolean groupBreak;
        if (this.groupingKeyValue != null) {
            Object nextGroup = this.evalGroupingKey(currentObject);
            groupBreak = this.isGroupBreak(this.currentGroup, nextGroup);
            if (groupBreak) {
                this.finalizeGroup(nextGroup);
            } else {
                this.currentGroup = nextGroup;
            }
        } else {
            groupBreak = false;
            this.currentGroup = null;
        }
        this.accumulate(currentObject);
        return groupBreak;
    }

    @Nullable
    public Object getCompletedGroupResult() {
        return this.previousCompleteResult;
    }

    private boolean isGroupBreak(Object currentGroup, Object nextGroup) {
        if (currentGroup == null) {
            return false;
        }
        return !currentGroup.equals(nextGroup);
    }

    public RecordCursorProto.PartialAggregationResult finalizeGroup() {
        return this.finalizeGroup(null);
    }

    private RecordCursorProto.PartialAggregationResult finalizeGroup(Object nextGroup) {
        EvaluationContext nestedContext = this.context.childBuilder().setBinding(this.groupingKeyAlias, this.currentGroup).setBinding(this.aggregateAlias, this.accumulator.finish()).build(this.context.getTypeRepository());
        this.previousCompleteResult = this.completeResultValue.eval(this.store, nestedContext);
        RecordCursorProto.PartialAggregationResult result = this.getPartialAggregationResult();
        this.currentGroup = nextGroup;
        this.accumulator = this.aggregateValue.createAccumulatorWithInitialState(this.context.getTypeRepository(), null);
        return result;
    }

    private void accumulate(@Nullable Object currentObject) {
        EvaluationContext nestedContext = this.context.withBinding(Bindings.Internal.CORRELATION, this.alias, currentObject);
        Object partial = this.aggregateValue.evalToPartial(this.store, nestedContext);
        this.accumulator.accumulate(partial);
    }

    private Object evalGroupingKey(@Nullable Object currentObject) {
        EvaluationContext nestedContext = this.context.withBinding(Bindings.Internal.CORRELATION, this.alias, currentObject);
        return Objects.requireNonNull(this.groupingKeyValue).eval(this.store, nestedContext);
    }

    @Nullable
    public RecordCursorProto.PartialAggregationResult getPartialAggregationResult() {
        if (this.currentGroup == null) {
            return null;
        }
        List<RecordCursorProto.AccumulatorState> accumulatorStates = this.accumulator.getAccumulatorStates();
        if (accumulatorStates.isEmpty()) {
            return null;
        }
        return RecordCursorProto.PartialAggregationResult.newBuilder().setGroupKey(Objects.requireNonNull((Message)this.currentGroup).toByteString()).addAllAccumulatorStates(accumulatorStates).build();
    }
}

