/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.locking;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class AsyncLock {
    @Nonnull
    private final CompletableFuture<Void> pendingReads;
    @Nonnull
    private final CompletableFuture<Void> pendingWrites;
    @Nonnull
    private final CompletableFuture<Void> taskFuture;
    @Nonnull
    private final CompletableFuture<Void> waitFuture;
    @Nullable
    private final StoreTimer timer;

    AsyncLock(@Nullable StoreTimer timer, @Nonnull CompletableFuture<Void> pendingReads, @Nonnull CompletableFuture<Void> pendingWrites, @Nonnull CompletableFuture<Void> taskFuture, @Nonnull CompletableFuture<Void> waitFuture) {
        this.timer = timer;
        this.pendingReads = pendingReads;
        this.pendingWrites = pendingWrites;
        this.taskFuture = taskFuture;
        this.waitFuture = waitFuture;
        if (timer != null) {
            timer.increment(FDBStoreTimer.Counts.LOCKS_ATTEMPTED);
        }
    }

    AsyncLock withNewRead() {
        CompletableFuture<Void> waitFuture = this.pendingWrites;
        CompletableFuture<Void> taskFuture = new CompletableFuture<Void>();
        CompletableFuture<Void> newPendingReads = CompletableFuture.allOf(new CompletableFuture[]{this.pendingReads, waitFuture.thenCompose(ignore -> taskFuture)});
        return new AsyncLock(this.timer, newPendingReads, this.pendingWrites, taskFuture, waitFuture);
    }

    AsyncLock withNewWrite() {
        CompletableFuture<Void> waitFuture = CompletableFuture.allOf(this.pendingReads, this.pendingWrites);
        CompletableFuture<Void> taskFuture = new CompletableFuture<Void>();
        CompletionStage newPendingWrites = waitFuture.thenCompose(ignore -> taskFuture);
        return new AsyncLock(this.timer, AsyncUtil.DONE, (CompletableFuture<Void>)newPendingWrites, taskFuture, waitFuture);
    }

    CompletableFuture<Void> onAcquired() {
        return this.waitFuture;
    }

    public boolean isLockReleased() {
        return this.taskFuture.isDone();
    }

    public void release() {
        if (!this.taskFuture.isDone()) {
            this.taskFuture.complete(null);
            if (this.timer != null) {
                this.timer.increment(FDBStoreTimer.Counts.LOCKS_RELEASED);
            }
        }
    }
}

