/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.locking;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.locking.AsyncLock;
import com.apple.foundationdb.record.locking.LockIdentifier;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class LockRegistry {
    @Nonnull
    private final Map<LockIdentifier, AtomicReference<AsyncLock>> heldLocks = new ConcurrentHashMap<LockIdentifier, AtomicReference<AsyncLock>>();
    @Nullable
    private final StoreTimer timer;

    public LockRegistry(@Nullable StoreTimer timer) {
        this.timer = timer;
    }

    public CompletableFuture<AsyncLock> acquireReadLock(@Nonnull LockIdentifier id) {
        return this.acquire(id, AsyncLock::withNewRead);
    }

    public CompletableFuture<AsyncLock> acquireWriteLock(@Nonnull LockIdentifier id) {
        return this.acquire(id, AsyncLock::withNewWrite);
    }

    private CompletableFuture<AsyncLock> acquire(@Nonnull LockIdentifier id, @Nonnull UnaryOperator<AsyncLock> getNewLock) {
        AsyncLock lock = this.updateRefAndGetNewLock(id, getNewLock);
        if (this.timer != null) {
            this.timer.instrument((StoreTimer.Event)FDBStoreTimer.DetailEvents.LOCKS_ACQUIRED, lock.onAcquired()).thenApply(ignore -> lock);
        }
        return lock.onAcquired().thenApply(ignore -> lock);
    }

    public <T> CompletableFuture<T> doWithReadLock(@Nonnull LockIdentifier id, @Nonnull Supplier<CompletableFuture<T>> operation) {
        return this.doOp(id, operation, AsyncLock::withNewRead);
    }

    public <T> CompletableFuture<T> doWithWriteLock(@Nonnull LockIdentifier id, @Nonnull Supplier<CompletableFuture<T>> operation) {
        return this.doOp(id, operation, AsyncLock::withNewWrite);
    }

    private <T> CompletableFuture<T> doOp(@Nonnull LockIdentifier id, @Nonnull Supplier<CompletableFuture<T>> operation, @Nonnull UnaryOperator<AsyncLock> getNewLock) {
        AtomicReference lockRef = new AtomicReference();
        return ((CompletableFuture)this.acquire(id, getNewLock).thenCompose(lock -> {
            lockRef.set(lock);
            return (CompletionStage)operation.get();
        })).whenComplete((ignore, err) -> ((AsyncLock)lockRef.get()).release());
    }

    private AsyncLock updateRefAndGetNewLock(@Nonnull LockIdentifier identifier, @Nonnull UnaryOperator<AsyncLock> getNewLock) {
        long startTime = System.nanoTime();
        AtomicReference parentLockRef = this.heldLocks.computeIfAbsent(identifier, ignore -> new AtomicReference<AsyncLock>(new AsyncLock(this.timer, AsyncUtil.DONE, AsyncUtil.DONE, AsyncUtil.DONE, AsyncUtil.DONE)));
        AsyncLock newLock = parentLockRef.updateAndGet(getNewLock);
        if (this.timer != null) {
            this.timer.record(FDBStoreTimer.DetailEvents.LOCKS_REGISTERED, System.nanoTime() - startTime);
        }
        return newLock;
    }
}

