/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.logging;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;

@API(value=API.Status.UNSTABLE)
public class CompletionExceptionLogHelper {
    private static boolean addSuppressed = true;
    private static int maxSuppressedCount = Integer.MAX_VALUE;

    private CompletionExceptionLogHelper() {
    }

    public static void setAddSuppressed(boolean addSuppressed) {
        CompletionExceptionLogHelper.addSuppressed = addSuppressed;
    }

    public static synchronized boolean setMaxSuppressedCountIfNotSet(int count) {
        if (count < 0) {
            throw new RecordCoreArgumentException("tried to set max suppressed count to a negative value", new Object[0]);
        }
        if (maxSuppressedCount == Integer.MAX_VALUE && count != Integer.MAX_VALUE) {
            maxSuppressedCount = count;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    @API(value=API.Status.INTERNAL)
    public static synchronized void forceSetMaxSuppressedCountForTesting(int count) {
        if (count < 0) {
            throw new RecordCoreArgumentException("tried to set max suppressed count to a negative value", new Object[0]);
        }
        maxSuppressedCount = count;
    }

    public static Throwable asCause(@Nonnull CompletionException ex) {
        return CompletionExceptionLogHelper.asCauseThrowable(ex);
    }

    public static Throwable asCause(@Nonnull ExecutionException ex) {
        return CompletionExceptionLogHelper.asCauseThrowable(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Throwable asCauseThrowable(@Nonnull Throwable ex) {
        Throwable cause = ex.getCause();
        if (cause == null) {
            return ex;
        }
        if (addSuppressed) {
            Throwable throwable = cause;
            synchronized (throwable) {
                Throwable[] suppressedExceptions = cause.getSuppressed();
                if (suppressedExceptions.length < maxSuppressedCount) {
                    cause.addSuppressed(ex);
                } else {
                    IgnoredSuppressedExceptionCount suppressedCount;
                    int lastIndex = suppressedExceptions.length - 1;
                    if (lastIndex >= 0 && suppressedExceptions[lastIndex] instanceof IgnoredSuppressedExceptionCount) {
                        suppressedCount = (IgnoredSuppressedExceptionCount)suppressedExceptions[lastIndex];
                    } else {
                        suppressedCount = new IgnoredSuppressedExceptionCount();
                        cause.addSuppressed(suppressedCount);
                    }
                    suppressedCount.incrementCount();
                }
            }
        }
        return cause;
    }

    public static class IgnoredSuppressedExceptionCount
    extends Exception {
        private static final long serialVersionUID = 1L;
        private int count;

        private IgnoredSuppressedExceptionCount() {
            super("", null, true, false);
        }

        public synchronized void incrementCount() {
            ++this.count;
        }

        @Override
        public String getMessage() {
            return "Ignoring " + this.count + " suppressed exceptions.";
        }

        public int getCount() {
            return this.count;
        }
    }
}

