/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.logging;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class KeyValueLogMessage {
    @Nonnull
    private final long timestamp;
    @Nonnull
    private final String staticMessage;
    @Nonnull
    private final Map<String, String> keyValueMap;

    public static String of(@Nonnull String staticMessage, Object ... keysAndValues) {
        return new KeyValueLogMessage(staticMessage, KeyValueLogMessage.mapFromKeysAndValues(keysAndValues)).toString();
    }

    public static KeyValueLogMessage build(@Nonnull String staticMessage, Object ... keysAndValues) {
        return new KeyValueLogMessage(staticMessage, KeyValueLogMessage.mapFromKeysAndValues(keysAndValues));
    }

    private static Map<String, String> mapFromKeysAndValues(@Nullable Object[] keysAndValues) {
        TreeMap<String, String> keyValueMap = new TreeMap<String, String>();
        if (keysAndValues != null) {
            for (int i = 0; i < keysAndValues.length / 2 * 2; i += 2) {
                KeyValueLogMessage.addKeyValueImpl(keyValueMap, keysAndValues[i], keysAndValues[i + 1]);
            }
            if (keysAndValues.length % 2 == 1) {
                throw new IllegalArgumentException("keys and values don't match");
            }
        }
        return keyValueMap;
    }

    private KeyValueLogMessage(@Nonnull String staticMessage, @Nonnull Map<String, String> keyValueMap) {
        this.staticMessage = staticMessage;
        this.timestamp = System.currentTimeMillis();
        this.keyValueMap = keyValueMap;
    }

    private static void addKeyValueImpl(@Nonnull Map<String, String> keyValueMap, @Nullable Object key, @Nullable Object value) {
        if (key == null) {
            throw new IllegalArgumentException("null key passed to KeyValueLogMessage");
        }
        keyValueMap.put(KeyValueLogMessage.sanitizeKey(key.toString()), KeyValueLogMessage.sanitizeValue(Optional.ofNullable(value).orElse("null").toString()));
    }

    private void addKeyValueImpl(@Nullable Object key, @Nullable Object value) {
        KeyValueLogMessage.addKeyValueImpl(this.keyValueMap, key, value);
    }

    public KeyValueLogMessage addKeysAndValues(@Nonnull Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.addKeyValueImpl(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public KeyValueLogMessage addKeysAndValues(@Nonnull List<Object> keyValues) {
        for (int u = 0; u < keyValues.size() / 2 * 2; u += 2) {
            this.addKeyValueImpl(keyValues.get(u), keyValues.get(u + 1));
        }
        return this;
    }

    @Nonnull
    private static String sanitizeValue(@Nonnull String value) {
        return value.replace("\"", "'");
    }

    @Nonnull
    private static String sanitizeKey(@Nonnull String key) {
        return key.replace("=", "");
    }

    public String toString() {
        return this.getMessageWithKeys();
    }

    @Nonnull
    public String getMessageWithKeys() {
        StringBuilder sb = new StringBuilder(this.keyValueMap.size() * 30);
        sb.append(this.staticMessage);
        for (Map.Entry<String, String> entry : this.keyValueMap.entrySet()) {
            sb.append(" ");
            sb.append(entry.getKey());
            sb.append("=\"");
            sb.append(entry.getValue());
            sb.append("\"");
        }
        return sb.toString();
    }

    @Nonnull
    public Object[] getValues() {
        return this.keyValueMap.values().toArray();
    }

    public Object[] getValuesWithThrowable(@Nullable Throwable t2) {
        Object[] ret = this.keyValueMap.values().toArray(new Object[this.keyValueMap.size() + 1]);
        ret[ret.length - 1] = t2;
        return ret;
    }

    public KeyValueLogMessage addKeyAndValue(@Nonnull Object key, @Nullable Object value) {
        this.addKeyValueImpl(key, value);
        return this;
    }

    @Nonnull
    public String getStaticMessage() {
        return this.keyValueMap.get(LogMessageKeys.TITLE.toString());
    }

    public void setStaticMessage(@Nonnull String staticMessage) {
        this.keyValueMap.put(LogMessageKeys.TITLE.toString(), staticMessage);
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    @Nonnull
    public Map<String, String> getKeyValueMap() {
        return Collections.unmodifiableMap(this.keyValueMap);
    }
}

