/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.TupleTypeUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.ZeroCopyByteString;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class FormerIndex {
    @Nonnull
    private final Object subspaceKey;
    private final int addedVersion;
    private final int removedVersion;
    @Nullable
    private final String formerName;

    public FormerIndex(@Nonnull Object subspaceKey, int addedVersion, int removedVersion, @Nullable String formerName) {
        Object normalizedKey = TupleTypeUtil.toTupleEquivalentValue(subspaceKey);
        if (normalizedKey == null) {
            throw new RecordCoreArgumentException("FormerIndex initialized with null subspace key", new Object[]{LogMessageKeys.INDEX_NAME, formerName, LogMessageKeys.SUBSPACE_KEY, subspaceKey});
        }
        this.subspaceKey = normalizedKey;
        this.addedVersion = addedVersion;
        this.removedVersion = removedVersion;
        this.formerName = formerName;
    }

    public FormerIndex(@Nonnull RecordMetaDataProto.FormerIndex proto) {
        this(Index.decodeSubspaceKey(proto.getSubspaceKey()), proto.getAddedVersion(), proto.getRemovedVersion(), proto.hasFormerName() ? proto.getFormerName() : null);
    }

    @Nonnull
    public Object getSubspaceKey() {
        return this.subspaceKey;
    }

    @Nonnull
    public Object getSubspaceTupleKey() {
        return TupleTypeUtil.toTupleAppropriateValue(this.subspaceKey);
    }

    public int getAddedVersion() {
        return this.addedVersion;
    }

    public int getRemovedVersion() {
        return this.removedVersion;
    }

    @Nullable
    public String getFormerName() {
        return this.formerName;
    }

    @Nonnull
    public RecordMetaDataProto.FormerIndex toProto() {
        RecordMetaDataProto.FormerIndex.Builder builder = RecordMetaDataProto.FormerIndex.newBuilder();
        builder.setSubspaceKey(ZeroCopyByteString.wrap(Tuple.from(this.subspaceKey).pack()));
        if (this.addedVersion > 0) {
            builder.setAddedVersion(this.addedVersion);
        }
        if (this.removedVersion > 0) {
            builder.setRemovedVersion(this.removedVersion);
        }
        if (this.formerName != null) {
            builder.setFormerName(this.formerName);
        }
        return builder.build();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("FormerIndex {").append(this.subspaceKey);
        if (this.formerName != null) {
            str.append("=").append(this.formerName);
        }
        str.append("}#").append(this.addedVersion).append("-").append(this.removedVersion);
        return str.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        FormerIndex that = (FormerIndex)o;
        return this.subspaceKey.equals(that.subspaceKey) && Objects.equals(this.formerName, that.formerName) && this.addedVersion == that.addedVersion && this.removedVersion == that.removedVersion;
    }

    public int hashCode() {
        return (Objects.hash(this.subspaceKey, this.formerName) * 37 + this.addedVersion) * 37 + this.removedVersion;
    }
}

