/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.IndexOptions;
import com.apple.foundationdb.record.metadata.IndexPredicate;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.TupleTypeUtil;
import com.apple.foundationdb.record.metadata.expressions.EmptyKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ZeroCopyByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class Index {
    @Nonnull
    public static final KeyExpression EMPTY_VALUE = EmptyKeyExpression.EMPTY;
    @Nonnull
    private final String name;
    @Nonnull
    private final String type;
    @Nonnull
    private final Map<String, String> options;
    @Nonnull
    private final KeyExpression rootExpression;
    @Nullable
    private int[] primaryKeyComponentPositions;
    @Nonnull
    private Object subspaceKey;
    private boolean useExplicitSubspaceKey = false;
    private int addedVersion;
    private int lastModifiedVersion;
    @Nullable
    private final IndexPredicate predicate;

    public static Object decodeSubspaceKey(@Nonnull ByteString bytes) {
        Tuple tuple = Tuple.fromBytes(bytes.toByteArray());
        if (tuple.size() != 1) {
            throw new RecordCoreException("subspace key must encode a single item tuple", new Object[0]);
        }
        return tuple.get(0);
    }

    @Nonnull
    private static Object normalizeSubspaceKey(@Nonnull String name, @Nonnull Object subspaceKey) {
        Object normalizedKey = TupleTypeUtil.toTupleEquivalentValue(subspaceKey);
        if (normalizedKey == null) {
            throw new RecordCoreArgumentException("Index subspace key cannot be null", new Object[]{LogMessageKeys.INDEX_NAME, name, LogMessageKeys.SUBSPACE_KEY, subspaceKey});
        }
        return normalizedKey;
    }

    public Index(@Nonnull String name, @Nonnull KeyExpression rootExpression, @Nonnull String type, @Nonnull Map<String, String> options) {
        this(name, rootExpression, type, options, null);
    }

    public Index(@Nonnull String name, @Nonnull KeyExpression rootExpression, @Nonnull String type, @Nonnull Map<String, String> options, @Nullable IndexPredicate predicate) {
        this.name = name;
        this.rootExpression = rootExpression;
        this.type = type;
        this.options = ImmutableMap.copyOf(options);
        this.subspaceKey = Index.normalizeSubspaceKey(name, name);
        this.lastModifiedVersion = 0;
        this.predicate = predicate;
    }

    public Index(@Nonnull String name, @Nonnull KeyExpression rootExpression, @Nonnull KeyExpression valueExpression, @Nonnull String type, @Nonnull Map<String, String> options) {
        this(name, Index.toKeyWithValueExpression(rootExpression, valueExpression), type, options);
    }

    public Index(@Nonnull String name, @Nonnull KeyExpression rootExpression, @Nonnull String type) {
        this(name, rootExpression, type, IndexOptions.EMPTY_OPTIONS);
    }

    public Index(@Nonnull String name, @Nonnull KeyExpression rootExpression) {
        this(name, rootExpression, "value");
    }

    public Index(@Nonnull String name, @Nonnull String first) {
        this(name, Key.Expressions.field(first));
    }

    public Index(@Nonnull String name, @Nonnull String first, @Nonnull String second, String ... rest) {
        this(name, Key.Expressions.concatenateFields(first, second, rest));
    }

    public Index(@Nonnull Index orig) {
        this(orig, orig.predicate);
    }

    public Index(@Nonnull Index orig, @Nullable IndexPredicate predicate) {
        this(orig.name, orig.rootExpression, orig.type, ImmutableMap.copyOf(orig.options), predicate);
        this.primaryKeyComponentPositions = (int[])(orig.primaryKeyComponentPositions != null ? Arrays.copyOf(orig.primaryKeyComponentPositions, orig.primaryKeyComponentPositions.length) : null);
        this.subspaceKey = Index.normalizeSubspaceKey(this.name, orig.subspaceKey);
        this.useExplicitSubspaceKey = orig.useExplicitSubspaceKey;
        this.addedVersion = orig.addedVersion;
        this.lastModifiedVersion = orig.lastModifiedVersion;
    }

    @SpotBugsSuppressWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
    public Index(@Nonnull RecordMetaDataProto.Index proto) throws KeyExpression.DeserializationException {
        this.name = proto.getName();
        if (proto.hasIndexType()) {
            this.type = Index.indexTypeToType(proto.getIndexType());
            this.options = Index.indexTypeToOptions(proto.getIndexType());
        } else {
            this.type = proto.hasType() ? proto.getType() : "value";
            this.options = Index.buildOptions(proto.getOptionsList(), false);
        }
        KeyExpression expr = KeyExpression.fromProto(proto.getRootExpression());
        if (!(expr instanceof GroupingKeyExpression) && (this.type.equals("rank") || this.type.equals("count") || this.type.equals("max_ever") || this.type.equals("min_ever") || this.type.equals("sum"))) {
            expr = new GroupingKeyExpression(expr, this.type.equals("count") ? expr.getColumnSize() : 1);
        }
        if (proto.hasValueExpression()) {
            KeyExpression value = KeyExpression.fromProto(proto.getValueExpression());
            expr = Index.toKeyWithValueExpression(expr, value);
        }
        this.rootExpression = expr;
        if (proto.hasSubspaceKey()) {
            this.setSubspaceKey(Index.normalizeSubspaceKey(this.name, Index.decodeSubspaceKey(proto.getSubspaceKey())));
        } else {
            this.setSubspaceKey(Index.normalizeSubspaceKey(this.name, this.name));
        }
        this.addedVersion = proto.hasAddedVersion() ? proto.getAddedVersion() : 1;
        if (proto.hasLastModifiedVersion()) {
            this.lastModifiedVersion = proto.getLastModifiedVersion();
        }
        this.predicate = proto.hasPredicate() ? IndexPredicate.fromProto(proto.getPredicate()) : null;
    }

    @Nonnull
    private static KeyExpression toKeyWithValueExpression(@Nonnull KeyExpression rootExpression, @Nonnull KeyExpression valueExpression) {
        if (valueExpression.getColumnSize() == 0) {
            return rootExpression;
        }
        return Key.Expressions.keyWithValue(Key.Expressions.concat(rootExpression, valueExpression, new KeyExpression[0]), rootExpression.getColumnSize());
    }

    public static Map<String, String> buildOptions(List<RecordMetaDataProto.Index.Option> optionList, boolean addUnique) {
        if (optionList.isEmpty() && !addUnique) {
            return IndexOptions.EMPTY_OPTIONS;
        }
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        if (addUnique) {
            builder.put("unique", Boolean.TRUE.toString());
        }
        for (RecordMetaDataProto.Index.Option option : optionList) {
            builder.put(option.getKey(), option.getValue());
        }
        return builder.build();
    }

    public static String indexTypeToType(RecordMetaDataProto.Index.Type indexType) {
        switch (indexType) {
            case RANK: 
            case RANK_UNIQUE: {
                return "rank";
            }
        }
        return "value";
    }

    public static Map<String, String> indexTypeToOptions(RecordMetaDataProto.Index.Type indexType) {
        switch (indexType) {
            case RANK_UNIQUE: 
            case UNIQUE: {
                return IndexOptions.UNIQUE_OPTIONS;
            }
        }
        return IndexOptions.EMPTY_OPTIONS;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getType() {
        return this.type;
    }

    @Nonnull
    public Map<String, String> getOptions() {
        return this.options;
    }

    @Nullable
    public String getOption(@Nonnull String key) {
        return this.options.get(key);
    }

    public boolean getBooleanOption(@Nonnull String key, boolean defaultValue) {
        String option = this.getOption(key);
        if (option == null) {
            return defaultValue;
        }
        return Boolean.valueOf(option);
    }

    @Nonnull
    public KeyExpression getRootExpression() {
        return this.rootExpression;
    }

    public boolean isUnique() {
        return this.getBooleanOption("unique", false);
    }

    @Nonnull
    public List<String> getReplacedByIndexNames() {
        ImmutableList.Builder replacedByIndexNames = ImmutableList.builder();
        for (Map.Entry<String, String> option : this.getOptions().entrySet()) {
            if (!option.getKey().startsWith("replacedBy")) continue;
            replacedByIndexNames.add(option.getValue());
        }
        return replacedByIndexNames.build();
    }

    @Nonnull
    public Object getSubspaceKey() {
        return this.subspaceKey;
    }

    @Nonnull
    public Object getSubspaceTupleKey() {
        return TupleTypeUtil.toTupleAppropriateValue(this.subspaceKey);
    }

    public void setSubspaceKey(@Nonnull Object subspaceKey) {
        this.useExplicitSubspaceKey = true;
        this.subspaceKey = Index.normalizeSubspaceKey(this.name, subspaceKey);
    }

    public boolean hasExplicitSubspaceKey() {
        return this.useExplicitSubspaceKey;
    }

    @Nullable
    @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP"})
    public int[] getPrimaryKeyComponentPositions() {
        return this.primaryKeyComponentPositions;
    }

    @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP2"})
    public void setPrimaryKeyComponentPositions(int[] primaryKeyComponentPositions) {
        this.primaryKeyComponentPositions = primaryKeyComponentPositions;
    }

    @API(value=API.Status.INTERNAL)
    public void trimPrimaryKey(List<?> primaryKeys) {
        if (this.primaryKeyComponentPositions != null) {
            for (int i = this.primaryKeyComponentPositions.length - 1; i >= 0; --i) {
                if (this.primaryKeyComponentPositions[i] < 0) continue;
                primaryKeys.remove(i);
            }
        }
    }

    @API(value=API.Status.INTERNAL)
    public BitSet getCoveredPrimaryKeyPositions() {
        BitSet resultSet;
        if (this.primaryKeyComponentPositions != null) {
            resultSet = new BitSet(this.primaryKeyComponentPositions.length);
            for (int i = 0; i < this.primaryKeyComponentPositions.length; ++i) {
                if (this.primaryKeyComponentPositions[i] < 0) continue;
                resultSet.set(i);
            }
        } else {
            resultSet = new BitSet();
        }
        return resultSet;
    }

    boolean hasPrimaryKeyComponentPositions() {
        return this.primaryKeyComponentPositions != null && IntStream.of(this.primaryKeyComponentPositions).anyMatch(i -> i >= 0);
    }

    public int getColumnSize() {
        return this.rootExpression.getColumnSize();
    }

    public int getEntrySize(KeyExpression primaryKey) {
        int total = this.getColumnSize() + primaryKey.getColumnSize();
        if (this.primaryKeyComponentPositions != null) {
            for (int pos : this.primaryKeyComponentPositions) {
                if (pos < 0) continue;
                --total;
            }
        }
        return total;
    }

    @Nonnull
    public Tuple getEntryPrimaryKey(@Nonnull Tuple entry) {
        List<Object> primaryKeys;
        List<Object> entryKeys = entry.getItems();
        if (this.primaryKeyComponentPositions == null) {
            primaryKeys = entryKeys.subList(this.getColumnSize(), entryKeys.size());
        } else {
            primaryKeys = new ArrayList<Object>(this.primaryKeyComponentPositions.length);
            int after = this.getColumnSize();
            for (int position : this.primaryKeyComponentPositions) {
                primaryKeys.add(entryKeys.get(position < 0 ? after++ : position));
            }
        }
        return Tuple.fromList(primaryKeys);
    }

    @Nonnull
    public List<Integer> getEntryPrimaryKeyPositions(int primaryKeyLength) {
        ArrayList<Integer> primaryKeys = new ArrayList<Integer>(primaryKeyLength);
        int columnSize = this.getColumnSize();
        if (this.primaryKeyComponentPositions == null) {
            for (int i = columnSize; i < columnSize + primaryKeyLength; ++i) {
                primaryKeys.add(i);
            }
        } else {
            int after = columnSize;
            for (int position : this.primaryKeyComponentPositions) {
                primaryKeys.add(position < 0 ? after++ : position);
            }
        }
        return primaryKeys;
    }

    public int getAddedVersion() {
        return this.addedVersion;
    }

    public void setAddedVersion(int addedVersion) {
        this.addedVersion = addedVersion;
    }

    public int getLastModifiedVersion() {
        return this.lastModifiedVersion;
    }

    @Nullable
    public IndexPredicate getPredicate() {
        return this.predicate;
    }

    public boolean hasPredicate() {
        return this.predicate != null;
    }

    public void setLastModifiedVersion(int lastModifiedVersion) {
        this.lastModifiedVersion = lastModifiedVersion;
    }

    public List<Descriptors.FieldDescriptor> validate(@Nonnull Descriptors.Descriptor recordType) {
        return this.rootExpression.validate(recordType);
    }

    @Nonnull
    public RecordMetaDataProto.Index toProto() throws KeyExpression.SerializationException {
        RecordMetaDataProto.Index.Builder builder = RecordMetaDataProto.Index.newBuilder();
        builder.setName(this.name);
        builder.setRootExpression(this.rootExpression.toKeyExpression());
        builder.setType(this.type);
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            builder.addOptionsBuilder().setKey(entry.getKey()).setValue(entry.getValue());
        }
        builder.setSubspaceKey(ZeroCopyByteString.wrap(Tuple.from(this.subspaceKey).pack()));
        if (this.addedVersion > 0) {
            builder.setAddedVersion(this.addedVersion);
        }
        if (this.lastModifiedVersion > 0) {
            builder.setLastModifiedVersion(this.lastModifiedVersion);
        }
        if (this.predicate != null) {
            builder.setPredicate(this.predicate.toProto());
        }
        return builder.build();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Index {'").append(this.name).append("'");
        if (!this.type.equals("value")) {
            str.append(", ").append(this.type);
        }
        str.append("}");
        if (this.lastModifiedVersion > 0) {
            str.append("#").append(this.lastModifiedVersion);
        }
        if (this.predicate != null) {
            str.append("where ").append(this.predicate);
        }
        return str.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        Index that = (Index)o;
        return this.name.equals(that.name) && this.type.equals(that.type) && this.rootExpression.equals(that.rootExpression) && this.subspaceKey.equals(that.subspaceKey) && this.addedVersion == that.addedVersion && this.lastModifiedVersion == that.lastModifiedVersion && Arrays.equals(this.primaryKeyComponentPositions, that.primaryKeyComponentPositions) && this.options.equals(that.options) && Objects.equals(this.predicate, that.predicate);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }
}

