/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.planprotos.PIndexAggregateFunction;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.google.protobuf.Descriptors;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class IndexAggregateFunction
implements PlanHashable,
PlanSerializable {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Index-Aggregate-Function");
    @Nonnull
    private final String name;
    @Nonnull
    private final KeyExpression operand;
    @Nullable
    private final String index;

    public IndexAggregateFunction(@Nonnull String name, @Nonnull KeyExpression operand, @Nullable String index) {
        this.name = name;
        this.operand = operand;
        this.index = index;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public KeyExpression getOperand() {
        return this.operand;
    }

    @Nullable
    public String getIndex() {
        return this.index;
    }

    @Nonnull
    public IndexAggregateFunction cloneWithOperand(@Nonnull KeyExpression operand) {
        return new IndexAggregateFunction(this.getName(), operand, this.getIndex());
    }

    @Nonnull
    public IndexAggregateFunction cloneWithIndex(@Nonnull String index) {
        return new IndexAggregateFunction(this.getName(), this.getOperand(), index);
    }

    public void validate(@Nonnull Descriptors.Descriptor descriptor) {
        this.operand.validate(descriptor);
    }

    @Nonnull
    public TupleRange adjustRange(@Nonnull EvaluationContext context, @Nonnull TupleRange tupleRange) {
        return tupleRange;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.index != null) {
            str.append(this.index).append('.');
        }
        str.append(this.name).append('(').append(this.operand).append(')');
        return str.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexAggregateFunction that = (IndexAggregateFunction)o;
        return this.name.equals(that.name) && this.operand.equals(that.operand) && Objects.equals(this.index, that.index);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.operand.hashCode();
        if (this.index != null) {
            result = 31 * result + this.index.hashCode();
        }
        return result;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.name.hashCode() + this.operand.planHash(mode) + Objects.hashCode(this.index);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.name, this.operand, this.index);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public PIndexAggregateFunction toProto(@Nonnull PlanSerializationContext serializationContext) {
        PIndexAggregateFunction.Builder builder = PIndexAggregateFunction.newBuilder().setName(this.name).setOperand(this.operand.toKeyExpression());
        if (this.index != null) {
            builder.setIndex(this.index);
        }
        return builder.build();
    }

    @Nonnull
    public static IndexAggregateFunction fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexAggregateFunction indexAggregateFunctionProto) {
        return new IndexAggregateFunction(Objects.requireNonNull(indexAggregateFunctionProto.getName()), KeyExpression.fromProto(Objects.requireNonNull(indexAggregateFunctionProto.getOperand())), PlanSerialization.getFieldOrNull(indexAggregateFunctionProto, PIndexAggregateFunction::hasIndex, PIndexAggregateFunction::getIndex));
    }
}

