/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.metadata.IndexAggregateFunction;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.EmptyKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterable;
import com.apple.foundationdb.record.query.combinatorics.TopologicalSort;
import com.apple.foundationdb.record.query.expressions.AndComponent;
import com.apple.foundationdb.record.query.expressions.BaseField;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.ComponentWithComparison;
import com.apple.foundationdb.record.query.expressions.FieldWithComparison;
import com.apple.foundationdb.record.query.expressions.NestedField;
import com.apple.foundationdb.record.query.expressions.OneOfThemWithComparison;
import com.apple.foundationdb.record.query.expressions.OneOfThemWithComponent;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class IndexAggregateFunctionCall {
    @Nonnull
    private final String functionName;
    @Nonnull
    private final GroupingKeyExpression groupingKeyExpression;
    @Nonnull
    private final Set<KeyExpression> groupingExpressions;
    @Nonnull
    private final KeyExpression groupedExpression;
    private final boolean isGroupingPermutable;

    public IndexAggregateFunctionCall(@Nonnull String functionName, @Nonnull GroupingKeyExpression groupingKeyExpression) {
        this(functionName, groupingKeyExpression, groupingKeyExpression.getGroupingSubKey().normalizeKeyForPositions(), groupingKeyExpression.getGroupedSubKey());
    }

    protected IndexAggregateFunctionCall(@Nonnull String functionName, @Nonnull GroupingKeyExpression groupingKeyExpression, @Nonnull Iterable<KeyExpression> groupingExpressions, @Nonnull KeyExpression groupedExpression) {
        this.functionName = functionName;
        this.groupingKeyExpression = groupingKeyExpression;
        this.groupingExpressions = groupingKeyExpression.getGroupingCount() == 0 ? ImmutableSet.of() : ImmutableSet.copyOf(groupingExpressions);
        this.groupedExpression = groupedExpression;
        this.isGroupingPermutable = groupingKeyExpression.getGroupingSubKey().equals(EmptyKeyExpression.EMPTY) || groupingKeyExpression.hasLosslessNormalization();
    }

    @Nonnull
    public String getFunctionName() {
        return this.functionName;
    }

    @Nonnull
    public GroupingKeyExpression getGroupingKeyExpression() {
        return this.groupingKeyExpression;
    }

    @Nonnull
    public Set<KeyExpression> getGroupingExpressions() {
        return this.groupingExpressions;
    }

    @Nonnull
    public KeyExpression getGroupedExpression() {
        return this.groupedExpression;
    }

    public boolean isGroupingPermutable() {
        return this.isGroupingPermutable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexAggregateFunctionCall)) {
            return false;
        }
        IndexAggregateFunctionCall that = (IndexAggregateFunctionCall)o;
        return Objects.equal(this.getFunctionName(), that.getFunctionName()) && Objects.equal(this.getGroupingKeyExpression(), that.getGroupingKeyExpression()) && Objects.equal(this.getGroupingExpressions(), that.getGroupingExpressions()) && Objects.equal(this.getGroupedExpression(), that.getGroupedExpression());
    }

    public int hashCode() {
        return Objects.hashCode(this.getFunctionName(), this.getGroupingKeyExpression(), this.getGroupingExpressions(), this.getGroupedExpression());
    }

    @Nonnull
    public IndexAggregateFunctionCall withNewGroupingKeyExpression(@Nonnull GroupingKeyExpression groupingKeyExpression) {
        return new IndexAggregateFunctionCall(this.getFunctionName(), groupingKeyExpression);
    }

    @Nonnull
    public IndexAggregateFunctionCall withNewExpressions(@Nonnull List<KeyExpression> groupingKeysPermutation, @Nonnull KeyExpression groupedExpression) {
        return this.withNewGroupingKeyExpression(IndexAggregateFunctionCall.toGroupingKeyExpression(groupingKeysPermutation, groupedExpression));
    }

    @Nonnull
    public QueryComponent applyCondition(@Nonnull QueryComponent filterCondition) {
        return filterCondition;
    }

    public Stream<IndexAggregateFunction> enumerateIndexAggregateFunctionCandidates(@Nonnull String indexName) {
        if (this.isGroupingPermutable) {
            EnumeratingIterable<KeyExpression> groupingPermutations = TopologicalSort.permutations(this.getGroupingExpressions());
            return StreamSupport.stream(groupingPermutations.spliterator(), false).map(groupingPermutation -> this.toIndexAggregateFunction(indexName, (List<KeyExpression>)groupingPermutation));
        }
        return Stream.of(this.toIndexAggregateFunction(indexName));
    }

    @Nonnull
    protected IndexAggregateFunction toIndexAggregateFunction(@Nonnull String indexName, @Nonnull List<KeyExpression> groupingKeysPermutation) {
        return this.toIndexAggregateFunction(indexName, this.toGroupingKeyExpression(groupingKeysPermutation));
    }

    @Nonnull
    public IndexAggregateFunction toIndexAggregateFunction(@Nullable String indexName) {
        return this.toIndexAggregateFunction(indexName, this.groupingKeyExpression);
    }

    @Nonnull
    protected IndexAggregateFunction toIndexAggregateFunction(@Nullable String indexName, @Nonnull GroupingKeyExpression groupingKeyExpression) {
        return new IndexAggregateFunction(this.getFunctionName(), groupingKeyExpression, indexName);
    }

    @Nonnull
    protected GroupingKeyExpression toGroupingKeyExpression(@Nonnull List<KeyExpression> groupingKeysPermutation) {
        return IndexAggregateFunctionCall.toGroupingKeyExpression(groupingKeysPermutation, this.groupedExpression);
    }

    @Nonnull
    public static GroupingKeyExpression toGroupingKeyExpression(@Nonnull List<KeyExpression> groupingKeysPermutation, @Nonnull KeyExpression groupedExpression) {
        KeyExpression keyPart = groupingKeysPermutation.isEmpty() ? EmptyKeyExpression.EMPTY : (groupingKeysPermutation.size() == 1 ? Iterables.getOnlyElement(groupingKeysPermutation) : Key.Expressions.concat(groupingKeysPermutation));
        if (groupedExpression.getColumnSize() == 0) {
            return new GroupingKeyExpression(keyPart, 0);
        }
        return Key.Expressions.concat(keyPart, groupedExpression, new KeyExpression[0]).group(groupedExpression.getColumnSize());
    }

    @Nonnull
    public static Set<KeyExpression> extractEqualityBoundFields(@Nonnull QueryComponent queryComponent) {
        return IndexAggregateFunctionCall.extractFieldPaths(queryComponent, fieldWithComparison -> fieldWithComparison.getComparison().getType() == Comparisons.Type.EQUALS || fieldWithComparison.getComparison().getType() == Comparisons.Type.IS_NULL);
    }

    @Nonnull
    public static Set<KeyExpression> extractFieldPaths(@Nonnull QueryComponent queryComponent, @Nonnull Predicate<ComponentWithComparison> predicate) {
        if (queryComponent instanceof BaseField) {
            OneOfThemWithComparison oneOfThemWithComparison;
            FieldWithComparison fieldWithComparison;
            BaseField baseField = (BaseField)queryComponent;
            if (baseField instanceof NestedField) {
                NestedField nestedField = (NestedField)baseField;
                Set<KeyExpression> nestedExpressions = IndexAggregateFunctionCall.extractFieldPaths(nestedField.getChild(), predicate);
                return nestedExpressions.stream().map(nestedExpression -> Key.Expressions.field(nestedField.getFieldName()).nest((KeyExpression)nestedExpression)).collect(ImmutableSet.toImmutableSet());
            }
            if (baseField instanceof FieldWithComparison && predicate.test(fieldWithComparison = (FieldWithComparison)baseField)) {
                return ImmutableSet.of(Key.Expressions.field(fieldWithComparison.getFieldName()));
            }
            if (baseField instanceof OneOfThemWithComparison && predicate.test(oneOfThemWithComparison = (OneOfThemWithComparison)baseField)) {
                return ImmutableSet.of(Key.Expressions.field(oneOfThemWithComparison.getFieldName(), KeyExpression.FanType.FanOut));
            }
            if (baseField instanceof OneOfThemWithComponent) {
                OneOfThemWithComponent oneOfThemWithComponent = (OneOfThemWithComponent)baseField;
                Set<KeyExpression> nestedExpressions = IndexAggregateFunctionCall.extractFieldPaths(oneOfThemWithComponent.getChild(), predicate);
                return nestedExpressions.stream().map(nestedExpression -> Key.Expressions.field(oneOfThemWithComponent.getFieldName(), KeyExpression.FanType.FanOut).nest((KeyExpression)nestedExpression)).collect(ImmutableSet.toImmutableSet());
            }
            return ImmutableSet.of();
        }
        if (queryComponent instanceof AndComponent) {
            HashSet<KeyExpression> boundFields = Sets.newHashSet();
            AndComponent andComponent = (AndComponent)queryComponent;
            andComponent.getChildren().forEach(child -> boundFields.addAll(IndexAggregateFunctionCall.extractEqualityBoundFields(child)));
            return boundFields;
        }
        return ImmutableSet.of();
    }
}

