/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.expressions.LiteralKeyExpression;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public abstract class IndexComparison {
    @Nonnull
    public static IndexComparison fromProto(@Nonnull RecordMetaDataProto.Comparison proto) {
        if (proto.hasSimpleComparison()) {
            return new SimpleComparison(proto.getSimpleComparison());
        }
        if (proto.hasNullComparison()) {
            return new NullComparison(proto.getNullComparison());
        }
        throw new RecordCoreException("attempt to deserialize unsupported comparison", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.COMPARISON_VALUE, proto});
    }

    @Nonnull
    @VisibleForTesting
    public static IndexComparison fromComparison(@Nonnull Comparisons.Comparison comparison) {
        if (comparison instanceof Comparisons.SimpleComparison) {
            return new SimpleComparison((Comparisons.SimpleComparison)comparison);
        }
        if (comparison instanceof Comparisons.NullComparison) {
            return new NullComparison((Comparisons.NullComparison)comparison);
        }
        throw new RecordCoreException("attempt to create PoJo index comparison from unsupported comparison", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.COMPARISON_VALUE, comparison});
    }

    public static boolean isSupported(@Nonnull Comparisons.Comparison comparison) {
        return comparison instanceof Comparisons.SimpleComparison || comparison instanceof Comparisons.NullComparison || comparison instanceof Comparisons.ValueComparison && ((Comparisons.ValueComparison)comparison).getComparandValue().preOrderStream().filter(value -> !(value instanceof Value.RangeMatchableValue)).findAny().isEmpty();
    }

    @Nonnull
    public abstract RecordMetaDataProto.Comparison toProto();

    @Nonnull
    public abstract Comparisons.Comparison toComparison();

    public static class SimpleComparison
    extends IndexComparison {
        @Nonnull
        private final ComparisonType comparisonType;
        @Nonnull
        private final Object operand;

        @VisibleForTesting
        public SimpleComparison(Comparisons.SimpleComparison comparison) {
            switch (comparison.getType()) {
                case EQUALS: {
                    this.comparisonType = ComparisonType.EQUALS;
                    break;
                }
                case NOT_EQUALS: {
                    this.comparisonType = ComparisonType.NOT_EQUALS;
                    break;
                }
                case LESS_THAN: {
                    this.comparisonType = ComparisonType.LESS_THAN;
                    break;
                }
                case LESS_THAN_OR_EQUALS: {
                    this.comparisonType = ComparisonType.LESS_THAN_OR_EQUALS;
                    break;
                }
                case GREATER_THAN: {
                    this.comparisonType = ComparisonType.GREATER_THAN;
                    break;
                }
                case GREATER_THAN_OR_EQUALS: {
                    this.comparisonType = ComparisonType.GREATER_THAN_OR_EQUALS;
                    break;
                }
                case NOT_NULL: {
                    this.comparisonType = ComparisonType.NOT_NULL;
                    break;
                }
                case IS_NULL: {
                    this.comparisonType = ComparisonType.IS_NULL;
                    break;
                }
                default: {
                    throw new RecordCoreException("attempt to construct PoJo index comparison from unsupported comparison type", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.COMPARISON_TYPE, comparison.getType()});
                }
            }
            this.operand = comparison.getComparand(null, null);
        }

        public SimpleComparison(@Nonnull ComparisonType comparisonType, @Nonnull Object operand) {
            this.comparisonType = comparisonType;
            this.operand = operand;
        }

        public SimpleComparison(@Nonnull RecordMetaDataProto.SimpleComparison proto) {
            ComparisonType comparisonType;
            Object comparand = Objects.requireNonNull(LiteralKeyExpression.fromProtoValue(proto.getOperand()));
            switch (proto.getType()) {
                case EQUALS: {
                    comparisonType = ComparisonType.EQUALS;
                    break;
                }
                case NOT_EQUALS: {
                    comparisonType = ComparisonType.NOT_EQUALS;
                    break;
                }
                case LESS_THAN: {
                    comparisonType = ComparisonType.LESS_THAN;
                    break;
                }
                case LESS_THAN_OR_EQUALS: {
                    comparisonType = ComparisonType.LESS_THAN_OR_EQUALS;
                    break;
                }
                case GREATER_THAN: {
                    comparisonType = ComparisonType.GREATER_THAN;
                    break;
                }
                case GREATER_THAN_OR_EQUALS: {
                    comparisonType = ComparisonType.GREATER_THAN_OR_EQUALS;
                    break;
                }
                case NOT_NULL: {
                    comparisonType = ComparisonType.NOT_NULL;
                    break;
                }
                case IS_NULL: {
                    comparisonType = ComparisonType.IS_NULL;
                    break;
                }
                default: {
                    throw new RecordCoreException("attempt to deserialize unsupported comparison type", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.COMPARISON_TYPE, proto.getType()});
                }
            }
            this.comparisonType = comparisonType;
            this.operand = comparand;
        }

        @Nonnull
        public Object getOperand() {
            return this.operand;
        }

        @Nonnull
        public ComparisonType getComparisonType() {
            return this.comparisonType;
        }

        @Override
        @Nonnull
        public RecordMetaDataProto.Comparison toProto() {
            RecordMetaDataProto.ComparisonType protoComparison;
            switch (this.comparisonType) {
                case EQUALS: {
                    protoComparison = RecordMetaDataProto.ComparisonType.EQUALS;
                    break;
                }
                case NOT_EQUALS: {
                    protoComparison = RecordMetaDataProto.ComparisonType.NOT_EQUALS;
                    break;
                }
                case LESS_THAN: {
                    protoComparison = RecordMetaDataProto.ComparisonType.LESS_THAN;
                    break;
                }
                case LESS_THAN_OR_EQUALS: {
                    protoComparison = RecordMetaDataProto.ComparisonType.LESS_THAN_OR_EQUALS;
                    break;
                }
                case GREATER_THAN: {
                    protoComparison = RecordMetaDataProto.ComparisonType.GREATER_THAN;
                    break;
                }
                case GREATER_THAN_OR_EQUALS: {
                    protoComparison = RecordMetaDataProto.ComparisonType.GREATER_THAN_OR_EQUALS;
                    break;
                }
                case NOT_NULL: {
                    protoComparison = RecordMetaDataProto.ComparisonType.NOT_NULL;
                    break;
                }
                case IS_NULL: {
                    protoComparison = RecordMetaDataProto.ComparisonType.IS_NULL;
                    break;
                }
                default: {
                    throw new RecordCoreException("serializing comparison type is not supported", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.COMPARISON_TYPE, this.comparisonType});
                }
            }
            return RecordMetaDataProto.Comparison.newBuilder().setSimpleComparison(RecordMetaDataProto.SimpleComparison.newBuilder().setType(protoComparison).setOperand(LiteralKeyExpression.toProtoValue(this.operand)).build()).build();
        }

        @Override
        @Nonnull
        public Comparisons.Comparison toComparison() {
            Comparisons.Type type;
            switch (this.comparisonType) {
                case EQUALS: {
                    type = Comparisons.Type.EQUALS;
                    break;
                }
                case NOT_EQUALS: {
                    type = Comparisons.Type.NOT_EQUALS;
                    break;
                }
                case LESS_THAN: {
                    type = Comparisons.Type.LESS_THAN;
                    break;
                }
                case LESS_THAN_OR_EQUALS: {
                    type = Comparisons.Type.LESS_THAN_OR_EQUALS;
                    break;
                }
                case GREATER_THAN: {
                    type = Comparisons.Type.GREATER_THAN;
                    break;
                }
                case GREATER_THAN_OR_EQUALS: {
                    type = Comparisons.Type.GREATER_THAN_OR_EQUALS;
                    break;
                }
                case NOT_NULL: {
                    type = Comparisons.Type.NOT_NULL;
                    break;
                }
                case IS_NULL: {
                    type = Comparisons.Type.IS_NULL;
                    break;
                }
                default: {
                    throw new RecordCoreException("serializing comparison type is not supported", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.COMPARISON_TYPE, this.comparisonType});
                }
            }
            return new Comparisons.SimpleComparison(type, this.operand);
        }

        public String toString() {
            return this.comparisonType.name() + " " + String.valueOf(this.operand) + " ";
        }

        public static enum ComparisonType {
            EQUALS,
            NOT_EQUALS,
            LESS_THAN,
            LESS_THAN_OR_EQUALS,
            GREATER_THAN,
            GREATER_THAN_OR_EQUALS,
            STARTS_WITH,
            NOT_NULL,
            IS_NULL;

        }
    }

    public static class NullComparison
    extends IndexComparison {
        private final boolean isNull;

        public NullComparison(boolean isNull) {
            this.isNull = isNull;
        }

        public NullComparison(@Nonnull RecordMetaDataProto.NullComparison nullComparison) {
            this.isNull = nullComparison.getIsNull();
        }

        @VisibleForTesting
        public NullComparison(@Nonnull Comparisons.NullComparison comparison) {
            this.isNull = comparison.getType().equals((Object)Comparisons.Type.IS_NULL);
        }

        public boolean isNull() {
            return this.isNull;
        }

        @Override
        @Nonnull
        public RecordMetaDataProto.Comparison toProto() {
            return RecordMetaDataProto.Comparison.newBuilder().setNullComparison(RecordMetaDataProto.NullComparison.newBuilder().setIsNull(this.isNull).build()).build();
        }

        @Override
        @Nonnull
        public Comparisons.Comparison toComparison() {
            return new Comparisons.NullComparison(this.isNull ? Comparisons.Type.IS_NULL : Comparisons.Type.NOT_NULL);
        }

        public String toString() {
            return this.isNull ? "IS NULL " : "IS NOT NULL ";
        }
    }
}

