/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.IndexComparison;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexableRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public abstract class IndexPredicate {
    private final Map<String, QueryPredicate> queryPredicateMap = new ConcurrentHashMap<String, QueryPredicate>();

    public <M extends Message> boolean shouldIndexThisRecord(@Nonnull FDBRecordStore store, @Nonnull FDBIndexableRecord<M> savedRecord) {
        CorrelationIdentifier objectQuantifier = Quantifier.current();
        QueryPredicate queryPredicate = this.getQueryPredicate(store.getRecordMetaData(), savedRecord.getRecordType(), objectQuantifier);
        String bindingName = Bindings.Internal.CORRELATION.bindingName(objectQuantifier.getId());
        Bindings bindings = Bindings.newBuilder().set(bindingName, QueryResult.ofComputed(savedRecord.getRecord())).build();
        return Boolean.TRUE.equals(queryPredicate.eval(store, EvaluationContext.forBindings(bindings)));
    }

    private QueryPredicate getQueryPredicate(RecordMetaData metaData, RecordType type, CorrelationIdentifier objectQuantifier) {
        String typeName = type.getName();
        String keyName = typeName + "#" + objectQuantifier.getId();
        return this.queryPredicateMap.computeIfAbsent(keyName, ignored -> {
            RecordType recordType = metaData.getRecordType(typeName);
            Type.Record typeRecord = Type.Record.fromDescriptor(recordType.getDescriptor());
            QuantifiedObjectValue recordValue = QuantifiedObjectValue.of(objectQuantifier, typeRecord);
            return this.toPredicate(recordValue);
        });
    }

    @Nonnull
    public static IndexPredicate fromProto(@Nonnull RecordMetaDataProto.Predicate proto) {
        if (proto.hasAndPredicate()) {
            return new AndPredicate(proto.getAndPredicate());
        }
        if (proto.hasOrPredicate()) {
            return new OrPredicate(proto.getOrPredicate());
        }
        if (proto.hasConstantPredicate()) {
            return new ConstantPredicate(proto.getConstantPredicate());
        }
        if (proto.hasNotPredicate()) {
            return new NotPredicate(proto.getNotPredicate());
        }
        if (proto.hasValuePredicate()) {
            return new ValuePredicate(proto.getValuePredicate());
        }
        throw new RecordCoreException("attempt to deserialize unsupported predicate", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.VALUE, proto});
    }

    @Nonnull
    @VisibleForTesting
    public static IndexPredicate fromQueryPredicate(@Nonnull QueryPredicate queryPredicate) {
        if (queryPredicate instanceof com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate) {
            return new ConstantPredicate((com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate)queryPredicate);
        }
        if (queryPredicate instanceof com.apple.foundationdb.record.query.plan.cascades.predicates.NotPredicate) {
            return new NotPredicate((com.apple.foundationdb.record.query.plan.cascades.predicates.NotPredicate)queryPredicate);
        }
        if (queryPredicate instanceof com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate) {
            return new AndPredicate((com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate)queryPredicate);
        }
        if (queryPredicate instanceof com.apple.foundationdb.record.query.plan.cascades.predicates.OrPredicate) {
            return new OrPredicate((com.apple.foundationdb.record.query.plan.cascades.predicates.OrPredicate)queryPredicate);
        }
        if (queryPredicate instanceof com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate) {
            return new ValuePredicate((com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate)queryPredicate);
        }
        throw new RecordCoreException("attempt to construct index predicate PoJo from unsupported query predicate", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.VALUE, queryPredicate});
    }

    public static boolean isSupported(@Nonnull QueryPredicate predicate) {
        if (predicate instanceof com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate) {
            return true;
        }
        if (predicate instanceof com.apple.foundationdb.record.query.plan.cascades.predicates.NotPredicate) {
            return IndexPredicate.isSupported(((com.apple.foundationdb.record.query.plan.cascades.predicates.NotPredicate)predicate).child);
        }
        if (predicate instanceof com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate) {
            return StreamSupport.stream(predicate.getChildren().spliterator(), false).allMatch(IndexPredicate::isSupported);
        }
        if (predicate instanceof com.apple.foundationdb.record.query.plan.cascades.predicates.OrPredicate) {
            return StreamSupport.stream(predicate.getChildren().spliterator(), false).allMatch(IndexPredicate::isSupported);
        }
        if (predicate instanceof com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate) {
            com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate valuePredicate = (com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate)predicate;
            return IndexComparison.isSupported(valuePredicate.getComparison()) && valuePredicate.getValue() instanceof FieldValue && ((FieldValue)valuePredicate.getValue()).getFieldPathNamesMaybe().stream().allMatch(Optional::isPresent);
        }
        return false;
    }

    @Nonnull
    public abstract RecordMetaDataProto.Predicate toProto();

    @Nonnull
    public abstract QueryPredicate toPredicate(@Nonnull Value var1);

    public static class AndPredicate
    extends IndexPredicate {
        @Nonnull
        private final List<IndexPredicate> children;

        public AndPredicate(@Nonnull Collection<IndexPredicate> children) {
            this.children = ImmutableList.copyOf(children);
        }

        public AndPredicate(@Nonnull RecordMetaDataProto.AndPredicate proto) {
            this.children = proto.getChildrenList().stream().map(IndexPredicate::fromProto).collect(Collectors.toList());
        }

        @VisibleForTesting
        public AndPredicate(@Nonnull com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate predicate) {
            this.children = predicate.getChildren().stream().map(IndexPredicate::fromQueryPredicate).collect(Collectors.toList());
        }

        @Nonnull
        public List<IndexPredicate> getChildren() {
            return this.children;
        }

        @Override
        @Nonnull
        public RecordMetaDataProto.Predicate toProto() {
            RecordMetaDataProto.AndPredicate.Builder andPredicateProto = RecordMetaDataProto.AndPredicate.newBuilder();
            this.children.forEach(child -> andPredicateProto.addChildren(child.toProto()));
            return RecordMetaDataProto.Predicate.newBuilder().setAndPredicate(andPredicateProto.build()).build();
        }

        @Override
        @Nonnull
        public QueryPredicate toPredicate(@Nonnull Value value) {
            return com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate.and(this.children.stream().map(c -> c.toPredicate(value)).collect(Collectors.toList()));
        }

        public String toString() {
            return "(" + this.children.stream().map(Object::toString).collect(Collectors.joining(" AND ")) + ") ";
        }
    }

    public static class OrPredicate
    extends IndexPredicate {
        @Nonnull
        private final List<IndexPredicate> children;

        public OrPredicate(@Nonnull Collection<IndexPredicate> children) {
            this.children = ImmutableList.copyOf(children);
        }

        public OrPredicate(@Nonnull RecordMetaDataProto.OrPredicate proto) {
            this.children = proto.getChildrenList().stream().map(IndexPredicate::fromProto).collect(Collectors.toList());
        }

        @VisibleForTesting
        public OrPredicate(@Nonnull com.apple.foundationdb.record.query.plan.cascades.predicates.OrPredicate predicate) {
            this.children = predicate.getChildren().stream().map(IndexPredicate::fromQueryPredicate).collect(Collectors.toList());
        }

        @Nonnull
        public List<IndexPredicate> getChildren() {
            return this.children;
        }

        @Override
        @Nonnull
        public RecordMetaDataProto.Predicate toProto() {
            RecordMetaDataProto.OrPredicate.Builder orPredicateProto = RecordMetaDataProto.OrPredicate.newBuilder();
            this.children.forEach(child -> orPredicateProto.addChildren(child.toProto()));
            return RecordMetaDataProto.Predicate.newBuilder().setOrPredicate(orPredicateProto.build()).build();
        }

        @Override
        @Nonnull
        public QueryPredicate toPredicate(@Nonnull Value value) {
            return com.apple.foundationdb.record.query.plan.cascades.predicates.OrPredicate.or(this.children.stream().map(c -> c.toPredicate(value)).collect(Collectors.toList()));
        }

        public String toString() {
            return "(" + this.children.stream().map(Object::toString).collect(Collectors.joining(" OR ")) + ") ";
        }
    }

    public static class ConstantPredicate
    extends IndexPredicate {
        @Nonnull
        private final ConstantValue value;

        public ConstantPredicate(@Nonnull ConstantValue value) {
            this.value = value;
        }

        @VisibleForTesting
        public ConstantPredicate(@Nonnull com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate predicate) {
            if (predicate == com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate.TRUE) {
                this.value = ConstantValue.TRUE;
            } else if (predicate == com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate.FALSE) {
                this.value = ConstantValue.FALSE;
            } else if (predicate == com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate.NULL) {
                this.value = ConstantValue.NULL;
            }
            throw new RecordCoreException("could not create a PoJo constant index predicate", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.VALUE, predicate});
        }

        public ConstantPredicate(@Nonnull RecordMetaDataProto.ConstantPredicate proto) {
            switch (proto.getValue()) {
                case TRUE: {
                    this.value = ConstantValue.TRUE;
                    break;
                }
                case FALSE: {
                    this.value = ConstantValue.FALSE;
                    break;
                }
                case NULL: {
                    this.value = ConstantValue.NULL;
                    break;
                }
                default: {
                    throw new RecordCoreException("attempt to deserialize unknown constant predicate value", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.VALUE, proto.getValue()});
                }
            }
        }

        @Nonnull
        public ConstantValue getValue() {
            return this.value;
        }

        @Override
        @Nonnull
        public RecordMetaDataProto.Predicate toProto() {
            RecordMetaDataProto.ConstantPredicate.ConstantValue protoValue;
            switch (this.value) {
                case TRUE: {
                    protoValue = RecordMetaDataProto.ConstantPredicate.ConstantValue.TRUE;
                    break;
                }
                case FALSE: {
                    protoValue = RecordMetaDataProto.ConstantPredicate.ConstantValue.FALSE;
                    break;
                }
                case NULL: {
                    protoValue = RecordMetaDataProto.ConstantPredicate.ConstantValue.NULL;
                    break;
                }
                default: {
                    throw new RecordCoreException("attempt to serialize unsupported value", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.VALUE, this.value});
                }
            }
            return RecordMetaDataProto.Predicate.newBuilder().setConstantPredicate(RecordMetaDataProto.ConstantPredicate.newBuilder().setValue(protoValue).build()).build();
        }

        @Override
        @Nonnull
        public QueryPredicate toPredicate(@Nonnull Value value) {
            switch (this.value) {
                case TRUE: {
                    return com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate.TRUE;
                }
                case FALSE: {
                    return com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate.FALSE;
                }
                case NULL: {
                    return com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate.NULL;
                }
            }
            throw new RecordCoreException("attempt to serialize unsupported value", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.VALUE, this.value});
        }

        public String toString() {
            return this.value.name() + " ";
        }

        public static enum ConstantValue {
            TRUE,
            FALSE,
            NULL;

        }
    }

    public static class NotPredicate
    extends IndexPredicate {
        @Nonnull
        private final IndexPredicate value;

        public NotPredicate(@Nonnull IndexPredicate value) {
            this.value = value;
        }

        public NotPredicate(@Nonnull RecordMetaDataProto.NotPredicate notPredicate) {
            this.value = IndexPredicate.fromProto(notPredicate.getChild());
        }

        @VisibleForTesting
        NotPredicate(@Nonnull com.apple.foundationdb.record.query.plan.cascades.predicates.NotPredicate predicate) {
            this.value = IndexPredicate.fromQueryPredicate(predicate.child);
        }

        @Nonnull
        public IndexPredicate getValue() {
            return this.value;
        }

        @Override
        @Nonnull
        public RecordMetaDataProto.Predicate toProto() {
            return RecordMetaDataProto.Predicate.newBuilder().setNotPredicate(RecordMetaDataProto.NotPredicate.newBuilder().setChild(this.value.toProto()).build()).build();
        }

        @Override
        @Nonnull
        public QueryPredicate toPredicate(@Nonnull Value value) {
            return com.apple.foundationdb.record.query.plan.cascades.predicates.NotPredicate.not(this.value.toPredicate(value));
        }

        public String toString() {
            return "(NOT " + String.valueOf(this.value) + ") ";
        }
    }

    public static class ValuePredicate
    extends IndexPredicate {
        @Nonnull
        private final List<String> fieldPath;
        @Nonnull
        private final IndexComparison comparison;

        public ValuePredicate(@Nonnull List<String> fieldPath, @Nonnull IndexComparison comparison) {
            this.fieldPath = ImmutableList.copyOf(fieldPath);
            this.comparison = comparison;
        }

        @VisibleForTesting
        ValuePredicate(@Nonnull com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate predicate) {
            Verify.verify(predicate.getValue() instanceof FieldValue);
            this.fieldPath = ImmutableList.copyOf(((FieldValue)predicate.getValue()).getFieldPathNames());
            this.comparison = IndexComparison.fromComparison(predicate.getComparison());
        }

        public ValuePredicate(@Nonnull RecordMetaDataProto.ValuePredicate proto) {
            Verify.verify(proto.getValueCount() > 0, "attempt to deserialize %s without value", (Object)ValuePredicate.class.getSimpleName());
            Verify.verify(proto.hasComparison(), "attempt to deserialize %s without comparison", (Object)ValuePredicate.class.getSimpleName());
            this.fieldPath = ImmutableList.copyOf(proto.getValueList());
            this.comparison = IndexComparison.fromProto(proto.getComparison());
        }

        @Nonnull
        public List<String> getFieldPath() {
            return this.fieldPath;
        }

        @Nonnull
        public IndexComparison getComparison() {
            return this.comparison;
        }

        @Override
        @Nonnull
        public RecordMetaDataProto.Predicate toProto() {
            return RecordMetaDataProto.Predicate.newBuilder().setValuePredicate(RecordMetaDataProto.ValuePredicate.newBuilder().addAllValue(this.fieldPath).setComparison(this.comparison.toProto()).build()).build();
        }

        @Override
        @Nonnull
        public QueryPredicate toPredicate(@Nonnull Value value) {
            return new com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate(FieldValue.ofFieldNames(value, this.fieldPath), this.comparison.toComparison());
        }

        public String toString() {
            return "(" + this.fieldPath.stream().collect(Collectors.joining("/")) + " " + String.valueOf(this.comparison) + ") ";
        }
    }
}

