/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordFunction;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.google.protobuf.Descriptors;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class IndexRecordFunction<T>
extends RecordFunction<T> {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Index-Record-Function");
    @Nonnull
    private final GroupingKeyExpression operand;
    @Nullable
    private final String index;

    public IndexRecordFunction(@Nonnull String name, @Nonnull GroupingKeyExpression operand, @Nullable String index) {
        super(name);
        this.operand = operand;
        this.index = index;
    }

    @Nonnull
    public GroupingKeyExpression getOperand() {
        return this.operand;
    }

    @Nullable
    public String getIndex() {
        return this.index;
    }

    @Nonnull
    public IndexRecordFunction<T> cloneWithOperand(@Nonnull GroupingKeyExpression operand) {
        return new IndexRecordFunction<T>(this.getName(), operand, this.getIndex());
    }

    @Nonnull
    public IndexRecordFunction<T> cloneWithIndex(@Nonnull String index) {
        return new IndexRecordFunction<T>(this.getName(), this.getOperand(), index);
    }

    @Override
    public void validate(@Nonnull Descriptors.Descriptor descriptor) {
        this.operand.validate(descriptor);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.index != null) {
            str.append(this.index).append('.');
        }
        str.append(this.getName()).append('(').append(this.operand).append(')');
        return str.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexRecordFunction that = (IndexRecordFunction)o;
        return this.operand.equals(that.operand) && Objects.equals(this.index, that.index);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.operand.hashCode();
        if (this.index != null) {
            result = 31 * result + this.index.hashCode();
        }
        return result;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return super.basePlanHash(mode, BASE_HASH, this.operand, this.index);
    }
}

