/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.MetaDataValidator;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyWithValueExpression;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.UNSTABLE)
public class IndexValidator {
    @Nonnull
    protected final Index index;

    public IndexValidator(@Nonnull Index index) {
        this.index = index;
    }

    public void validate(@Nonnull MetaDataValidator metaDataValidator) {
        metaDataValidator.validateIndexForRecordTypes(this.index, this);
        if (this.index.getAddedVersion() > this.index.getLastModifiedVersion()) {
            throw new MetaDataException("Index " + this.index.getName() + " has added version " + this.index.getAddedVersion() + " which is greater than the last modified version " + this.index.getLastModifiedVersion(), new Object[0]);
        }
    }

    public void validateIndexForRecordType(@Nonnull RecordType recordType, @Nonnull MetaDataValidator metaDataValidator) {
        metaDataValidator.validateIndexForRecordType(this.index, recordType);
    }

    protected void validateGrouping(int minGrouped) {
        KeyExpression key = this.index.getRootExpression();
        if (key instanceof GroupingKeyExpression) {
            if (((GroupingKeyExpression)key).getGroupedCount() < minGrouped) {
                throw new KeyExpression.InvalidExpressionException("index type requires grouping at least " + minGrouped + " fields", new Object[]{LogMessageKeys.INDEX_TYPE, this.index.getType(), LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_KEY, key});
            }
        } else {
            throw new KeyExpression.InvalidExpressionException("index type requires grouping", new Object[]{LogMessageKeys.INDEX_TYPE, this.index.getType(), LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_KEY, key});
        }
    }

    protected void validateNotGrouping() {
        KeyExpression key = this.index.getRootExpression();
        if (key instanceof GroupingKeyExpression) {
            throw new KeyExpression.InvalidExpressionException("grouping not possible in index type", new Object[]{LogMessageKeys.INDEX_TYPE, this.index.getType(), LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_KEY, key});
        }
    }

    protected void validateStoresRecordVersions(@Nonnull RecordMetaDataProvider metaDataProvider) {
        if (!metaDataProvider.getRecordMetaData().isStoreRecordVersions()) {
            throw new MetaDataException("index type requires metadata store record version", new Object[]{LogMessageKeys.INDEX_TYPE, this.index.getType(), LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_KEY, this.index.getRootExpression()});
        }
    }

    protected void validateVersionKey() {
        KeyExpression key = this.index.getRootExpression();
        if (key.versionColumns() != 1) {
            throw new KeyExpression.InvalidExpressionException("there must be exactly 1 version entry in index", new Object[]{LogMessageKeys.INDEX_TYPE, this.index.getType(), LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_KEY, key});
        }
    }

    protected void validateVersionInGroupedKeys() {
        KeyExpression key = this.index.getRootExpression();
        this.validateGrouping(1);
        if (key instanceof GroupingKeyExpression) {
            GroupingKeyExpression grouping = (GroupingKeyExpression)key;
            KeyExpression groupingKey = grouping.getGroupingSubKey();
            if (groupingKey.versionColumns() != 0) {
                throw new KeyExpression.InvalidExpressionException("there must be no version entries in grouping key in index", new Object[]{LogMessageKeys.INDEX_TYPE, this.index.getType(), LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_KEY, key});
            }
            KeyExpression groupedKey = grouping.getGroupedSubKey();
            if (groupedKey.versionColumns() != 1) {
                throw new KeyExpression.InvalidExpressionException("there must be exactly 1 version entry in grouped key in index", new Object[]{LogMessageKeys.INDEX_TYPE, this.index.getType(), LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_KEY, key});
            }
        }
    }

    protected void validateNotUnique() {
        if (this.index.isUnique()) {
            throw new MetaDataException("index type does not allow unique indexes", new Object[]{LogMessageKeys.INDEX_TYPE, this.index.getType(), LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_KEY, this.index.getRootExpression()});
        }
    }

    protected void validateNotVersion() {
        KeyExpression key = this.index.getRootExpression();
        if (key.versionColumns() > 0) {
            throw new KeyExpression.InvalidExpressionException("version key not possible in index type", new Object[]{LogMessageKeys.INDEX_TYPE, this.index.getType(), LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_KEY, this.index.getRootExpression()});
        }
    }

    protected void validateNoValue() {
        KeyExpression key = this.index.getRootExpression();
        if (key instanceof KeyWithValueExpression) {
            throw new KeyExpression.InvalidExpressionException("no value expression allowed in index type", new Object[]{LogMessageKeys.INDEX_TYPE, this.index.getType(), LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_KEY, this.index.getRootExpression()});
        }
    }

    @Nonnull
    private Set<String> getChangedOptions(@Nonnull Index oldIndex) {
        String optionName;
        HashSet<String> changedOptions = new HashSet<String>();
        for (Map.Entry<String, String> oldOptionEntry : oldIndex.getOptions().entrySet()) {
            optionName = oldOptionEntry.getKey();
            String newOptionValue = this.index.getOption(optionName);
            if (Objects.equals(oldOptionEntry.getValue(), newOptionValue)) continue;
            changedOptions.add(optionName);
        }
        for (Map.Entry<String, String> newOptionEntry : this.index.getOptions().entrySet()) {
            optionName = newOptionEntry.getKey();
            if (oldIndex.getOptions().containsKey(optionName) || newOptionEntry.getValue() == null) continue;
            changedOptions.add(optionName);
        }
        return changedOptions;
    }

    @API(value=API.Status.EXPERIMENTAL)
    protected void validateChangedOptions(@Nonnull Index oldIndex, @Nonnull Set<String> changedOptions) {
        block8: for (String changedOption : changedOptions) {
            if (changedOption.startsWith("replacedBy")) continue;
            switch (changedOption) {
                case "allowedForQuery": {
                    continue block8;
                }
                case "unique": {
                    if (oldIndex.isUnique() || !this.index.isUnique()) continue block8;
                    throw new MetaDataException("index adds uniqueness constraint", new Object[]{LogMessageKeys.INDEX_NAME, this.index.getName()});
                }
            }
            String oldValue = oldIndex.getOption(changedOption);
            String newValue = this.index.getOption(changedOption);
            throw new MetaDataException("index option changed", new Object[]{LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_OPTION, changedOption, LogMessageKeys.OLD_OPTION, oldValue, LogMessageKeys.NEW_OPTION, newValue});
        }
    }

    @API(value=API.Status.EXPERIMENTAL)
    public void validateChangedOptions(@Nonnull Index oldIndex) {
        this.validateChangedOptions(oldIndex, this.getChangedOptions(oldIndex));
    }
}

