/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.SyntheticRecordType;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.LiteralKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBSyntheticRecord;
import com.apple.foundationdb.record.provider.foundationdb.IndexOrphanBehavior;
import com.apple.foundationdb.record.provider.foundationdb.RecordDoesNotExistException;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Descriptors;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class JoinedRecordType
extends SyntheticRecordType<JoinConstituent> {
    @Nonnull
    private final List<Join> joins;

    protected JoinedRecordType(@Nonnull RecordMetaData metaData, @Nonnull Descriptors.Descriptor descriptor, @Nonnull KeyExpression primaryKey, @Nonnull Object recordTypeKey, @Nonnull List<Index> indexes, @Nonnull List<Index> multiTypeIndexes, @Nonnull List<JoinConstituent> constituents, @Nonnull List<Join> joins) {
        super(metaData, descriptor, primaryKey, recordTypeKey, indexes, multiTypeIndexes, constituents);
        this.joins = joins;
    }

    @Nonnull
    public List<Join> getJoins() {
        return this.joins;
    }

    @Override
    @Nonnull
    @API(value=API.Status.INTERNAL)
    public CompletableFuture<FDBSyntheticRecord> loadByPrimaryKeyAsync(FDBRecordStore store, Tuple primaryKey, IndexOrphanBehavior orphanBehavior) {
        int nconstituents = this.getConstituents().size();
        ConcurrentHashMap constituentValues = new ConcurrentHashMap(nconstituents);
        CompletableFuture[] futures = new CompletableFuture[nconstituents];
        AtomicBoolean isMissingConstituent = new AtomicBoolean(false);
        for (int i = 0; i < nconstituents; ++i) {
            SyntheticRecordType.Constituent constituent = (SyntheticRecordType.Constituent)this.getConstituents().get(i);
            Tuple constituentKey = primaryKey.getNestedTuple(i + 1);
            futures[i] = constituentKey == null ? AsyncUtil.DONE : store.loadRecordAsync(constituentKey).thenApply(rec -> {
                if (rec == null) {
                    if (orphanBehavior.equals((Object)IndexOrphanBehavior.ERROR)) {
                        throw new RecordDoesNotExistException("constituent record not found: " + constituent.getName(), new Object[0]);
                    }
                    isMissingConstituent.set(true);
                } else {
                    constituentValues.put(constituent.getName(), rec);
                }
                return null;
            });
        }
        return CompletableFuture.allOf(futures).thenApply(vignore -> {
            if (!isMissingConstituent.get()) {
                return FDBSyntheticRecord.of(this, constituentValues);
            }
            if (orphanBehavior.equals((Object)IndexOrphanBehavior.SKIP)) {
                return null;
            }
            return FDBSyntheticRecord.of(this, Map.of());
        });
    }

    @Nonnull
    public RecordMetaDataProto.JoinedRecordType toProto() {
        RecordMetaDataProto.JoinedRecordType.Builder typeBuilder = RecordMetaDataProto.JoinedRecordType.newBuilder().setName(this.getName()).setRecordTypeKey(LiteralKeyExpression.toProtoValue(this.getRecordTypeKey()));
        for (JoinConstituent joinConstituent : this.getConstituents()) {
            RecordMetaDataProto.JoinedRecordType.JoinConstituent.Builder constituentBuilder = typeBuilder.addJoinConstituentsBuilder().setName(joinConstituent.getName()).setRecordType(joinConstituent.getRecordType().getName());
            if (!joinConstituent.isOuterJoined()) continue;
            constituentBuilder.setOuterJoined(true);
        }
        for (Join join : this.getJoins()) {
            typeBuilder.addJoinsBuilder().setLeft(join.getLeft().getName()).setLeftExpression(join.getLeftExpression().toKeyExpression()).setRight(join.getRight().getName()).setRightExpression(join.getRightExpression().toKeyExpression());
        }
        return typeBuilder.build();
    }

    public static class JoinConstituent
    extends SyntheticRecordType.Constituent {
        private final boolean outerJoined;

        protected JoinConstituent(String name, RecordType recordType, boolean outerJoined) {
            super(name, recordType);
            this.outerJoined = outerJoined;
        }

        public boolean isOuterJoined() {
            return this.outerJoined;
        }
    }

    public static class Join {
        @Nonnull
        private final JoinConstituent left;
        @Nonnull
        private final KeyExpression leftExpression;
        @Nonnull
        private final JoinConstituent right;
        @Nonnull
        private final KeyExpression rightExpression;

        protected Join(@Nonnull JoinConstituent left, @Nonnull KeyExpression leftExpression, @Nonnull JoinConstituent right, @Nonnull KeyExpression rightExpression) {
            this.left = left;
            this.leftExpression = leftExpression;
            this.right = right;
            this.rightExpression = rightExpression;
        }

        @Nonnull
        public JoinConstituent getLeft() {
            return this.left;
        }

        @Nonnull
        public KeyExpression getLeftExpression() {
            return this.leftExpression;
        }

        @Nonnull
        public JoinConstituent getRight() {
            return this.right;
        }

        @Nonnull
        public KeyExpression getRightExpression() {
            return this.rightExpression;
        }
    }
}

