/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataBuilder;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.metadata.JoinedRecordType;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.RecordTypeBuilder;
import com.apple.foundationdb.record.metadata.SyntheticRecordType;
import com.apple.foundationdb.record.metadata.SyntheticRecordTypeBuilder;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.LiteralKeyExpression;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class JoinedRecordTypeBuilder
extends SyntheticRecordTypeBuilder<JoinConstituent> {
    @Nonnull
    private final List<Join> joins = new ArrayList<Join>();

    public JoinedRecordTypeBuilder(@Nonnull String name, @Nonnull Object recordTypeKey, @Nonnull RecordMetaDataBuilder metaDataBuilder) {
        super(name, recordTypeKey, metaDataBuilder);
    }

    public JoinedRecordTypeBuilder(@Nonnull RecordMetaDataProto.JoinedRecordType typeProto, @Nonnull RecordMetaDataBuilder metaDataBuilder) {
        super(typeProto.getName(), LiteralKeyExpression.fromProtoValue(typeProto.getRecordTypeKey()), metaDataBuilder);
        for (RecordMetaDataProto.JoinedRecordType.JoinConstituent joinConstituent : typeProto.getJoinConstituentsList()) {
            this.addConstituent(joinConstituent.getName(), metaDataBuilder.getRecordType(joinConstituent.getRecordType()), joinConstituent.getOuterJoined());
        }
        for (RecordMetaDataProto.JoinedRecordType.Join join : typeProto.getJoinsList()) {
            this.addJoin(join.getLeft(), KeyExpression.fromProto(join.getLeftExpression()), join.getRight(), KeyExpression.fromProto(join.getRightExpression()));
        }
    }

    @Override
    @Nonnull
    protected JoinConstituent newConstituent(@Nonnull String name, @Nonnull RecordTypeBuilder recordType) {
        return new JoinConstituent(name, recordType, false);
    }

    @Nonnull
    public JoinConstituent addConstituent(@Nonnull String name, @Nonnull RecordTypeBuilder recordType, boolean isOuterJoined) {
        return this.addConstituent(new JoinConstituent(name, recordType, isOuterJoined));
    }

    @Nonnull
    public List<Join> getJoins() {
        return this.joins;
    }

    @Nonnull
    public Join addJoin(@Nonnull String left, @Nonnull KeyExpression leftExpression, @Nonnull String right, @Nonnull KeyExpression rightExpression) {
        if (leftExpression.getColumnSize() != rightExpression.getColumnSize()) {
            throw new RecordCoreArgumentException("Two sides of join are not the same size and will never match", new Object[0]).addLogInfo("left", leftExpression, "right", rightExpression);
        }
        Join join = new Join(left, leftExpression, right, rightExpression);
        this.joins.add(join);
        return join;
    }

    @Nonnull
    public Join addJoin(@Nonnull String left, @Nonnull String leftField, @Nonnull String right, @Nonnull String rightField) {
        Join join = new Join(left, Key.Expressions.field(leftField), right, Key.Expressions.field(rightField));
        this.joins.add(join);
        return join;
    }

    @Nonnull
    public JoinedRecordType build(@Nonnull RecordMetaData metaData, @Nonnull Descriptors.FileDescriptor fileDescriptor) {
        List<JoinedRecordType.JoinConstituent> builtConstituents = this.getConstituents().stream().map(constituent -> constituent.build(metaData)).collect(Collectors.toList());
        Descriptors.Descriptor descriptor = fileDescriptor.findMessageTypeByName(this.name);
        KeyExpression primaryKey = this.buildPrimaryKey();
        Map constituentsByName = builtConstituents.stream().collect(Collectors.toMap(SyntheticRecordType.Constituent::getName, Function.identity()));
        List<JoinedRecordType.Join> builtJoins = this.joins.stream().map(join -> join.build(constituentsByName)).collect(Collectors.toList());
        return new JoinedRecordType(metaData, descriptor, primaryKey, this.recordTypeKey, this.indexes, this.multiTypeIndexes, builtConstituents, builtJoins);
    }

    public static class JoinConstituent
    extends SyntheticRecordTypeBuilder.Constituent {
        private final boolean outerJoined;

        public JoinConstituent(@Nonnull String name, @Nonnull RecordTypeBuilder recordType, boolean outerJoined) {
            super(name, recordType);
            this.outerJoined = outerJoined;
        }

        public boolean isOuterJoined() {
            return this.outerJoined;
        }

        @Nonnull
        JoinedRecordType.JoinConstituent build(@Nonnull RecordMetaData metaData) {
            return new JoinedRecordType.JoinConstituent(this.getName(), metaData.getRecordType(this.getRecordType().getName()), this.outerJoined);
        }
    }

    public static class Join {
        @Nonnull
        private final String left;
        @Nonnull
        private final KeyExpression leftExpression;
        @Nonnull
        private final String right;
        @Nonnull
        private final KeyExpression rightExpression;

        public Join(@Nonnull String left, @Nonnull KeyExpression leftExpression, @Nonnull String right, @Nonnull KeyExpression rightExpression) {
            this.left = left;
            this.leftExpression = leftExpression;
            this.right = right;
            this.rightExpression = rightExpression;
        }

        @Nonnull
        public String getLeft() {
            return this.left;
        }

        @Nonnull
        public KeyExpression getLeftExpression() {
            return this.leftExpression;
        }

        @Nonnull
        public String getRight() {
            return this.right;
        }

        @Nonnull
        public KeyExpression getRightExpression() {
            return this.rightExpression;
        }

        @Nonnull
        protected JoinedRecordType.Join build(@Nonnull Map<String, JoinedRecordType.JoinConstituent> constituentsByName) {
            return new JoinedRecordType.Join(constituentsByName.get(this.left), this.leftExpression, constituentsByName.get(this.right), this.rightExpression);
        }
    }
}

